/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.mixin;

import com.nemonotfound.nemos.inventory.sorting.NemosInventorySortingClientCommon;
import com.nemonotfound.nemos.inventory.sorting.config.DefaultConfigValues;
import com.nemonotfound.nemos.inventory.sorting.config.model.ComponentConfig;
import com.nemonotfound.nemos.inventory.sorting.config.service.ConfigService;
import com.nemonotfound.nemos.inventory.sorting.factory.ButtonCreator;
import com.nemonotfound.nemos.inventory.sorting.factory.DropAllButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.factory.MoveAllButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.factory.MoveSameButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.factory.SortButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.helper.ButtonTypeMapping;
import com.nemonotfound.nemos.inventory.sorting.model.Offset;
import com.nemonotfound.nemos.inventory.sorting.model.Position;
import com.nemonotfound.nemos.inventory.sorting.model.Size;
import com.nemonotfound.nemos.inventory.sorting.model.SlotRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BlastFurnaceMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.FurnaceMenu;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.inventory.SmokerMenu;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin
extends Screen {
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;
    @Shadow
    protected int inventoryLabelY;
    @Shadow
    protected int imageWidth;
    @Unique
    private int nemosInventorySorting$inventoryEndIndex;
    @Unique
    private int nemosInventorySorting$containerSize;
    @Unique
    private final ConfigService nemosInventorySorting$configService = ConfigService.getInstance();
    @Unique
    private final List<AbstractWidget> nemosInventorySorting$widgets = new ArrayList<AbstractWidget>();

    protected AbstractContainerScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        AbstractContainerMenu menu = ((AbstractContainerScreen)this).getMenu();
        this.nemosInventorySorting$inventoryEndIndex = menu.slots.size() - 9;
        if (menu instanceof InventoryMenu) {
            --this.nemosInventorySorting$inventoryEndIndex;
        }
        this.nemosInventorySorting$containerSize = this.nemosInventorySorting$inventoryEndIndex - 27;
        if (NemosInventorySortingClientCommon.MOD_LOADER_HELPER.isModLoaded("nemos_backpacks") && menu instanceof InventoryMenu) {
            --this.nemosInventorySorting$inventoryEndIndex;
            --this.nemosInventorySorting$containerSize;
        }
        List<ComponentConfig> componentConfigs = this.nemosInventorySorting$configService.readOrGetDefaultComponentConfigs();
        if (this.nemosInventorySorting$shouldHaveStorageContainerButtons()) {
            this.nemosInventorySorting$initStorageContainerButtons(componentConfigs);
        }
        if (this.nemosInventorySorting$shouldHaveInventoryButtons()) {
            this.nemosInventorySorting$initInventoryButtons(componentConfigs);
        }
        if (this.nemosInventorySorting$shouldHaveContainerInventorySortingButtons()) {
            this.nemosInventorySorting$initContainerInventoryButtons(componentConfigs);
        }
        for (AbstractWidget widget : this.nemosInventorySorting$widgets) {
            this.addRenderableWidget((GuiEventListener)widget);
        }
    }

    protected void clearWidgets() {
        this.nemosInventorySorting$widgets.clear();
        super.clearWidgets();
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(KeyEvent keyEvent, CallbackInfoReturnable<Boolean> cir) {
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.keyPressed(keyEvent))) {
            cir.setReturnValue((Object)true);
        }
    }

    public boolean keyReleased(@NotNull KeyEvent keyEvent) {
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.keyReleased(keyEvent))) {
            return true;
        }
        return super.keyReleased(keyEvent);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl, CallbackInfoReturnable<Boolean> cir) {
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.mouseClicked(mouseButtonEvent, bl))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private boolean nemosInventorySorting$triggerActionOnWidget(Function<AbstractWidget, Boolean> function) {
        for (AbstractWidget widget : this.nemosInventorySorting$widgets) {
            if (!function.apply(widget).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveStorageContainerButtons() {
        AbstractContainerMenu menu = ((AbstractContainerScreen)this).getMenu();
        return menu instanceof ChestMenu || menu instanceof ShulkerBoxMenu || this.nemosInventorySorting$isModdedContainerMenu(menu, "nemos_backpacks", "com.nemonotfound.nemos.backpacks.world.inventory.BackpackMenu") || this.nemosInventorySorting$isModdedContainerMenu(menu, "reinfchest", "atonkish.reinfcore.screen.ReinforcedStorageScreenHandler") || this.nemosInventorySorting$isModdedContainerMenu(menu, "reinfbarrel", "atonkish.reinfcore.screen.ReinforcedStorageScreenHandler") || this.nemosInventorySorting$isModdedContainerMenu(menu, "reinfshulker", "atonkish.reinfcore.screen.ReinforcedStorageScreenHandler");
    }

    @Unique
    private boolean nemosInventorySorting$isModdedContainerMenu(AbstractContainerMenu menu, String modId, String className) {
        if (NemosInventorySortingClientCommon.MOD_LOADER_HELPER.isModLoaded(modId)) {
            try {
                Class<?> clazz = Class.forName(className);
                if (clazz.isInstance(menu)) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveInventoryButtons() {
        return ((AbstractContainerScreen)this).getMenu() instanceof InventoryMenu;
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveContainerInventorySortingButtons() {
        AbstractContainerMenu menu = ((AbstractContainerScreen)this).getMenu();
        return menu instanceof EnchantmentMenu || menu instanceof FurnaceMenu || menu instanceof SmokerMenu || menu instanceof BlastFurnaceMenu || menu instanceof CraftingMenu || menu instanceof CrafterMenu || menu instanceof GrindstoneMenu || menu instanceof BrewingStandMenu;
    }

    @Unique
    private void nemosInventorySorting$initStorageContainerButtons(List<ComponentConfig> componentConfigs) {
        int defaultInventoryYOffset = ((AbstractContainerScreen)this).getMenu() instanceof ShulkerBoxMenu ? this.inventoryLabelY - 1 : this.inventoryLabelY - 2;
        this.nemosInventorySorting$createButtons(componentConfigs, new ButtonTypeMapping(DefaultConfigValues.SORT_STORAGE_CONTAINER, SortButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.MOVE_SAME_STORAGE_CONTAINER, MoveSameButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.MOVE_ALL_STORAGE_CONTAINER, MoveAllButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_STORAGE_CONTAINER, DropAllButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.SORT_STORAGE_CONTAINER_INVENTORY, SortButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.MOVE_SAME_STORAGE_CONTAINER_INVENTORY, MoveSameButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.MOVE_ALL_STORAGE_CONTAINER_INVENTORY, MoveAllButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_STORAGE_CONTAINER_INVENTORY, DropAllButtonFactory.getInstance(), defaultInventoryYOffset, true));
    }

    @Unique
    private void nemosInventorySorting$initInventoryButtons(List<ComponentConfig> componentConfigs) {
        this.nemosInventorySorting$createButtons(componentConfigs, new ButtonTypeMapping(DefaultConfigValues.SORT_INVENTORY, SortButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_INVENTORY, true), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_INVENTORY, DropAllButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_INVENTORY, true));
    }

    @Unique
    private void nemosInventorySorting$initContainerInventoryButtons(List<ComponentConfig> componentConfigs) {
        int defaultInventoryYOffset = this.inventoryLabelY - 1;
        this.nemosInventorySorting$createButtons(componentConfigs, new ButtonTypeMapping(DefaultConfigValues.SORT_CONTAINER_INVENTORY, SortButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_CONTAINER_INVENTORY, DropAllButtonFactory.getInstance(), defaultInventoryYOffset, true));
    }

    @Unique
    private void nemosInventorySorting$createButtons(List<ComponentConfig> configs, ButtonTypeMapping ... mappings) {
        for (ButtonTypeMapping mapping : mappings) {
            ComponentConfig config;
            Optional<ComponentConfig> optionalConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, mapping.componentName());
            if (optionalConfig.isEmpty() || !(config = optionalConfig.get()).isEnabled()) continue;
            int yOffset = config.yOffset() != null ? config.yOffset().intValue() : mapping.defaultYOffset();
            int xOffset = config.xOffset() != null ? config.xOffset() : this.imageWidth + config.rightXOffset();
            this.nemosInventorySorting$createButton(mapping.factory(), mapping.isInventoryButton(), new Offset(xOffset, yOffset), new Size(config.width(), config.height(), DefaultConfigValues.BUTTON_SIZE));
        }
    }

    @Unique
    private void nemosInventorySorting$createButton(ButtonCreator<?> buttonCreator, boolean isInventoryButton, Offset offset, Size size) {
        int startIndex = isInventoryButton ? this.nemosInventorySorting$containerSize : 0;
        int endIndex = isInventoryButton ? this.nemosInventorySorting$inventoryEndIndex : this.nemosInventorySorting$containerSize;
        SlotRange slotRange = new SlotRange(startIndex, endIndex);
        this.nemosInventorySorting$createButton(buttonCreator, slotRange, offset, size);
    }

    @Unique
    private void nemosInventorySorting$createButton(ButtonCreator<?> buttonCreator, SlotRange slotRange, Offset offset, Size size) {
        Position position = new Position(this.leftPos, this.topPos);
        Object sortButton = buttonCreator.createButton(slotRange, position, offset, size, ((AbstractContainerScreen)this).getMenu());
        this.nemosInventorySorting$widgets.add((AbstractWidget)sortButton);
    }
}

