/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.gui.components.buttons;

import com.nemonotfound.nemos.inventory.sorting.client.InventorySortingKeyMappings;
import com.nemonotfound.nemos.inventory.sorting.config.model.FilterConfig;
import com.nemonotfound.nemos.inventory.sorting.config.service.ConfigService;
import com.nemonotfound.nemos.inventory.sorting.gui.components.buttons.AbstractButton;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.NotNull;

public class ToggleFilterPersistenceButton
extends AbstractButton {
    private final Identifier toggleOffTexture = Identifier.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"filter_persistence_toggle_off");
    private final Identifier toggleOnTexture = Identifier.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"filter_persistence_toggle_on");
    private final Identifier toggleOffHoverTexture = Identifier.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"filter_persistence_toggle_off_highlighted");
    private final Identifier toggleOnHoverTexture = Identifier.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"filter_persistence_toggle_on_highlighted");
    private final Component toggleOnComponent = Component.translatable((String)"nemos_inventory_sorting.gui.toggleFilterPersistence.toggleOn");
    private final Component toggleOffComponent = Component.translatable((String)"nemos_inventory_sorting.gui.toggleFilterPersistence.toggleOff");
    private final ConfigService configService = ConfigService.getInstance();
    private final FilterConfig filterConfig;

    public ToggleFilterPersistenceButton(int x, int y, int xOffset, int width, int height, Component buttonName, FilterConfig filterConfig) {
        super(x, y, xOffset, width, height, buttonName);
        this.filterConfig = filterConfig;
        this.setTooltip();
    }

    private Identifier getToggleOffHoverTexture() {
        return this.toggleOffHoverTexture;
    }

    private Identifier getToggleOnHoverTexture() {
        return this.toggleOnHoverTexture;
    }

    private Identifier getToggleOffTexture() {
        return this.toggleOffTexture;
    }

    private Identifier getToggleOnTexture() {
        return this.toggleOnTexture;
    }

    @Override
    protected Identifier getTexture() {
        return this.filterConfig.isFilterPersistent() ? (this.isHovered() ? this.getToggleOnHoverTexture() : this.getToggleOnTexture()) : (this.isHovered() ? this.getToggleOffHoverTexture() : this.getToggleOffTexture());
    }

    private void setTooltip() {
        Component tooltipComponent = this.filterConfig.isFilterPersistent() ? this.toggleOffComponent : this.toggleOnComponent;
        this.setTooltip(Tooltip.create((Component)tooltipComponent));
    }

    @Override
    public void onClick(@NotNull MouseButtonEvent mouseButtonEvent, boolean isDoubleClick) {
        this.filterConfig.toggleFilterPersistence();
        this.configService.writeConfig(true, "config/nemos-inventory-sorting/filter-config.json", this.filterConfig);
        this.setTooltip();
    }

    @Override
    protected KeyMapping getKeyMapping() {
        return InventorySortingKeyMappings.TOGGLE_FILTER_PERSISTENCE.get();
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }
}

