/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.gui.components.buttons;

import com.nemonotfound.nemos.inventory.sorting.client.InventorySortingKeyMappings;
import com.nemonotfound.nemos.inventory.sorting.gui.components.buttons.AbstractContainerButton;
import com.nemonotfound.nemos.inventory.sorting.model.Position;
import com.nemonotfound.nemos.inventory.sorting.model.Size;
import com.nemonotfound.nemos.inventory.sorting.model.SlotRange;
import com.nemonotfound.nemos.inventory.sorting.service.InventoryService;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class SortButton
extends AbstractContainerButton {
    private final Identifier buttonTexture = Identifier.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"sort_button");
    private final Identifier buttonHoverTexture = Identifier.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"sort_button_highlighted");
    private final InventoryService inventoryService = InventoryService.getInstance();

    public SortButton(Position position, int xOffset, Size size, SlotRange slotRange, Component buttonName, AbstractContainerMenu menu) {
        super(position, xOffset, size, slotRange, buttonName, menu);
    }

    @Override
    protected Identifier getButtonHoverTexture() {
        return this.buttonHoverTexture;
    }

    @Override
    protected Identifier getButtonTexture() {
        return this.buttonTexture;
    }

    @Override
    public void onClick(@NotNull MouseButtonEvent mouseButtonEvent, boolean isDoubleClick) {
        this.inventoryService.handleSorting(this.menu, this.startIndex, this.currentEndIndex);
    }

    @Override
    protected KeyMapping getKeyMapping() {
        if (this.isInventoryButton) {
            return InventorySortingKeyMappings.SORT_INVENTORY.get();
        }
        return InventorySortingKeyMappings.SORT.get();
    }
}

