/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.gui.components.buttons;

import com.nemonotfound.nemos.inventory.sorting.client.InventorySortingKeyMappings;
import com.nemonotfound.nemos.inventory.sorting.gui.components.buttons.AbstractSingleClickButton;
import com.nemonotfound.nemos.inventory.sorting.model.Position;
import com.nemonotfound.nemos.inventory.sorting.model.Size;
import com.nemonotfound.nemos.inventory.sorting.model.SlotRange;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class MoveSameButton
extends AbstractSingleClickButton {
    private final Identifier buttonTexture = Identifier.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"move_same_button");
    private final Identifier buttonHoverTexture = Identifier.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"move_same_button_highlighted");

    public MoveSameButton(Position position, int xOffset, Size size, SlotRange slotRange, Component buttonName, AbstractContainerMenu menu) {
        super(position, xOffset, size, slotRange, buttonName, menu);
    }

    @Override
    protected Identifier getButtonHoverTexture() {
        return this.buttonHoverTexture;
    }

    @Override
    protected Identifier getButtonTexture() {
        return this.buttonTexture;
    }

    @Override
    public void onClick(@NotNull MouseButtonEvent mouseButtonEvent, boolean isDoubleClick) {
        this.interactWithAllItems(ClickType.QUICK_MOVE, 0);
    }

    @Override
    protected KeyMapping getKeyMapping() {
        if (this.isInventoryButton) {
            return InventorySortingKeyMappings.MOVE_SAME_INVENTORY.get();
        }
        return InventorySortingKeyMappings.MOVE_SAME.get();
    }

    @Override
    @NotNull
    protected List<Integer> getItemSlotsToInteractWith(AbstractContainerMenu menu) {
        NonNullList slots = menu.slots;
        List<Item> itemsOutOfIndexRange = this.getItemsOutOfIndexRange((NonNullList<Slot>)slots, this.startIndex, this.currentEndIndex);
        return IntStream.range(this.startIndex, this.currentEndIndex).mapToObj(slotIndex -> Map.entry(slotIndex, ((Slot)slots.get(slotIndex)).getItem())).filter(itemStackEntry -> this.isItemInOtherContainer((ItemStack)itemStackEntry.getValue(), itemsOutOfIndexRange)).map(Map.Entry::getKey).toList();
    }

    private List<Item> getItemsOutOfIndexRange(NonNullList<Slot> slots, int startIndex, int endIndex) {
        return slots.stream().filter(slot -> startIndex != 0 && slot.index < startIndex || startIndex == 0 && slot.index >= endIndex).filter(slot -> !slot.getItem().is(Items.AIR)).map(slot -> slot.getItem().getItem()).distinct().toList();
    }

    private boolean isItemInOtherContainer(ItemStack itemStack, List<Item> itemsOutOfIndexRange) {
        return !itemStack.is(Items.AIR) && itemsOutOfIndexRange.contains(itemStack.getItem());
    }
}

