/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.gui.components.buttons;

import com.nemonotfound.nemos.inventory.sorting.gui.components.buttons.AbstractButton;
import com.nemonotfound.nemos.inventory.sorting.model.Position;
import com.nemonotfound.nemos.inventory.sorting.model.Size;
import com.nemonotfound.nemos.inventory.sorting.model.SlotRange;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractContainerButton
extends AbstractButton {
    protected final AbstractContainerMenu menu;
    protected final Integer startIndex;
    protected final Integer endIndex;
    private final Component buttonName;
    private final Component shiftButtonName;
    protected final boolean isInventoryButton;
    protected int currentEndIndex;

    public AbstractContainerButton(Position position, int xOffset, Size size, SlotRange slotRange, Component buttonName, AbstractContainerMenu menu) {
        super(position, xOffset, size, buttonName);
        this.setTooltip(Tooltip.create((Component)buttonName));
        this.buttonName = buttonName;
        this.shiftButtonName = buttonName.copy().append(" ").append((Component)Component.translatable((String)"nemos_inventory_sorting.gui.includeHotbar"));
        this.menu = menu;
        this.startIndex = slotRange.startIndex();
        this.endIndex = slotRange.endIndex();
        this.isInventoryButton = this.startIndex != 0;
        this.currentEndIndex = this.endIndex;
    }

    @Override
    public boolean keyPressed(@NotNull KeyEvent keyEvent) {
        this.handleShiftKeyEvent(keyEvent);
        return super.keyPressed(keyEvent);
    }

    public boolean keyReleased(@NotNull KeyEvent keyEvent) {
        this.handleShiftKeyEvent(keyEvent);
        return super.keyReleased(keyEvent);
    }

    private void handleShiftKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.key() == 340 || keyEvent.key() == 344) {
            this.setTooltip();
            this.setEndIndex();
        }
    }

    @Override
    protected Identifier getTexture() {
        return this.isHovered() ? this.getButtonHoverTexture() : this.getButtonTexture();
    }

    protected abstract Identifier getButtonHoverTexture();

    protected abstract Identifier getButtonTexture();

    private void setTooltip() {
        if (this.shouldIncludeHotbar()) {
            this.setTooltip(Tooltip.create((Component)this.shiftButtonName));
        } else {
            this.setTooltip(Tooltip.create((Component)this.buttonName));
        }
    }

    private void setEndIndex() {
        this.currentEndIndex = this.shouldIncludeHotbar() ? this.endIndex + 9 : this.endIndex;
    }

    private boolean shouldIncludeHotbar() {
        return Minecraft.getInstance().hasShiftDown() && this.isInventoryButton;
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }
}

