/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.gui.components;

import com.nemonotfound.nemos.inventory.sorting.config.model.FilterConfig;
import com.nemonotfound.nemos.inventory.sorting.config.service.ConfigService;
import com.nemonotfound.nemos.inventory.sorting.gui.components.RecipeBookUpdatable;
import com.nemonotfound.nemos.inventory.sorting.model.FilterResult;
import com.nemonotfound.nemos.inventory.sorting.service.FilterService;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;

public class FilterBox
extends EditBox
implements RecipeBookUpdatable {
    private static final Component FILTER_HINT = Component.translatable((String)"nemos_inventory_sorting.gui.inventory.itemFilter").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    private final FilterService filterService = FilterService.getInstance();
    private final ConfigService configService = ConfigService.getInstance();
    private final int xOffset;

    public FilterBox(Font font, int x, int y, int xOffset, int yOffset, int width, int height, Component message) {
        super(font, x + xOffset, y + yOffset, width, height, message);
        this.xOffset = xOffset;
        this.setTextColor(-1);
        this.setVisible(true);
        this.setMaxLength(50);
        this.setBordered(true);
        this.setCanLoseFocus(true);
        this.setFocused(false);
        this.setHint(FILTER_HINT);
    }

    @Override
    public void updateXPosition(int leftPos) {
        this.setX(leftPos + this.xOffset);
    }

    public Map<FilterResult, List<Slot>> filterSlots(NonNullList<Slot> slots, String filter) {
        return this.filterService.filterSlots(slots, filter);
    }

    public void updateAndSaveFilter(FilterConfig filterConfig) {
        String filter = filterConfig.isFilterPersistent() ? this.getValue() : "";
        filterConfig.setFilter(filter);
        this.configService.writeConfig(true, "config/nemos-inventory-sorting/filter-config.json", filterConfig);
    }
}

