/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.item;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModLoadingContext;

public final class CreativeItemGroup
extends CreativeModeTab {
    private final String modid;
    private final String identifier;
    private final Identifier background;
    private Consumer<Consumer<ItemStack>> filler;
    private Comparator<ItemStack> sorter;
    private List<ItemStack> sortedDisplayItems;

    public static CreativeItemGroup create(String modid, String name, Supplier<ItemStack> icon) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Item group name '" + name + "' must only contain characters [a-z0-9_.-]!");
        }
        String translationKey = modid + ".item_group." + name;
        return new CreativeItemGroup(modid, name, translationKey, icon);
    }

    public static CreativeItemGroup create(String modid, String name, ItemLike icon) {
        return CreativeItemGroup.create(modid, name, () -> icon.asItem().getDefaultInstance());
    }

    public static CreativeItemGroup create(String modid, Supplier<ItemStack> icon) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String translationKey = modid + ".item_group";
        return new CreativeItemGroup(modid, modid, translationKey, icon);
    }

    public static CreativeItemGroup create(String modid, ItemLike icon) {
        return CreativeItemGroup.create(modid, () -> icon.asItem().getDefaultInstance());
    }

    public static CreativeModeTab getBuildingBlocks() {
        return (CreativeModeTab)((Holder.Reference)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.BUILDING_BLOCKS).orElseThrow()).value();
    }

    public static CreativeModeTab getColoredBlocks() {
        return (CreativeModeTab)((Holder.Reference)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.COLORED_BLOCKS).orElseThrow()).value();
    }

    public static CreativeModeTab getNaturalBlocks() {
        return (CreativeModeTab)((Holder.Reference)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.NATURAL_BLOCKS).orElseThrow()).value();
    }

    public static CreativeModeTab getFunctionalBlocks() {
        return (CreativeModeTab)((Holder.Reference)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.FUNCTIONAL_BLOCKS).orElseThrow()).value();
    }

    public static CreativeModeTab getRedstoneBlocks() {
        return (CreativeModeTab)((Holder.Reference)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.REDSTONE_BLOCKS).orElseThrow()).value();
    }

    public static CreativeModeTab getToolsAndUtilities() {
        return (CreativeModeTab)((Holder.Reference)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.TOOLS_AND_UTILITIES).orElseThrow()).value();
    }

    public static CreativeModeTab getCombat() {
        return (CreativeModeTab)((Holder.Reference)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.COMBAT).orElseThrow()).value();
    }

    public static CreativeModeTab getFoodAndDrinks() {
        return (CreativeModeTab)((Holder.Reference)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.FOOD_AND_DRINKS).orElseThrow()).value();
    }

    public static CreativeModeTab getIngredients() {
        return (CreativeModeTab)((Holder.Reference)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.INGREDIENTS).orElseThrow()).value();
    }

    public static CreativeModeTab getSpawnEggs() {
        return (CreativeModeTab)((Holder.Reference)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.SPAWN_EGGS).orElseThrow()).value();
    }

    public static CreativeModeTab getOperatorUtilities() {
        return (CreativeModeTab)((Holder.Reference)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.OP_BLOCKS).orElseThrow()).value();
    }

    public static CreativeModeTab getSearch() {
        return (CreativeModeTab)((Holder.Reference)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.SEARCH).orElseThrow()).value();
    }

    private CreativeItemGroup(String modid, String identifier, String translationKey, Supplier<ItemStack> icon) {
        super(CreativeModeTab.builder((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).icon(icon).title((Component)TextComponents.translation(translationKey).get()));
        this.modid = modid;
        this.identifier = identifier;
        this.background = Identifier.withDefaultNamespace((String)"textures/gui/container/creative_inventory/tab_items.png");
        this.displayItemsGenerator = (flags, output) -> this.applyFiller(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(event -> {
            if (event.getRegistryKey() == Registries.CREATIVE_MODE_TAB) {
                event.register(Registries.CREATIVE_MODE_TAB, Identifier.fromNamespaceAndPath((String)modid, (String)identifier), () -> this);
            }
        });
    }

    private void applyFiller(Consumer<ItemStack> output) {
        if (this.filler != null) {
            this.filler.accept(output);
        }
    }

    public CreativeItemGroup filler(Consumer<Consumer<ItemStack>> filler) {
        this.filler = filler;
        return this;
    }

    public CreativeItemGroup sorter(Comparator<ItemStack> sorter) {
        this.sorter = sorter;
        return this;
    }

    public CreativeItemGroup sortAlphabetically() {
        return this.sorter(Comparator.comparing(stack -> TextComponents.itemStack(stack).format()));
    }

    public void buildContents(CreativeModeTab.ItemDisplayParameters parameters) {
        super.buildContents(parameters);
        if (this.sorter != null) {
            this.sortedDisplayItems = new ArrayList<ItemStack>(this.displayItems);
            this.sortedDisplayItems.sort(this.sorter);
        }
    }

    public Collection<ItemStack> getDisplayItems() {
        return this.sortedDisplayItems == null ? super.getDisplayItems() : this.sortedDisplayItems;
    }

    public Identifier getBackgroundTexture() {
        return this.background;
    }
}

