/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui.widget;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.BaseContainerWidget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import java.util.function.Consumer;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class ObjectBaseContainerWidget<T, C extends AbstractContainerMenu>
extends BaseContainerWidget<C> {
    protected T object;
    private final boolean alwaysRenewObject;

    public ObjectBaseContainerWidget(int x, int y, int width, int height, boolean alwaysRenewObject) {
        super(x, y, width, height);
        this.alwaysRenewObject = alwaysRenewObject;
    }

    public ObjectBaseContainerWidget(int x, int y, int width, int height) {
        this(x, y, width, height, false);
    }

    protected abstract T getObject(T var1);

    protected abstract boolean validateObject(T var1);

    protected boolean validateObjectOrClose() {
        if (this.alwaysRenewObject || !this.validateObject(this.object)) {
            this.object = this.getObject(this.object);
            if (!this.validateObject(this.object)) {
                ClientUtils.closeScreen();
                return false;
            }
        }
        return true;
    }

    @Override
    public final Component getNarrationMessage() {
        return this.validateObjectOrClose() ? this.getNarrationMessage(this.object) : null;
    }

    protected abstract Component getNarrationMessage(T var1);

    @Override
    public final int width() {
        return this.validateObjectOrClose() ? this.width(this.object) : 0;
    }

    protected int width(T object) {
        return super.width();
    }

    @Override
    public final int height() {
        return this.validateObjectOrClose() ? this.height(this.object) : 0;
    }

    protected int height(T object) {
        return super.height();
    }

    @Override
    public final int left() {
        return this.validateObjectOrClose() ? this.width(this.object) : 0;
    }

    protected int left(T object) {
        return super.left();
    }

    @Override
    public final int top() {
        return this.validateObjectOrClose() ? this.top(this.object) : 0;
    }

    protected int top(T object) {
        return super.top();
    }

    @Override
    public final void initialize() {
        if (this.validateObjectOrClose()) {
            this.initialize(this.object);
        }
    }

    @Override
    protected void initialize(T object) {
        super.initialize();
    }

    @Override
    protected void addWidgets() {
        if (this.validateObjectOrClose()) {
            this.addWidgets(this.object);
        }
    }

    protected void addWidgets(T object) {
        super.addWidgets();
    }

    @Override
    public final void update() {
        if (this.validateObjectOrClose()) {
            this.update(this.object);
        }
    }

    protected void update(T object) {
        super.update();
    }

    @Override
    public final void renderBackground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        if (this.validateObjectOrClose()) {
            this.renderBackground(context, graphics, mouseX, mouseY, this.object);
        }
    }

    protected void renderBackground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, T object) {
        super.renderBackground(context, graphics, mouseX, mouseY);
    }

    @Override
    public final void render(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        if (this.validateObjectOrClose()) {
            this.render(context, graphics, mouseX, mouseY, this.object);
        }
    }

    protected void render(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, T object) {
        super.render(context, graphics, mouseX, mouseY);
    }

    @Override
    public final void renderForeground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        if (this.validateObjectOrClose()) {
            this.renderForeground(context, graphics, mouseX, mouseY, this.object);
        }
    }

    protected void renderForeground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, T object) {
        super.renderForeground(context, graphics, mouseX, mouseY);
    }

    @Override
    public final void renderOverlay(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        if (this.validateObjectOrClose()) {
            this.renderOverlay(context, graphics, mouseX, mouseY, this.object);
        }
    }

    protected void renderOverlay(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, T object) {
        super.renderOverlay(context, graphics, mouseX, mouseY);
    }

    @Override
    public final void renderTooltips(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        if (this.validateObjectOrClose()) {
            this.renderTooltips(context, graphics, mouseX, mouseY, this.object);
        }
    }

    protected void renderTooltips(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, T object) {
        super.renderTooltips(context, graphics, mouseX, mouseY);
    }

    @Override
    protected void getTooltips(Consumer<Component> tooltips) {
        if (this.validateObjectOrClose()) {
            this.getTooltips(tooltips, this.object);
        }
    }

    protected void getTooltips(Consumer<Component> tooltips, T object) {
        super.getTooltips(tooltips);
    }

    @Override
    public final boolean mousePressed(int mouseX, int mouseY, MouseButtonInfo info, boolean isDoubleClick, boolean hasBeenHandled) {
        return this.validateObjectOrClose() && this.mousePressed(mouseX, mouseY, info, isDoubleClick, hasBeenHandled, this.object);
    }

    protected boolean mousePressed(int mouseX, int mouseY, MouseButtonInfo info, boolean isDoubleClick, boolean hasBeenHandled, T object) {
        return super.mousePressed(mouseX, mouseY, info, isDoubleClick, hasBeenHandled);
    }

    @Override
    public final boolean mouseReleased(int mouseX, int mouseY, MouseButtonInfo info, boolean hasBeenHandled) {
        return this.validateObjectOrClose() && this.mouseReleased(mouseX, mouseY, info, hasBeenHandled, this.object);
    }

    protected boolean mouseReleased(int mouseX, int mouseY, MouseButtonInfo info, boolean hasBeenHandled, T object) {
        return super.mouseReleased(mouseX, mouseY, info, hasBeenHandled);
    }

    @Override
    public final boolean mouseDragged(int mouseX, int mouseY, MouseButtonInfo info, double deltaX, double deltaY, boolean hasBeenHandled) {
        return this.validateObjectOrClose() && this.mouseDragged(mouseX, mouseY, info, deltaX, deltaY, hasBeenHandled, this.object);
    }

    protected boolean mouseDragged(int mouseX, int mouseY, MouseButtonInfo info, double deltaX, double deltaY, boolean hasBeenHandled, T object) {
        return super.mouseDragged(mouseX, mouseY, info, deltaX, deltaY, hasBeenHandled);
    }

    @Override
    public final boolean mouseScrolled(int mouseX, int mouseY, double scrollAmount, boolean hasBeenHandled) {
        return this.validateObjectOrClose() && this.mouseScrolled(mouseX, mouseY, scrollAmount, hasBeenHandled, this.object);
    }

    protected boolean mouseScrolled(int mouseX, int mouseY, double scrollAmount, boolean hasBeenHandled, T object) {
        return super.mouseScrolled(mouseX, mouseY, scrollAmount, hasBeenHandled);
    }

    @Override
    public final boolean keyPressed(KeyEvent event, boolean hasBeenHandled) {
        return this.validateObjectOrClose() && this.keyPressed(event, hasBeenHandled, this.object);
    }

    protected boolean keyPressed(KeyEvent event, boolean hasBeenHandled, T object) {
        return super.keyPressed(event, hasBeenHandled);
    }

    @Override
    public final boolean keyReleased(KeyEvent event, boolean hasBeenHandled) {
        return this.validateObjectOrClose() && this.keyReleased(event, hasBeenHandled, this.object);
    }

    protected boolean keyReleased(KeyEvent event, boolean hasBeenHandled, T object) {
        return super.keyReleased(event, hasBeenHandled);
    }

    @Override
    public final boolean charTyped(char character, boolean hasBeenHandled) {
        return this.validateObjectOrClose() && this.charTyped(character, hasBeenHandled, this.object);
    }

    protected boolean charTyped(char character, boolean hasBeenHandled, T object) {
        return super.charTyped(character, hasBeenHandled);
    }
}

