/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.gui.CustomSlot;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class CustomSlotImpl
extends Slot
implements CustomSlot {
    private static final Container EMPTY_CONTAINER = new Container(){

        public int getContainerSize() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public ItemStack getItem(int i) {
            return ItemStack.EMPTY;
        }

        public ItemStack removeItem(int i, int j) {
            return ItemStack.EMPTY;
        }

        public ItemStack removeItemNoUpdate(int i) {
            return ItemStack.EMPTY;
        }

        public void setItem(int i, ItemStack itemStack) {
        }

        public void setChanged() {
        }

        public boolean stillValid(Player player) {
            return false;
        }

        public void clearContent() {
        }
    };
    private final int width;
    private final int height;
    private final Supplier<ItemStack> getter;
    private final Consumer<ItemStack> setter;
    private final ToIntFunction<ItemStack> inserter;
    private final Function<Integer, ItemStack> extractor;
    private final ToIntFunction<ItemStack> capacity;
    private final Predicate<ItemStack> filter;
    private final CustomSlot.SlotChangeListener onInsert;
    private final CustomSlot.SlotChangeListener onExtract;
    private final boolean canInsert;
    private final boolean canExtract;
    private final boolean scaleItemToSize;
    private final boolean showBackground;
    private final boolean showItem;
    private final boolean showHighlight;
    private boolean active = true;

    static CustomSlot.Builder builder() {
        return new BuilderImpl();
    }

    private CustomSlotImpl(Container vanillaContainer, int vanillaSlot, int x, int y, int width, int height, Supplier<ItemStack> getter, Consumer<ItemStack> setter, ToIntFunction<ItemStack> inserter, Function<Integer, ItemStack> extractor, ToIntFunction<ItemStack> capacity, Predicate<ItemStack> filter, CustomSlot.SlotChangeListener onInsert, CustomSlot.SlotChangeListener onExtract, boolean canInsert, boolean canExtract, boolean scaleItemToSize, boolean showBackground, boolean showItem, boolean showHighlight) {
        super(vanillaContainer == null ? EMPTY_CONTAINER : vanillaContainer, vanillaSlot, x, y);
        this.width = width;
        this.height = height;
        this.getter = getter == null ? () -> ItemStack.EMPTY : getter;
        Consumer<ItemStack> consumer = this.setter = setter == null ? stack -> {} : setter;
        ToIntFunction<ItemStack> toIntFunction = inserter == null ? (setter == null ? stack -> 0 : stack -> {
            if (stack.isEmpty()) {
                return 0;
            }
            ItemStack currentStack = this.getter.get();
            if (!currentStack.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)currentStack)) {
                return 0;
            }
            int inserted = Math.min(stack.getCount(), stack.getMaxStackSize() - currentStack.getCount());
            if (capacity != null) {
                inserted = Math.min(inserted, capacity.applyAsInt((ItemStack)stack));
            }
            setter.accept(stack.copyWithCount(currentStack.getCount() + inserted));
            return inserted;
        }) : (this.inserter = inserter);
        this.extractor = extractor == null ? (setter == null ? amount -> ItemStack.EMPTY : amount -> {
            if (amount <= 0) {
                return ItemStack.EMPTY;
            }
            ItemStack currentStack = this.getter.get();
            if (currentStack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            int extracted = Math.min(amount, currentStack.getCount());
            ItemStack extractedStack = currentStack.copyWithCount(extracted);
            setter.accept(currentStack.copyWithCount(currentStack.getCount() - extracted));
            return extractedStack;
        }) : extractor;
        this.capacity = capacity == null ? stack -> stack.isEmpty() ? 64 : stack.getMaxStackSize() : capacity;
        this.filter = filter == null ? stack -> true : filter;
        this.onInsert = onInsert == null ? (oldStack, newStack) -> {} : onInsert;
        this.onExtract = onExtract == null ? (oldStack, newStack) -> {} : onExtract;
        this.canInsert = canInsert;
        this.canExtract = canExtract;
        this.scaleItemToSize = scaleItemToSize;
        this.showBackground = showBackground;
        this.showItem = showItem;
        this.showHighlight = showHighlight;
    }

    @Override
    public Slot getVanillaSlot() {
        return this;
    }

    @Override
    public void move(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean scaleItemToSize() {
        return this.scaleItemToSize;
    }

    @Override
    public boolean showBackground() {
        return this.showBackground;
    }

    @Override
    public boolean showItem() {
        return this.showItem;
    }

    @Override
    public boolean showHighlight() {
        return this.showHighlight;
    }

    public boolean mayPlace(ItemStack stack) {
        return this.canInsert && this.filter.test(stack);
    }

    @Override
    public ItemStack getItem() {
        return this.getter.get();
    }

    public void set(ItemStack stack) {
        ItemStack original = this.getter.get();
        this.setter.accept(stack);
        ItemStack newStack = this.getter.get();
        if (!ItemStack.matches((ItemStack)original, (ItemStack)newStack)) {
            if (newStack.isEmpty()) {
                this.onExtract.onChange(original, newStack);
            } else {
                this.onInsert.onChange(original, newStack);
            }
        }
    }

    public int getMaxStackSize() {
        return this.capacity.applyAsInt(ItemStack.EMPTY);
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.capacity.applyAsInt(stack);
    }

    public ItemStack remove(int amount) {
        return this.extractor.apply(amount);
    }

    public boolean mayPickup(Player player) {
        return this.canExtract;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public Optional<ItemStack> tryRemove(int amount, int ignored, Player player) {
        if (!this.mayPickup(player)) {
            return Optional.empty();
        }
        ItemStack original = this.getter.get();
        ItemStack extracted = this.extractor.apply(amount);
        ItemStack newStack = this.getter.get();
        if (!ItemStack.matches((ItemStack)original, (ItemStack)newStack)) {
            this.onInsert.onChange(original, newStack);
        }
        return extracted.isEmpty() ? Optional.empty() : Optional.of(extracted);
    }

    public ItemStack safeInsert(ItemStack stack, int amount) {
        if (stack.isEmpty() || !this.mayPlace(stack)) {
            return stack;
        }
        ItemStack original = this.getter.get();
        int inserted = this.inserter.applyAsInt(stack.copyWithCount(amount));
        stack.shrink(inserted);
        ItemStack newStack = this.getter.get();
        if (!ItemStack.matches((ItemStack)original, (ItemStack)newStack)) {
            this.onExtract.onChange(original, newStack);
        }
        return stack;
    }

    public boolean isHighlightable() {
        return this.showBackground;
    }

    private static class BuilderImpl
    implements CustomSlot.Builder {
        private int x;
        private int y;
        private int width = 18;
        private int height = 18;
        private Supplier<ItemStack> getter;
        private Consumer<ItemStack> setter;
        private ToIntFunction<ItemStack> inserter;
        private Function<Integer, ItemStack> extractor;
        private ToIntFunction<ItemStack> capacity;
        private Predicate<ItemStack> filter;
        private CustomSlot.SlotChangeListener onInsert;
        private CustomSlot.SlotChangeListener onExtract;
        private boolean canInsert = true;
        private boolean canExtract = true;
        private boolean scaleItemToSize = false;
        private boolean showBackground = true;
        private boolean showItem = true;
        private boolean showHighlight = true;
        private Container vanillaContainer;
        private int vanillaSlot;

        private BuilderImpl() {
        }

        @Override
        public CustomSlot.Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        @Override
        public CustomSlot.Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        @Override
        public CustomSlot.Builder size(int size) {
            return this.size(size, size);
        }

        @Override
        public CustomSlot.Builder getter(Supplier<ItemStack> getter) {
            this.getter = getter;
            return this;
        }

        @Override
        public CustomSlot.Builder setter(Consumer<ItemStack> getter) {
            this.setter = getter;
            return this;
        }

        @Override
        public CustomSlot.Builder inserter(ToIntFunction<ItemStack> inserter) {
            this.inserter = inserter;
            return this;
        }

        @Override
        public CustomSlot.Builder extractor(Function<Integer, ItemStack> extractor) {
            this.extractor = extractor;
            return this;
        }

        @Override
        public CustomSlot.Builder capacity(ToIntFunction<ItemStack> capacity) {
            this.capacity = capacity;
            return this;
        }

        @Override
        public CustomSlot.Builder filter(Predicate<ItemStack> filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public CustomSlot.Builder onInsert(CustomSlot.SlotChangeListener onInsert) {
            this.onInsert = onInsert;
            return this;
        }

        @Override
        public CustomSlot.Builder onExtract(CustomSlot.SlotChangeListener onExtract) {
            this.onExtract = onExtract;
            return this;
        }

        @Override
        public CustomSlot.Builder onChange(CustomSlot.SlotChangeListener onChange) {
            return this.onInsert(onChange).onExtract(onChange);
        }

        @Override
        public CustomSlot.Builder vanillaContainer(int index, Container container) {
            this.getter(() -> container.getItem(index));
            this.setter(stack -> {
                container.setItem(index, stack);
                container.setChanged();
            });
            this.inserter(stack -> {
                if (stack.isEmpty()) {
                    return 0;
                }
                ItemStack currentStack = container.getItem(index);
                int amount = Math.min(stack.getCount(), container.getMaxStackSize(stack) - currentStack.getCount());
                if (amount <= 0 || !currentStack.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)currentStack)) {
                    return 0;
                }
                container.setItem(index, stack.copyWithCount(currentStack.getCount() + amount));
                container.setChanged();
                return amount;
            });
            this.extractor(amount -> {
                ItemStack extracted = container.removeItem(index, amount.intValue());
                if (!extracted.isEmpty()) {
                    if (container.getItem(index).isEmpty()) {
                        container.setItem(index, ItemStack.EMPTY);
                    }
                    container.setChanged();
                }
                return extracted;
            });
            this.capacity(stack -> stack.isEmpty() ? container.getMaxStackSize() : container.getMaxStackSize(stack));
            this.vanillaContainer = container;
            this.vanillaSlot = index;
            return this;
        }

        @Override
        public CustomSlot.Builder playerInventory(int index, Inventory inventory) {
            return this.vanillaContainer(index, (Container)inventory);
        }

        @Override
        public CustomSlot.Builder itemHandler(int index, Supplier<ResourceHandler<ItemResource>> handlerSupplier) {
            this.getter(() -> {
                ResourceHandler handler = (ResourceHandler)handlerSupplier.get();
                int amount = handler.getAmountAsInt(index);
                if (amount < 0) {
                    throw new IllegalStateException("Item resource handler of class '" + handler.getClass().getName() + "' returned negative amount for #getAmountAsInt!");
                }
                return ((ItemResource)handler.getResource(index)).toStack(amount);
            });
            this.inserter(stack -> {
                Transaction transaction;
                if (stack.isEmpty()) {
                    return 0;
                }
                ResourceHandler handler = (ResourceHandler)handlerSupplier.get();
                TransactionContext currentOpenedTransaction = Transaction.getCurrentOpenedTransaction();
                try (Transaction transaction2 = transaction = currentOpenedTransaction == null ? Transaction.openRoot() : Transaction.open((TransactionContext)currentOpenedTransaction);){
                    int inserted = handler.insert(index, (Resource)ItemResource.of((ItemStack)stack), stack.getCount(), (TransactionContext)transaction);
                    if (inserted < 0) {
                        throw new IllegalStateException("Item resource handler of class '" + handler.getClass().getName() + "' returned negative amount for #insert!");
                    }
                    transaction.commit();
                    int n = inserted;
                    return n;
                }
            });
            this.extractor(amount -> {
                Transaction transaction;
                if (amount <= 0) {
                    return ItemStack.EMPTY;
                }
                ResourceHandler handler = (ResourceHandler)handlerSupplier.get();
                TransactionContext currentOpenedTransaction = Transaction.getCurrentOpenedTransaction();
                try (Transaction transaction2 = transaction = currentOpenedTransaction == null ? Transaction.openRoot() : Transaction.open((TransactionContext)currentOpenedTransaction);){
                    ItemResource resource = (ItemResource)handler.getResource(index);
                    if (resource.isEmpty()) {
                        ItemStack itemStack = ItemStack.EMPTY;
                        return itemStack;
                    }
                    int extracted = handler.extract(index, (Resource)resource, amount.intValue(), (TransactionContext)transaction);
                    if (extracted < 0) {
                        throw new IllegalStateException("Item resource handler of class '" + handler.getClass().getName() + "' returned negative amount for #extract!");
                    }
                    transaction.commit();
                    ItemStack itemStack = resource.toStack(extracted);
                    return itemStack;
                }
            });
            this.capacity(stack -> {
                ResourceHandler handler = (ResourceHandler)handlerSupplier.get();
                long capacity = handler.getCapacityAsInt(index, (Resource)ItemResource.of((ItemStack)stack));
                if (capacity < 0L) {
                    throw new IllegalStateException("Item resource handler of class '" + handler.getClass().getName() + "' returned negative amount for #getCapacityAsInt!");
                }
                return (int)Math.min(Integer.MAX_VALUE, capacity);
            });
            return this;
        }

        @Override
        public CustomSlot.Builder canInsert(boolean canInsert) {
            this.canInsert = canInsert;
            return this;
        }

        @Override
        public CustomSlot.Builder canExtract(boolean canExtract) {
            this.canExtract = canExtract;
            return this;
        }

        @Override
        public CustomSlot.Builder canInsertExtract(boolean mutable) {
            return this.canExtract(mutable).canInsert(mutable);
        }

        @Override
        public CustomSlot.Builder scaleItemToSize(boolean scaleItemToSize) {
            this.scaleItemToSize = scaleItemToSize;
            return this;
        }

        @Override
        public CustomSlot.Builder scaleItemToSize() {
            return this.scaleItemToSize(true);
        }

        @Override
        public CustomSlot.Builder showBackground(boolean showBackground) {
            this.showBackground = showBackground;
            return this;
        }

        @Override
        public CustomSlot.Builder noBackground() {
            this.showBackground = false;
            return this;
        }

        @Override
        public CustomSlot.Builder showItem(boolean showItem) {
            this.showItem = showItem;
            return this;
        }

        @Override
        public CustomSlot.Builder showHighlight(boolean showHighlight) {
            this.showHighlight = showHighlight;
            return this;
        }

        @Override
        public CustomSlot build() {
            return new CustomSlotImpl(this.vanillaContainer, this.vanillaSlot, this.x, this.y, this.width, this.height, this.getter, this.setter, this.inserter, this.extractor, this.capacity, this.filter, this.onInsert, this.onExtract, this.canInsert, this.canExtract, this.scaleItemToSize, this.showBackground, this.showItem, this.showHighlight);
        }
    }
}

