/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.criterion.DataComponentMatchers;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.predicates.DataComponentPredicate;
import net.minecraft.core.component.predicates.DataComponentPredicates;
import net.minecraft.core.component.predicates.EnchantmentsPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public abstract class LootTableGenerator
extends ResourceGenerator {
    private final Map<Identifier, LootTableBuilder> lootTables = new HashMap<Identifier, LootTableBuilder>();

    public LootTableGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        RegistryOps ops = ResourceGenerator.registryAccess.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        for (LootTableBuilder lootTableBuilder : this.lootTables.values()) {
            JsonObject json = new JsonObject();
            if (lootTableBuilder.parameters != LootContextParamSets.ALL_PARAMS) {
                json.add("type", (JsonElement)LootContextParamSets.CODEC.encodeStart((DynamicOps)ops, (Object)lootTableBuilder.parameters).getOrThrow());
            }
            if (!lootTableBuilder.functions.isEmpty()) {
                JsonArray functionsJson = new JsonArray();
                for (LootItemFunction function : lootTableBuilder.functions) {
                    functionsJson.add((JsonElement)LootItemFunctions.ROOT_CODEC.encodeStart((DynamicOps)ops, (Object)function).getOrThrow());
                }
                json.add("functions", (JsonElement)functionsJson);
            }
            if (!lootTableBuilder.pools.isEmpty()) {
                JsonArray poolsJson = new JsonArray();
                for (LootPoolBuilder pool : lootTableBuilder.pools) {
                    JsonObject poolJson = new JsonObject();
                    if (pool.name != null && !pool.name.isEmpty()) {
                        poolJson.addProperty("name", pool.name);
                    }
                    poolJson.add("rolls", (JsonElement)NumberProviders.CODEC.encodeStart((DynamicOps)ops, (Object)pool.rolls).getOrThrow());
                    if (!(pool.bonusRolls instanceof ConstantValue) || pool.bonusRolls.getInt(null) != 0) {
                        poolJson.add("bonus_rolls", (JsonElement)NumberProviders.CODEC.encodeStart((DynamicOps)ops, (Object)pool.bonusRolls).getOrThrow());
                    }
                    if (!pool.conditions.isEmpty()) {
                        JsonArray conditionsJson = new JsonArray();
                        for (Supplier<LootItemCondition> supplier : pool.conditions) {
                            LootItemCondition condition = supplier.get();
                            if (condition == null) {
                                throw new RuntimeException("Condition supplier for loot pool '" + pool.name + "' in '" + String.valueOf(lootTableBuilder.identifier) + "' returned null!");
                            }
                            conditionsJson.add((JsonElement)LootItemCondition.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)condition).getOrThrow());
                        }
                        poolJson.add("conditions", (JsonElement)conditionsJson);
                    }
                    if (!pool.functions.isEmpty()) {
                        JsonArray functionsJson = new JsonArray();
                        for (LootItemFunction lootItemFunction : pool.functions) {
                            functionsJson.add((JsonElement)LootItemFunctions.ROOT_CODEC.encodeStart((DynamicOps)ops, (Object)lootItemFunction).getOrThrow());
                        }
                        poolJson.add("functions", (JsonElement)functionsJson);
                    }
                    if (pool.entries.isEmpty()) {
                        throw new RuntimeException("Loot table '" + String.valueOf(lootTableBuilder.identifier) + "' has loot pool without any entries!");
                    }
                    JsonArray entriesJson = new JsonArray();
                    for (Supplier<LootItemCondition> supplier : pool.entries) {
                        LootPoolEntryContainer entry = (LootPoolEntryContainer)supplier.get();
                        if (entry == null) {
                            throw new RuntimeException("Entry supplier for loot pool '" + pool.name + "' in '" + String.valueOf(lootTableBuilder.identifier) + "' returned null!");
                        }
                        entriesJson.add((JsonElement)LootPoolEntries.CODEC.encodeStart((DynamicOps)ops, (Object)entry).getOrThrow());
                    }
                    poolJson.add("entries", (JsonElement)entriesJson);
                    poolsJson.add((JsonElement)poolJson);
                }
                json.add("pools", (JsonElement)poolsJson);
            }
            Identifier identifier = lootTableBuilder.identifier;
            this.cache.saveJsonResource(ResourceType.DATA, json, identifier.getNamespace(), "loot_table", identifier.getPath());
        }
    }

    protected LootTableBuilder lootTable(Identifier identifier) {
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, identifier.getNamespace(), "loot_table", identifier.getPath(), ".json");
        return this.lootTables.computeIfAbsent(identifier, LootTableBuilder::new);
    }

    protected LootTableBuilder lootTable(String namespace, String path) {
        return this.lootTable(Identifier.fromNamespaceAndPath((String)namespace, (String)path));
    }

    protected LootTableBuilder lootTable(Block block) {
        Optional lootTable = block.getLootTable();
        if (lootTable.isPresent()) {
            return this.lootTable(((ResourceKey)lootTable.get()).identifier());
        }
        Identifier identifier = Registries.BLOCKS.getIdentifier(block);
        return this.lootTable(identifier.withPrefix("blocks/"));
    }

    protected LootTableBuilder dropSelf(Block block) {
        return this.lootTable(block).blockParameters().pool(poolBuilder -> poolBuilder.survivesExplosionCondition().itemEntry((ItemLike)block));
    }

    protected LootTableBuilder dropSelfWhenSilkTouch(Block block) {
        return this.lootTable(block).blockParameters().pool(poolBuilder -> poolBuilder.hasEnchantmentCondition((ResourceKey<Enchantment>)Enchantments.SILK_TOUCH).itemEntry((ItemLike)block));
    }

    @Override
    public String getName() {
        return this.modName + " Loot Table Generator";
    }

    public static class LootTableBuilder {
        protected final Identifier identifier;
        private final List<LootPoolBuilder> pools = new ArrayList<LootPoolBuilder>();
        private final List<LootItemFunction> functions = new ArrayList<LootItemFunction>();
        private ContextKeySet parameters = LootContextParamSets.ALL_PARAMS;

        protected LootTableBuilder(Identifier identifier) {
            this.identifier = identifier;
        }

        public LootTableBuilder parameters(ContextKeySet parameters) {
            if (LootContextParamSets.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)parameters).error().isPresent()) {
                throw new IllegalArgumentException("Cannot use unregistered parameter set '" + String.valueOf(parameters) + "'!");
            }
            this.parameters = parameters;
            return this;
        }

        public LootTableBuilder blockParameters() {
            return this.parameters(LootContextParamSets.BLOCK);
        }

        public LootTableBuilder chestParameters() {
            return this.parameters(LootContextParamSets.CHEST);
        }

        public LootTableBuilder pool(Consumer<LootPoolBuilder> poolBuilderConsumer) {
            LootPoolBuilder poolBuilder = new LootPoolBuilder();
            poolBuilderConsumer.accept(poolBuilder);
            this.pools.add(poolBuilder);
            return this;
        }

        public LootTableBuilder function(LootItemFunction function) {
            if (BuiltInRegistries.LOOT_FUNCTION_TYPE.getKey((Object)function.getType()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered item function '" + String.valueOf(function) + "'!");
            }
            this.functions.add(function);
            return this;
        }
    }

    public static class LootPoolBuilder {
        private final List<Supplier<LootItemCondition>> conditions = new ArrayList<Supplier<LootItemCondition>>();
        private final List<LootItemFunction> functions = new ArrayList<LootItemFunction>();
        private final List<Supplier<LootPoolEntryContainer>> entries = new ArrayList<Supplier<LootPoolEntryContainer>>();
        private NumberProvider rolls = ConstantValue.exactly((float)1.0f);
        private NumberProvider bonusRolls = ConstantValue.exactly((float)0.0f);
        private String name;

        protected LootPoolBuilder() {
        }

        public LootPoolBuilder rolls(NumberProvider provider) {
            if (BuiltInRegistries.LOOT_NUMBER_PROVIDER_TYPE.getKey((Object)provider.getType()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered number provider '" + String.valueOf(provider) + "'!");
            }
            this.rolls = provider;
            return this;
        }

        public LootPoolBuilder constantRolls(int rolls) {
            return this.rolls((NumberProvider)ConstantValue.exactly((float)rolls));
        }

        public LootPoolBuilder uniformRolls(int min, int max) {
            return this.rolls((NumberProvider)UniformGenerator.between((float)min, (float)max));
        }

        public LootPoolBuilder binomialRolls(int n, int p) {
            return this.rolls((NumberProvider)BinomialDistributionGenerator.binomial((int)n, (float)p));
        }

        public LootPoolBuilder bonusRolls(NumberProvider provider) {
            if (BuiltInRegistries.LOOT_NUMBER_PROVIDER_TYPE.getKey((Object)provider.getType()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered number provider '" + String.valueOf(provider) + "'!");
            }
            this.bonusRolls = provider;
            return this;
        }

        public LootPoolBuilder constantBonusRolls(int rolls) {
            return this.bonusRolls((NumberProvider)ConstantValue.exactly((float)rolls));
        }

        public LootPoolBuilder uniformBonusRolls(int min, int max) {
            return this.bonusRolls((NumberProvider)UniformGenerator.between((float)min, (float)max));
        }

        public LootPoolBuilder binomialBonusRolls(int n, int p) {
            return this.bonusRolls((NumberProvider)BinomialDistributionGenerator.binomial((int)n, (float)p));
        }

        public LootPoolBuilder name(String name) {
            this.name = name;
            return this;
        }

        public LootPoolBuilder condition(LootItemCondition condition) {
            if (BuiltInRegistries.LOOT_CONDITION_TYPE.getKey((Object)condition.getType()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered loot pool condition '" + String.valueOf(condition) + "'!");
            }
            return this.condition(() -> condition);
        }

        public LootPoolBuilder condition(Supplier<LootItemCondition> condition) {
            this.conditions.add(condition);
            return this;
        }

        public LootPoolBuilder survivesExplosionCondition() {
            return this.condition(ExplosionCondition.survivesExplosion().build());
        }

        public LootPoolBuilder hasEnchantmentCondition(ResourceKey<Enchantment> enchantment, int minLevel, int maxLevel) {
            return this.condition(() -> MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withComponents(DataComponentMatchers.Builder.components().partial(DataComponentPredicates.ENCHANTMENTS, (DataComponentPredicate)EnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)ResourceGenerator.registryAccess.lookupOrThrow(net.minecraft.core.registries.Registries.ENCHANTMENT).getOrThrow(enchantment), MinMaxBounds.Ints.between((int)minLevel, (int)maxLevel))))).build())).build());
        }

        public LootPoolBuilder hasEnchantmentCondition(ResourceKey<Enchantment> enchantment, int minLevel) {
            return this.condition(() -> MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withComponents(DataComponentMatchers.Builder.components().partial(DataComponentPredicates.ENCHANTMENTS, (DataComponentPredicate)EnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)ResourceGenerator.registryAccess.lookupOrThrow(net.minecraft.core.registries.Registries.ENCHANTMENT).getOrThrow(enchantment), MinMaxBounds.Ints.atLeast((int)minLevel))))).build())).build());
        }

        public LootPoolBuilder hasEnchantmentCondition(ResourceKey<Enchantment> enchantment) {
            return this.hasEnchantmentCondition(enchantment, 1);
        }

        public LootPoolBuilder entry(LootPoolEntryContainer entry) {
            if (BuiltInRegistries.LOOT_POOL_ENTRY_TYPE.getKey((Object)entry.getType()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered loot pool entry '" + String.valueOf(entry) + "'!");
            }
            return this.entry(() -> entry);
        }

        public LootPoolBuilder entry(Supplier<LootPoolEntryContainer> entry) {
            this.entries.add(entry);
            return this;
        }

        private LootPoolBuilder entry(LootPoolSingletonContainer.Builder<?> entry, int weight) {
            if (weight <= 0) {
                throw new IllegalArgumentException("Loot entry weight must be greater than zero, not '" + weight + "'!");
            }
            return this.entry(entry.setWeight(weight).build());
        }

        private LootPoolBuilder entry(Supplier<LootPoolSingletonContainer.Builder<?>> entry, int weight) {
            if (weight <= 0) {
                throw new IllegalArgumentException("Loot entry weight must be greater than zero, not '" + weight + "'!");
            }
            return this.entry(() -> ((LootPoolSingletonContainer.Builder)entry.get()).setWeight(weight).build());
        }

        public LootPoolBuilder emptyEntry(int weight) {
            return this.entry(EmptyLootItem.emptyItem(), weight);
        }

        public LootPoolBuilder emptyEntry() {
            return this.emptyEntry(1);
        }

        public LootPoolBuilder itemEntry(ItemLike item, int weight) {
            return this.entry(LootItem.lootTableItem((ItemLike)item), weight);
        }

        public LootPoolBuilder itemEntry(ItemLike item) {
            return this.itemEntry(item, 1);
        }

        public LootPoolBuilder itemEntry(ItemLike item, int count, int weight) {
            return this.entry(LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)count))), weight);
        }

        public LootPoolBuilder itemEntry(ItemLike item, int min, int max, int weight) {
            return this.entry(LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max))), weight);
        }

        public LootPoolBuilder itemEntry(Identifier item) {
            if (!Registries.ITEMS.hasIdentifier(item)) {
                throw new IllegalArgumentException("Could not find any item registered under '" + String.valueOf(item) + "'!");
            }
            return this.itemEntry((ItemLike)Registries.ITEMS.getValue(item));
        }

        public LootPoolBuilder itemEntry(String namespace, String identifier) {
            return this.itemEntry(Identifier.fromNamespaceAndPath((String)namespace, (String)identifier));
        }

        public LootPoolBuilder enchantedItemEntry(ItemLike item, int levels, int weight) {
            return this.entry(() -> {
                EnchantWithLevelsFunction.Builder builder = EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)ResourceGenerator.registryAccess, (NumberProvider)ConstantValue.exactly((float)levels));
                return LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)builder);
            }, weight);
        }

        public LootPoolBuilder enchantedItemEntry(ItemLike item, int minLevels, int maxLevels, int weight) {
            return this.entry(() -> {
                EnchantWithLevelsFunction.Builder builder = EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)ResourceGenerator.registryAccess, (NumberProvider)UniformGenerator.between((float)minLevels, (float)maxLevels));
                return LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)builder);
            }, weight);
        }

        public LootPoolBuilder tagEntry(TagKey<Item> tagKey, int weight) {
            return this.entry(TagEntry.tagContents(tagKey), weight);
        }

        public LootPoolBuilder tagEntry(TagKey<Item> tagKey) {
            return this.tagEntry(tagKey, 1);
        }

        public LootPoolBuilder tagEntry(Identifier tag, int weight) {
            return this.tagEntry((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEMS.getVanillaRegistry().key(), (Identifier)tag), weight);
        }

        public LootPoolBuilder tagEntry(Identifier tag) {
            return this.tagEntry((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEMS.getVanillaRegistry().key(), (Identifier)tag));
        }

        public LootPoolBuilder tagEntry(String namespace, String path, int weight) {
            return this.tagEntry(Identifier.fromNamespaceAndPath((String)namespace, (String)path), weight);
        }

        public LootPoolBuilder tagEntry(String namespace, String path) {
            return this.tagEntry(Identifier.fromNamespaceAndPath((String)namespace, (String)path));
        }

        public LootPoolBuilder lootTableEntry(Identifier lootTable, int weight) {
            return this.entry(NestedLootTable.lootTableReference((ResourceKey)ResourceKey.create((ResourceKey)net.minecraft.core.registries.Registries.LOOT_TABLE, (Identifier)lootTable)), weight);
        }

        public LootPoolBuilder lootTableEntry(Identifier lootTable) {
            return this.lootTableEntry(lootTable, 1);
        }

        public LootPoolBuilder lootTableEntry(String namespace, String path, int weight) {
            return this.lootTableEntry(Identifier.fromNamespaceAndPath((String)namespace, (String)path), weight);
        }

        public LootPoolBuilder lootTableEntry(String namespace, String path) {
            return this.lootTableEntry(Identifier.fromNamespaceAndPath((String)namespace, (String)path));
        }

        public LootPoolBuilder function(LootItemFunction function) {
            if (BuiltInRegistries.LOOT_FUNCTION_TYPE.getKey((Object)function.getType()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered item function '" + String.valueOf(function) + "'!");
            }
            this.functions.add(function);
            return this;
        }
    }
}

