/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.generator.aggregator.AtlasSourceAggregator;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.render.TextureAtlases;
import com.supermartijn642.core.util.Pair;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.Identifier;

public abstract class AtlasSourceGenerator
extends ResourceGenerator {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private final Map<Identifier, AtlasBuilder> builders = new HashMap<Identifier, AtlasBuilder>();

    public AtlasSourceGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (Map.Entry<Identifier, AtlasBuilder> atlas : this.builders.entrySet()) {
            Set<Identifier> textures = this.gatherTextures(atlas.getValue());
            Identifier identifier = atlas.getKey();
            this.cache.saveResource(ResourceType.ASSET, AtlasSourceAggregator.INSTANCE, textures, identifier.getNamespace(), "atlases", identifier.getPath(), ".json");
        }
    }

    private Set<Identifier> gatherTextures(AtlasBuilder builder) {
        Identifier parent;
        HashSet<Identifier> textures = new HashSet<Identifier>(builder.textures);
        HashSet<Identifier> parents = new HashSet<Identifier>();
        for (Pair<Identifier, Boolean> pair2 : builder.models) {
            parent = this.readModelData(pair2.left(), true, textures);
            if (parent == null || !pair2.right().booleanValue()) continue;
            parents.add(parent);
        }
        HashSet<Identifier> done = new HashSet<Identifier>();
        builder.models.forEach(pair -> done.add((Identifier)pair.left()));
        while (!parents.isEmpty()) {
            Identifier identifier = (Identifier)parents.iterator().next();
            parents.remove(identifier);
            done.add(identifier);
            parent = this.readModelData(identifier, false, textures);
            if (parent == null || done.contains(parent)) continue;
            parents.add(parent);
        }
        return textures;
    }

    private Identifier readModelData(Identifier model, boolean forced, Set<Identifier> textures) {
        Optional<InputStream> optional = this.cache.getExistingResource(ResourceType.ASSET, model.getNamespace(), "models", model.getPath(), ".json");
        if (optional.isEmpty()) {
            if (forced) {
                throw new RuntimeException("Could not find model '" + String.valueOf(model) + "' to read textures from!");
            }
            return null;
        }
        Identifier parent = null;
        try {
            String identifier;
            JsonObject json = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(optional.get()), JsonObject.class);
            if (json.has("parent") && json.get("parent").isJsonPrimitive() && json.getAsJsonPrimitive("parent").isString() && RegistryUtil.isValidIdentifier(identifier = json.get("parent").getAsString())) {
                parent = Identifier.parse((String)identifier);
            }
            if (json.has("textures") && json.get("textures").isJsonObject()) {
                for (Map.Entry texture : json.getAsJsonObject("textures").entrySet()) {
                    String identifier2;
                    if (!((JsonElement)texture.getValue()).isJsonPrimitive() || !((JsonElement)texture.getValue()).getAsJsonPrimitive().isString() || !RegistryUtil.isValidIdentifier(identifier2 = ((JsonElement)texture.getValue()).getAsString())) continue;
                    textures.add(Identifier.parse((String)identifier2));
                }
            }
        }
        catch (Exception ignore) {
            return null;
        }
        return parent;
    }

    protected AtlasBuilder atlas(Identifier identifier) {
        if (identifier.getPath().startsWith("textures/atlas/") && identifier.getPath().endsWith(".png")) {
            identifier = Identifier.fromNamespaceAndPath((String)identifier.getNamespace(), (String)identifier.getPath().substring("textures/atlas/".length(), identifier.getPath().length() - ".png".length()));
        }
        return this.builders.computeIfAbsent(identifier, i -> new AtlasBuilder(this.modid, (Identifier)i));
    }

    protected AtlasBuilder atlas(String namespace, String identifier) {
        return this.atlas(Identifier.fromNamespaceAndPath((String)namespace, (String)identifier));
    }

    protected AtlasBuilder atlas(String identifier) {
        return this.atlas(this.modid, identifier);
    }

    protected AtlasBuilder blockAtlas() {
        return this.atlas(TextureAtlases.getBlocks());
    }

    protected AtlasBuilder guiAtlas() {
        return this.atlas(TextureAtlases.getGUI());
    }

    @Override
    public String getName() {
        return this.modName + " Atlas Source Generator";
    }

    public static class AtlasBuilder {
        private final String modid;
        private final Identifier identifier;
        private final Set<Identifier> textures = new HashSet<Identifier>();
        private final List<Pair<Identifier, Boolean>> models = new ArrayList<Pair<Identifier, Boolean>>();

        private AtlasBuilder(String modid, Identifier identifier) {
            this.modid = modid;
            this.identifier = identifier;
        }

        public AtlasBuilder texture(Identifier location) {
            this.textures.add(location);
            return this;
        }

        public AtlasBuilder texture(String namespace, String path) {
            return this.texture(Identifier.fromNamespaceAndPath((String)namespace, (String)path));
        }

        public AtlasBuilder texture(String path) {
            return this.texture(this.modid, path);
        }

        public AtlasBuilder texturesFromModel(Identifier model, boolean includeParents) {
            this.models.add(Pair.of(model, includeParents));
            return this;
        }

        public AtlasBuilder texturesFromModel(String namespace, String path, boolean includeParents) {
            return this.texturesFromModel(Identifier.fromNamespaceAndPath((String)namespace, (String)path), includeParents);
        }

        public AtlasBuilder texturesFromModel(String path, boolean includeParents) {
            return this.texturesFromModel(this.modid, path, includeParents);
        }

        public AtlasBuilder texturesFromModel(Identifier model) {
            return this.texturesFromModel(model, true);
        }

        public AtlasBuilder texturesFromModel(String namespace, String path) {
            return this.texturesFromModel(namespace, path, true);
        }

        public AtlasBuilder texturesFromModel(String path) {
            return this.texturesFromModel(path, true);
        }
    }
}

