/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.CoreLibClient;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.data.condition.AndResourceCondition;
import com.supermartijn642.core.data.condition.ModLoadedResourceCondition;
import com.supermartijn642.core.data.condition.NotResourceCondition;
import com.supermartijn642.core.data.condition.OrResourceCondition;
import com.supermartijn642.core.data.condition.TagPopulatedResourceCondition;
import com.supermartijn642.core.data.recipe.ConditionalRecipeSerializer;
import com.supermartijn642.core.data.tag.CustomTagEntries;
import com.supermartijn642.core.data.tag.entries.NamespaceTagEntry;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.standard.CoreLibAtlasSourceGenerator;
import com.supermartijn642.core.generator.standard.CoreLibLanguageGenerator;
import com.supermartijn642.core.generator.standard.CoreLibMiningTagGenerator;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import org.slf4j.Logger;

@Mod(value="supermartijn642corelib")
public class CoreLib {
    public static final Logger LOGGER = CommonUtils.getLogger("supermartijn642corelib");

    public CoreLib(IEventBus eventBus) {
        eventBus.addListener(this::onConstructMod);
        CommonUtils.initialize();
        CustomTagEntries.init();
        if (CommonUtils.getEnvironmentSide().isClient()) {
            CoreLibClient.init();
        }
        RegistrationHandler handler = RegistrationHandler.get("supermartijn642corelib");
        handler.registerRecipeType("dummy", ConditionalRecipeSerializer.DUMMY_RECIPE_TYPE);
        handler.registerRecipeSerializer("conditional", ConditionalRecipeSerializer.INSTANCE);
        handler.registerResourceConditionSerializer("mod_loaded", ModLoadedResourceCondition.SERIALIZER);
        handler.registerResourceConditionSerializer("not", NotResourceCondition.SERIALIZER);
        handler.registerResourceConditionSerializer("or", OrResourceCondition.SERIALIZER);
        handler.registerResourceConditionSerializer("and", AndResourceCondition.SERIALIZER);
        handler.registerResourceConditionSerializer("tag_populated", TagPopulatedResourceCondition.SERIALIZER);
        handler.registerCustomTagEntrySerializer("namespace", NamespaceTagEntry.SERIALIZER);
        handler.registerDataComponentType("tile_data", BaseBlock.TILE_DATA);
        GeneratorRegistrationHandler.get("supermartijn642corelib").addGenerator(cache -> new CoreLibMiningTagGenerator("supermartijn642corelib", (ResourceCache)cache));
        GeneratorRegistrationHandler.get("supermartijn642corelib").addGenerator(cache -> new CoreLibAtlasSourceGenerator("supermartijn642corelib", (ResourceCache)cache));
        GeneratorRegistrationHandler.get("supermartijn642corelib").addGenerator(cache -> new CoreLibLanguageGenerator("supermartijn642corelib", (ResourceCache)cache));
        eventBus.addListener(event -> Registries.ITEMS.getValues().stream().filter(item -> item instanceof BaseItem || item instanceof BaseBlockItem).filter(item -> item instanceof BaseItem ? ((BaseItem)((Object)((Object)item))).isInCreativeGroup(event.getTab()) : ((BaseBlockItem)((Object)((Object)item))).isInCreativeGroup(event.getTab())).forEach(item -> {
            block2: {
                try {
                    event.accept((ItemLike)item, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
                }
                catch (IllegalArgumentException e) {
                    if (e.getMessage().endsWith(" in the tab's list")) break block2;
                    throw e;
                }
            }
        }));
    }

    private void onConstructMod(FMLConstructModEvent e) {
        RegistryEntryAcceptor.Handler.gatherAnnotatedFields();
    }
}

