/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.world.item.crafting.internal;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.blay09.mods.balm.core.BalmRegistrar;
import net.blay09.mods.balm.world.item.crafting.BalmRecipeBookCategoryRegistration;
import net.blay09.mods.balm.world.item.crafting.BalmRecipeDisplayTypeRegistration;
import net.blay09.mods.balm.world.item.crafting.BalmRecipeSerializerRegistration;
import net.blay09.mods.balm.world.item.crafting.BalmRecipeTypeRegistrar;
import net.blay09.mods.balm.world.item.crafting.BalmRecipeTypeRegistration;
import net.blay09.mods.balm.world.item.crafting.BalmSlotDisplayTypeRegistration;
import net.blay09.mods.balm.world.item.crafting.DeferredRecipeType;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public class BalmRecipeTypeRegistrarImpl
implements BalmRecipeTypeRegistrar {
    private final BalmRegistrar registrar;
    private final String namespace;

    public BalmRecipeTypeRegistrarImpl(BalmRegistrar registrar, String namespace) {
        this.registrar = registrar;
        this.namespace = namespace;
    }

    @Override
    public <TRecipeInput extends RecipeInput, TRecipe extends Recipe<TRecipeInput>> BalmRecipeTypeRegistration<TRecipeInput, TRecipe> register(String name, Function<Identifier, ? extends RecipeType<TRecipe>> constructor) {
        Identifier identifier = Identifier.fromNamespaceAndPath((String)this.namespace, (String)name);
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.RECIPE_TYPE, (Identifier)identifier);
        Holder<RecipeType> holder = this.registrar.register(resourceKey, constructor::apply);
        return new RecipeTypeRegistrationImpl(this, holder);
    }

    @Override
    public <TRecipeInput extends RecipeInput, TRecipe extends Recipe<TRecipeInput>> BalmRecipeSerializerRegistration<TRecipe> registerSerializer(String name, Function<Identifier, RecipeSerializer<TRecipe>> constructor) {
        Identifier id = Identifier.fromNamespaceAndPath((String)this.namespace, (String)name);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.RECIPE_SERIALIZER, (Identifier)id);
        Holder<RecipeSerializer> holder = this.registrar.register(key, constructor::apply);
        return new RecipeSerializerRegistrationImpl(holder);
    }

    @Override
    public BalmRecipeBookCategoryRegistration registerBookCategory(String name, Function<Identifier, RecipeBookCategory> constructor) {
        Identifier id = Identifier.fromNamespaceAndPath((String)this.namespace, (String)name);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.RECIPE_BOOK_CATEGORY, (Identifier)id);
        Holder<RecipeBookCategory> holder = this.registrar.register(key, constructor);
        return new RecipeBookCategoryRegistrationImpl(holder);
    }

    @Override
    public <T extends RecipeDisplay.Type<?>> BalmRecipeDisplayTypeRegistration<T> registerDisplayType(String name, Function<Identifier, T> constructor) {
        Identifier id = Identifier.fromNamespaceAndPath((String)this.namespace, (String)name);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.RECIPE_DISPLAY, (Identifier)id);
        Holder<RecipeDisplay.Type> holder = this.registrar.register(key, constructor::apply);
        return new RecipeDisplayTypeRegistrationImpl(holder);
    }

    @Override
    public <T extends SlotDisplay.Type<?>> BalmSlotDisplayTypeRegistration<T> registerSlotDisplayType(String name, Function<Identifier, T> constructor) {
        Identifier id = Identifier.fromNamespaceAndPath((String)this.namespace, (String)name);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.SLOT_DISPLAY, (Identifier)id);
        Holder<SlotDisplay.Type> holder = this.registrar.register(key, constructor::apply);
        return new SlotDisplayTypeRegistrationImpl(holder);
    }

    private static class RecipeTypeRegistrationImpl<TRecipeInput extends RecipeInput, TRecipe extends Recipe<TRecipeInput>>
    implements BalmRecipeTypeRegistration<TRecipeInput, TRecipe> {
        private final BalmRecipeTypeRegistrar recipeTypeRegistrar;
        private final Holder<RecipeType<TRecipe>> holder;
        private @Nullable BalmRecipeSerializerRegistration<TRecipe> serializerRegistration;
        private @Nullable BalmRecipeBookCategoryRegistration bookCategoryRegistration;

        private RecipeTypeRegistrationImpl(BalmRecipeTypeRegistrar recipeTypeRegistrar, Holder<?> holder) {
            this.recipeTypeRegistrar = recipeTypeRegistrar;
            this.holder = holder;
        }

        @Override
        public Holder<RecipeType<TRecipe>> asHolder() {
            return this.holder;
        }

        @Override
        public BalmRecipeTypeRegistration<TRecipeInput, TRecipe> withSerializer(Supplier<RecipeSerializer<TRecipe>> constructor) {
            String name = ((ResourceKey)this.holder.unwrapKey().orElseThrow()).identifier().getPath();
            this.serializerRegistration = this.recipeTypeRegistrar.registerSerializer(name, id -> (RecipeSerializer)constructor.get());
            return this;
        }

        @Override
        public BalmRecipeTypeRegistration<TRecipeInput, TRecipe> withRecipeBookCategory() {
            String name = ((ResourceKey)this.holder.unwrapKey().orElseThrow()).identifier().getPath();
            this.bookCategoryRegistration = this.recipeTypeRegistrar.registerBookCategory(name, id -> new RecipeBookCategory());
            return this;
        }

        @Override
        public DeferredRecipeType<TRecipeInput, TRecipe> asDeferredRecipeType() {
            return new DeferredRecipeTypeImpl(this.holder, this.serializerRegistration != null ? this.serializerRegistration.asHolder() : null, this.bookCategoryRegistration != null ? this.bookCategoryRegistration.asHolder() : null);
        }
    }

    private static class RecipeSerializerRegistrationImpl<T extends Recipe<?>>
    implements BalmRecipeSerializerRegistration<T> {
        private final Holder<RecipeSerializer<T>> holder;

        private RecipeSerializerRegistrationImpl(Holder<?> holder) {
            this.holder = holder;
        }

        @Override
        public Holder<RecipeSerializer<T>> asHolder() {
            return this.holder;
        }
    }

    private static class RecipeBookCategoryRegistrationImpl
    implements BalmRecipeBookCategoryRegistration {
        private final Holder<RecipeBookCategory> holder;

        private RecipeBookCategoryRegistrationImpl(Holder<RecipeBookCategory> holder) {
            this.holder = holder;
        }

        @Override
        public Holder<RecipeBookCategory> asHolder() {
            return this.holder;
        }
    }

    private static class RecipeDisplayTypeRegistrationImpl<T extends RecipeDisplay.Type<?>>
    implements BalmRecipeDisplayTypeRegistration<T> {
        private final Holder<T> holder;

        private RecipeDisplayTypeRegistrationImpl(Holder<?> holder) {
            this.holder = holder;
        }

        @Override
        public Holder<T> asHolder() {
            return this.holder;
        }
    }

    private static class SlotDisplayTypeRegistrationImpl<T extends SlotDisplay.Type<?>>
    implements BalmSlotDisplayTypeRegistration<T> {
        private final Holder<T> holder;

        private SlotDisplayTypeRegistrationImpl(Holder<?> holder) {
            this.holder = holder;
        }

        @Override
        public Holder<T> asHolder() {
            return this.holder;
        }
    }

    private static class DeferredRecipeTypeImpl<TRecipeInput extends RecipeInput, TRecipe extends Recipe<TRecipeInput>>
    implements DeferredRecipeType<TRecipeInput, TRecipe> {
        private final Holder<RecipeType<TRecipe>> type;
        private final @Nullable Holder<RecipeSerializer<TRecipe>> serializer;
        private final @Nullable Holder<RecipeBookCategory> bookCategory;

        private DeferredRecipeTypeImpl(Holder<RecipeType<TRecipe>> type, @Nullable Holder<RecipeSerializer<TRecipe>> serializer, @Nullable Holder<RecipeBookCategory> bookCategory) {
            this.type = type;
            this.serializer = serializer;
            this.bookCategory = bookCategory;
        }

        @Override
        public RecipeSerializer<TRecipe> serializer() {
            if (this.serializer == null) {
                throw new IllegalStateException("Serializer not registered for recipe type " + String.valueOf(((ResourceKey)this.type.unwrapKey().orElseThrow()).identifier()));
            }
            return (RecipeSerializer)this.serializer.value();
        }

        @Override
        public RecipeBookCategory bookCategory() {
            if (this.bookCategory == null) {
                throw new IllegalStateException("Book category not registered for recipe type " + String.valueOf(((ResourceKey)this.type.unwrapKey().orElseThrow()).identifier()));
            }
            return (RecipeBookCategory)this.bookCategory.value();
        }

        @Override
        public Optional<RecipeHolder<TRecipe>> getRecipeFor(Level level, TRecipeInput input, @Nullable ResourceKey<Recipe<?>> lastRecipe) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                RecipeManager recipeManager = serverLevel.getServer().getRecipeManager();
                return recipeManager.getRecipeFor((RecipeType)this.type.value(), input, level, lastRecipe);
            }
            return Optional.empty();
        }

        @Override
        public Optional<RecipeHolder<TRecipe>> getRecipeFor(Level level, TRecipeInput input, @Nullable RecipeHolder<TRecipe> lastRecipe) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                RecipeManager recipeManager = serverLevel.getServer().getRecipeManager();
                return recipeManager.getRecipeFor((RecipeType)this.type.value(), input, level, lastRecipe);
            }
            return Optional.empty();
        }

        @Override
        public RecipeType<TRecipe> type() {
            return (RecipeType)this.type.value();
        }
    }
}

