/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.world.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public final class QuickMove {
    public static final String CONTAINER = "container";
    public static final String PLAYER = "player";
    private static final String PLAYER_INVENTORY = "inventory";
    private static final String PLAYER_HOTBAR = "hotbar";

    private QuickMove() {
    }

    public static Builder create(MoveItemStackTo moveItemStackTo) {
        return new Builder(moveItemStackTo);
    }

    public static Builder create(AbstractContainerMenu menu, MoveItemStackTo moveItemStackTo) {
        int containerSlotCount = menu.slots.size() - 36;
        return new Builder(moveItemStackTo).slotRange(CONTAINER, 0, containerSlotCount).slotRange(PLAYER, containerSlotCount, containerSlotCount + 36).slotRange(PLAYER_INVENTORY, containerSlotCount, containerSlotCount + 27).slotRange(PLAYER_HOTBAR, containerSlotCount + 27, containerSlotCount + 36);
    }

    public static final class Builder {
        private final MoveItemStackTo moveItemStackTo;
        private final List<NamedRange> ranges = new ArrayList<NamedRange>();
        private final List<Route> routes = new ArrayList<Route>();
        private boolean includeDefaultRoutes = true;

        private Builder(MoveItemStackTo moveItemStackTo) {
            this.moveItemStackTo = moveItemStackTo;
        }

        public Builder slot(String name, int slot) {
            this.ranges.add(new NamedRange(name, slot, slot + 1));
            return this;
        }

        public Builder slotRange(String name, int startInclusive, int endExclusive) {
            this.ranges.add(new NamedRange(name, startInclusive, endExclusive));
            return this;
        }

        public Builder route(String sourceRangeName, String targetRangeName) {
            return this.route(sourceRangeName, targetRangeName, false);
        }

        public Builder route(String sourceRangeName, String targetRangeName, boolean reverse) {
            return this.route(it -> true, sourceRangeName, targetRangeName, reverse);
        }

        public Builder route(Predicate<ItemStack> predicate, String sourceRangeName, String targetRangeName) {
            return this.route(predicate, sourceRangeName, targetRangeName, false);
        }

        public Builder route(Predicate<ItemStack> predicate, String sourceRangeName, String targetRangeName, boolean reverse) {
            this.routes.add(new Route(predicate, sourceRangeName, targetRangeName, reverse));
            return this;
        }

        public Builder disableDefaultRoutes() {
            this.includeDefaultRoutes = false;
            return this;
        }

        public Routing build() {
            if (this.includeDefaultRoutes) {
                this.route(QuickMove.CONTAINER, QuickMove.PLAYER);
                this.route(QuickMove.PLAYER, QuickMove.PLAYER);
            }
            return new Routing(List.copyOf(this.ranges), List.copyOf(this.routes), this.moveItemStackTo);
        }
    }

    @FunctionalInterface
    public static interface MoveItemStackTo {
        public boolean moveItemStackTo(ItemStack var1, int var2, int var3, boolean var4);
    }

    public record Routing(List<NamedRange> ranges, List<Route> routes, MoveItemStackTo moveItemStackTo) {
        public ItemStack transfer(AbstractContainerMenu menu, Player player, int index) {
            ItemStack itemStack = ItemStack.EMPTY;
            Slot slot = (Slot)menu.slots.get(index);
            if (!slot.hasItem()) {
                return ItemStack.EMPTY;
            }
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            NamedRange sourceRange = this.findRangeByIndex(index);
            boolean moved = false;
            if (sourceRange != null) {
                for (Route route : this.routes) {
                    NamedRange targetRange;
                    if (!route.sourceName.equals(sourceRange.name) || !route.predicate.test(slotStack) || (targetRange = this.findRangeByName(route.targetName)) == null) continue;
                    if (targetRange.name.equals(QuickMove.PLAYER)) {
                        NamedRange hotbarRange = this.findRangeByName(QuickMove.PLAYER_HOTBAR);
                        NamedRange inventoryRange = this.findRangeByName(QuickMove.PLAYER_INVENTORY);
                        if (hotbarRange != null && !hotbarRange.contains(index) && this.moveItemStackTo.moveItemStackTo(slotStack, hotbarRange.start, hotbarRange.end, !route.reverse)) {
                            moved = true;
                            break;
                        }
                        if (inventoryRange == null || inventoryRange.contains(index) || !this.moveItemStackTo.moveItemStackTo(slotStack, inventoryRange.start, inventoryRange.end, route.reverse)) continue;
                        moved = true;
                        break;
                    }
                    if (!this.moveItemStackTo.moveItemStackTo(slotStack, targetRange.start, targetRange.end, route.reverse)) continue;
                    moved = true;
                    break;
                }
            }
            if (!moved) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
            return itemStack;
        }

        private @Nullable NamedRange findRangeByIndex(int index) {
            for (NamedRange range : this.ranges) {
                if (!range.contains(index)) continue;
                return range;
            }
            return null;
        }

        private @Nullable NamedRange findRangeByName(String name) {
            for (NamedRange range : this.ranges) {
                if (!range.name.equals(name)) continue;
                return range;
            }
            return null;
        }
    }

    protected record Route(Predicate<ItemStack> predicate, String sourceName, String targetName, boolean reverse) {
    }

    protected record NamedRange(String name, int start, int end) {
        boolean contains(int index) {
            return index >= this.start && index < this.end;
        }
    }
}

