/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.world;

import java.util.ArrayList;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public class SubContainer
implements Container,
WorldlyContainer {
    private final Container container;
    private final int minSlot;
    private final int maxSlot;

    public SubContainer(Container container, int minSlot, int maxSlot) {
        this.container = container;
        this.minSlot = minSlot;
        this.maxSlot = maxSlot;
    }

    public int getContainerSize() {
        return this.maxSlot - this.minSlot;
    }

    public ItemStack getItem(int slot) {
        return this.containsSlot(slot) ? this.container.getItem(slot + this.minSlot) : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.containsSlot(slot) ? this.container.removeItem(slot + this.minSlot, amount) : ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.containsSlot(slot) ? this.container.removeItemNoUpdate(slot + this.minSlot) : ItemStack.EMPTY;
    }

    public void setItem(int slot, ItemStack itemStack) {
        if (this.containsSlot(slot)) {
            this.container.setItem(slot + this.minSlot, itemStack);
        }
    }

    public void startOpen(ContainerUser user) {
        this.container.startOpen(user);
    }

    public void stopOpen(ContainerUser user) {
        this.container.stopOpen(user);
    }

    public boolean canPlaceItem(int slot, ItemStack itemStack) {
        return this.containsSlot(slot) && this.container.canPlaceItem(slot + this.minSlot, itemStack);
    }

    public boolean isEmpty() {
        for (int i = this.minSlot; i < this.maxSlot; ++i) {
            if (this.container.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public int getMaxStackSize() {
        return this.container.getMaxStackSize();
    }

    public void setChanged() {
        this.container.setChanged();
    }

    private boolean containsSlot(int slot) {
        return slot + this.minSlot < this.maxSlot;
    }

    public boolean containsOuterSlot(int slot) {
        return slot >= this.minSlot && slot < this.maxSlot;
    }

    public void clearContent() {
        for (int i = this.minSlot; i < this.maxSlot; ++i) {
            this.container.setItem(i, ItemStack.EMPTY);
        }
    }

    public boolean canTakeItem(Container container, int slot, ItemStack itemStack) {
        return this.containsSlot(slot) && this.container.canTakeItem(this.container, slot + this.minSlot, itemStack);
    }

    public int[] getSlotsForFace(Direction direction) {
        Container container = this.container;
        if (container instanceof WorldlyContainer) {
            WorldlyContainer worldContainer = (WorldlyContainer)container;
            int[] original = worldContainer.getSlotsForFace(direction);
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (int outerSlot : original) {
                if (!this.containsOuterSlot(outerSlot)) continue;
                result.add(outerSlot - this.minSlot);
            }
            return result.stream().mapToInt(i -> i).toArray();
        }
        int[] result = new int[this.getContainerSize()];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = i2;
        }
        return result;
    }

    public int[] getOuterSlotsForFace(Direction direction) {
        Container container = this.container;
        if (container instanceof WorldlyContainer) {
            WorldlyContainer worldContainer = (WorldlyContainer)container;
            int[] original = worldContainer.getSlotsForFace(direction);
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (int outerSlot : original) {
                if (!this.containsOuterSlot(outerSlot)) continue;
                result.add(outerSlot);
            }
            return result.stream().mapToInt(i -> i).toArray();
        }
        int[] slots = new int[this.maxSlot - this.minSlot];
        for (int i2 = 0; i2 < slots.length; ++i2) {
            slots[i2] = i2 + this.minSlot;
        }
        return slots;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack itemStack, @Nullable Direction direction) {
        Container container = this.container;
        if (container instanceof WorldlyContainer) {
            WorldlyContainer worldlyContainer = (WorldlyContainer)container;
            return this.containsSlot(slot) && worldlyContainer.canPlaceItemThroughFace(slot + this.minSlot, itemStack, direction);
        }
        return this.canPlaceItem(slot, itemStack);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack itemStack, Direction direction) {
        Container container = this.container;
        if (container instanceof WorldlyContainer) {
            WorldlyContainer worldlyContainer = (WorldlyContainer)container;
            return this.containsSlot(slot) && worldlyContainer.canTakeItemThroughFace(slot + this.minSlot, itemStack, direction);
        }
        return this.canTakeItem(this, slot, itemStack);
    }
}

