/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.world;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ImplementedContainer
extends Container {
    public static final Logger LOGGER = LoggerFactory.getLogger(ImplementedContainer.class);

    public static ImplementedContainer of(NonNullList<ItemStack> items) {
        return () -> items;
    }

    public static ImplementedContainer ofSize(int size) {
        return ImplementedContainer.of((NonNullList<ItemStack>)NonNullList.withSize((int)size, (Object)ItemStack.EMPTY));
    }

    public NonNullList<ItemStack> getItems();

    default public int getContainerSize() {
        return this.getItems().size();
    }

    default public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack getItem(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    default public ItemStack removeItem(int slot, int count) {
        ItemStack result = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)count);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        this.slotChanged(slot);
        return result;
    }

    default public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = ContainerHelper.takeItem(this.getItems(), (int)slot);
        this.slotChanged(slot);
        return itemStack;
    }

    default public void setItem(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
        this.slotChanged(slot);
    }

    default public void clearContent() {
        this.getItems().clear();
        for (int i = 0; i < this.getItems().size(); ++i) {
            this.slotChanged(i);
        }
    }

    default public void setChanged() {
    }

    default public void slotChanged(int slot) {
    }

    default public boolean stillValid(Player player) {
        return true;
    }

    default public void copyFrom(Container container) {
        for (int i = 0; i < container.getContainerSize(); ++i) {
            this.setItem(i, container.getItem(i));
        }
    }
}

