/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.world;

import net.blay09.mods.balm.world.ContainerUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public interface BalmContainerProvider {
    public @Nullable Container getContainer();

    default public @Nullable Container getContainer(Direction side) {
        return this.getContainer();
    }

    default public void dropItems(Level level, BlockPos pos) {
        Container container = this.getContainer();
        if (container != null) {
            ContainerUtils.dropItems(container, level, pos);
        }
    }

    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        Container container = this.getContainer();
        if (container != null) {
            return ContainerUtils.extractItem(container, slot, amount, simulate);
        }
        return ItemStack.EMPTY;
    }

    default public ItemStack insertItem(ItemStack itemStack, int slot, boolean simulate) {
        Container container = this.getContainer();
        if (container != null) {
            return ContainerUtils.insertItem(container, slot, itemStack, simulate);
        }
        return itemStack;
    }

    default public ItemStack insertItemStacked(ItemStack itemStack, boolean simulate) {
        Container container = this.getContainer();
        if (container != null) {
            return ContainerUtils.insertItemStacked(container, itemStack, simulate);
        }
        return itemStack;
    }
}

