/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.fluid;

import net.blay09.mods.balm.platform.fluid.FluidTank;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class DefaultFluidTank
implements FluidTank {
    private final int capacity;
    private final int maxFill;
    private final int maxDrain;
    private Fluid fluid = Fluids.EMPTY;
    private int amount;

    public DefaultFluidTank(int capacity) {
        this(capacity, capacity, capacity, 0);
    }

    public DefaultFluidTank(int capacity, int maxTransfer) {
        this(maxTransfer, capacity, maxTransfer, 0);
    }

    public DefaultFluidTank(int capacity, int maxFill, int maxDrain) {
        this(maxDrain, capacity, maxFill, 0);
    }

    public DefaultFluidTank(int maxDrain, int capacity, int maxFill, int amount) {
        this.capacity = capacity;
        this.maxFill = maxFill;
        this.maxDrain = maxDrain;
        this.amount = Math.max(0, Math.min(capacity, amount));
    }

    @Override
    public int fill(Fluid fluid, int maxFill, boolean simulate) {
        if (!this.canFill(fluid)) {
            return 0;
        }
        if (this.fluid.isSame(Fluids.EMPTY)) {
            this.fluid = fluid;
        }
        int filled = Math.min(this.capacity - this.amount, Math.min(this.maxFill, maxFill));
        if (!simulate) {
            this.amount += filled;
            this.setChanged();
        }
        return filled;
    }

    @Override
    public int drain(Fluid fluid, int maxDrain, boolean simulate) {
        if (!this.canDrain(fluid)) {
            return 0;
        }
        int drained = Math.min(this.amount, Math.min(this.maxDrain, maxDrain));
        if (!simulate) {
            this.amount -= drained;
            this.setChanged();
        }
        return drained;
    }

    @Override
    public Fluid getFluid() {
        return this.amount >= 0 ? this.fluid : Fluids.EMPTY;
    }

    @Override
    public void setFluid(Fluid fluid, int amount) {
        this.fluid = fluid;
        this.amount = amount;
        this.setChanged();
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean canDrain(Fluid fluid) {
        return (this.fluid.isSame(fluid) || this.fluid.isSame(Fluids.EMPTY)) && this.maxDrain > 0;
    }

    @Override
    public boolean canFill(Fluid fluid) {
        return (this.fluid.isSame(fluid) || this.fluid.isSame(Fluids.EMPTY)) && this.maxFill > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.amount <= 0 || this.fluid.isSame(Fluids.EMPTY);
    }

    public void serialize(ValueOutput output) {
        output.putString("Fluid", BuiltInRegistries.FLUID.getKey((Object)this.fluid).toString());
        output.putInt("Amount", this.amount);
    }

    public void deserialize(ValueInput input) {
        this.fluid = input.getString("Fluid").map(Identifier::tryParse).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getValue(arg_0)).orElse(Fluids.EMPTY);
        this.amount = input.getIntOr("Amount", 0);
    }

    public void setChanged() {
    }
}

