/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.config.notoml;

import com.google.common.collect.Table;
import java.io.IOException;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.platform.config.notoml.Notoml;
import net.minecraft.resources.Identifier;
import net.minecraft.util.StringRepresentable;

public class NotomlSerializer {
    public static void serialize(Writer writer, Notoml notoml) throws IOException {
        writer.write(NotomlSerializer.serializeToString(notoml));
    }

    private static String serializeToString(Notoml notoml) {
        StringBuilder sb = new StringBuilder();
        Table<String, String, Object> data = notoml.getProperties();
        Table<String, String, String> comments = notoml.getComments();
        List sortedCategoryKeys = data.rowKeySet().stream().sorted().toList();
        for (String category : sortedCategoryKeys) {
            String categoryComment = (String)comments.get((Object)category, (Object)"");
            if (categoryComment != null && !categoryComment.isEmpty()) {
                sb.append("\n").append("# ").append(categoryComment).append("\n");
            }
            if (!category.isEmpty()) {
                sb.append("[").append(category).append("]").append("\n");
            }
            Map categoryProperties = data.row((Object)category);
            List sortedPropertyKeys = categoryProperties.keySet().stream().sorted().toList();
            for (String property : sortedPropertyKeys) {
                Object value;
                String propertyComment = (String)comments.get((Object)category, (Object)property);
                if (propertyComment != null && !propertyComment.isEmpty()) {
                    sb.append("\n").append("# ").append(propertyComment).append("\n");
                }
                sb.append(property).append(" = ");
                Object v = value = categoryProperties.get(property);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Identifier.class, Collection.class, StringRepresentable.class, Enum.class}, v, n)) {
                    case 0: {
                        String stringValue = (String)v;
                        if (stringValue.contains("\n")) {
                            sb.append("\"\"\"\n").append(value).append("\n\"\"\"");
                            break;
                        }
                        sb.append("\"").append(stringValue.replace("\"", "\\\"")).append("\"");
                        break;
                    }
                    case 1: {
                        Identifier identifierValue = (Identifier)v;
                        sb.append("\"").append(identifierValue).append("\"");
                        break;
                    }
                    case 2: {
                        Collection listValue = (Collection)v;
                        NotomlSerializer.serializeList(listValue, sb);
                        break;
                    }
                    case 3: {
                        StringRepresentable stringRepresentable = (StringRepresentable)v;
                        sb.append("\"").append(stringRepresentable.getSerializedName()).append("\"");
                        break;
                    }
                    case 4: {
                        Enum enumValue = (Enum)v;
                        sb.append("\"").append(enumValue.name()).append("\"");
                        break;
                    }
                    default: {
                        sb.append(value);
                    }
                }
                sb.append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private static void serializeList(Collection<?> list, StringBuilder sb) {
        sb.append("[ ");
        boolean newLines = list.size() > 3;
        boolean first = true;
        block6: for (Object value : list) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            if (newLines) {
                sb.append("\n");
            }
            if (newLines) {
                sb.append("    ");
            }
            Object obj = value;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Identifier.class, StringRepresentable.class, Enum.class}, obj, n)) {
                case 0: {
                    String stringValue = (String)obj;
                    sb.append("\"").append(stringValue.replace("\"", "\\\"")).append("\"");
                    continue block6;
                }
                case 1: {
                    Identifier identifierValue = (Identifier)obj;
                    sb.append("\"").append(identifierValue).append("\"");
                    continue block6;
                }
                case 2: {
                    StringRepresentable stringRepresentable = (StringRepresentable)obj;
                    sb.append("\"").append(stringRepresentable.getSerializedName()).append("\"");
                    continue block6;
                }
                case 3: {
                    Enum enumValue = (Enum)obj;
                    sb.append("\"").append(enumValue.name()).append("\"");
                    continue block6;
                }
            }
            sb.append(value);
        }
        if (newLines) {
            sb.append("\n]");
        } else {
            sb.append(" ]");
        }
    }
}

