/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.capabilities.internal;

import net.blay09.mods.balm.platform.capabilities.BalmCapabilities;
import net.blay09.mods.balm.platform.capabilities.CommonCapabilities;
import net.blay09.mods.balm.platform.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.platform.energy.EnergyStorage;
import net.blay09.mods.balm.platform.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.platform.fluid.FluidTank;
import net.blay09.mods.balm.world.BalmContainerProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.Block;

public class CommonCapabilitiesImpl {
    public static void registerCapabilities(BalmCapabilities capabilities) {
        CommonCapabilities.CONTAINER = capabilities.registerType(CommonCapabilitiesImpl.id("container"), Block.class, Container.class, Direction.class);
        CommonCapabilities.FLUID_TANK = capabilities.registerType(CommonCapabilitiesImpl.id("fluid_tank"), Block.class, FluidTank.class, Direction.class);
        CommonCapabilities.ENERGY_STORAGE = capabilities.registerType(CommonCapabilitiesImpl.id("energy_storage"), Block.class, EnergyStorage.class, Direction.class);
        capabilities.registerFallbackBlockEntityProvider(CommonCapabilitiesImpl.id("container"), CommonCapabilities.CONTAINER, (blockEntity, direction) -> {
            if (blockEntity instanceof BalmContainerProvider) {
                BalmContainerProvider provider = (BalmContainerProvider)blockEntity;
                if (direction != null) {
                    return provider.getContainer((Direction)direction);
                }
                return provider.getContainer();
            }
            return null;
        });
        capabilities.registerFallbackBlockEntityProvider(CommonCapabilitiesImpl.id("fluid_tank"), CommonCapabilities.FLUID_TANK, (blockEntity, direction) -> {
            if (blockEntity instanceof BalmFluidTankProvider) {
                BalmFluidTankProvider provider = (BalmFluidTankProvider)blockEntity;
                if (direction != null) {
                    return provider.getFluidTank((Direction)direction);
                }
                return provider.getFluidTank();
            }
            return null;
        });
        capabilities.registerFallbackBlockEntityProvider(CommonCapabilitiesImpl.id("energy_storage"), CommonCapabilities.ENERGY_STORAGE, (blockEntity, direction) -> {
            if (blockEntity instanceof BalmEnergyStorageProvider) {
                BalmEnergyStorageProvider provider = (BalmEnergyStorageProvider)blockEntity;
                if (direction != null) {
                    return provider.getEnergyStorage((Direction)direction);
                }
                return provider.getEnergyStorage();
            }
            return null;
        });
    }

    private static Identifier id(String path) {
        return Identifier.fromNamespaceAndPath((String)"balm", (String)path);
    }
}

