/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.network.protocol.common.custom.internal;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Predicate;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.platform.config.LoadedConfig;
import net.blay09.mods.balm.platform.config.MutableLoadedConfig;
import net.blay09.mods.balm.platform.config.PropertyAwareConfig;
import net.blay09.mods.balm.platform.config.internal.AbstractBalmConfig;
import net.blay09.mods.balm.platform.config.internal.ConfigSync;
import net.blay09.mods.balm.platform.config.internal.LoadedTableConfig;
import net.blay09.mods.balm.platform.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.platform.config.schema.ConfiguredProperty;
import net.blay09.mods.balm.platform.config.schema.builder.ConfigCategory;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ClientboundConfigPacket(BalmConfigSchema schema, LoadedConfig config) implements CustomPacketPayload
{
    private static final Logger logger = LoggerFactory.getLogger(ClientboundConfigPacket.class);
    public static final CustomPacketPayload.Type<ClientboundConfigPacket> TYPE = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"balm", (String)"config"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundConfigPacket> STREAM_CODEC = StreamCodec.of(ClientboundConfigPacket::encode, ClientboundConfigPacket::decode);

    private static ClientboundConfigPacket decode(RegistryFriendlyByteBuf buf) {
        Identifier identifier = (Identifier)Identifier.STREAM_CODEC.decode((Object)buf);
        BalmConfigSchema schema = Balm.config().getSchema(identifier);
        if (schema == null) {
            throw new RuntimeException("Received config packet for unknown schema: " + String.valueOf(identifier));
        }
        LoadedTableConfig config = new LoadedTableConfig();
        int rootPropertyCount = buf.readVarInt();
        for (int j = 0; j < rootPropertyCount; ++j) {
            String property = buf.readUtf();
            ConfiguredProperty<?> propertySchema = schema.findRootProperty(property);
            if (propertySchema == null) {
                throw new RuntimeException("Received config packet for unknown root property: " + property);
            }
            ClientboundConfigPacket.decodePropertyInto(propertySchema, (ByteBuf)buf, config);
        }
        int categoryCount = buf.readVarInt();
        for (int i = 0; i < categoryCount; ++i) {
            String category = buf.readUtf();
            int propertyCount = buf.readVarInt();
            for (int j = 0; j < propertyCount; ++j) {
                String property = buf.readUtf();
                ConfiguredProperty<?> propertySchema = schema.findProperty(category, property);
                if (propertySchema == null) {
                    throw new RuntimeException("Received config packet for unknown property: " + property);
                }
                ClientboundConfigPacket.decodePropertyInto(propertySchema, (ByteBuf)buf, config);
            }
        }
        return new ClientboundConfigPacket(schema, config);
    }

    private static void encode(RegistryFriendlyByteBuf buf, ClientboundConfigPacket packet) {
        Identifier.STREAM_CODEC.encode((Object)buf, (Object)packet.schema.identifier());
        List<ConfiguredProperty> rootProperties = packet.schema.rootProperties().stream().filter(ConfigSync::isSyncedProperty).toList();
        buf.writeVarInt(rootProperties.size());
        for (ConfiguredProperty rootProperty : rootProperties) {
            buf.writeUtf(rootProperty.name());
            ClientboundConfigPacket.encodeProperty(rootProperty, (ByteBuf)buf, packet.config);
        }
        List<ConfigCategory> categories = packet.schema.categories().stream().filter(ConfigSync::hasSyncedProperties).toList();
        buf.writeVarInt(categories.size());
        for (ConfigCategory category : categories) {
            buf.writeUtf(category.name());
            List<ConfiguredProperty> properties = category.properties().stream().filter(ConfigSync::isSyncedProperty).toList();
            buf.writeVarInt(properties.size());
            for (ConfiguredProperty property : properties) {
                buf.writeUtf(property.name());
                ClientboundConfigPacket.encodeProperty(property, (ByteBuf)buf, packet.config);
            }
        }
    }

    private static <T> void decodePropertyInto(ConfiguredProperty<T> property, ByteBuf buf, MutableLoadedConfig config) {
        Object value = property.streamCodec().decode((Object)buf);
        config.setRaw(property, value);
    }

    private static <T> void encodeProperty(ConfiguredProperty<T> property, ByteBuf buf, LoadedConfig config) {
        T value = config.getRaw(property);
        property.streamCodec().encode((Object)buf, value);
    }

    public static void handle(Player player, ClientboundConfigPacket packet) {
        MutableLoadedConfig localConfig = Balm.config().getLocalConfig(packet.schema);
        if (localConfig != null) {
            Predicate<ConfiguredProperty<?>> predicate;
            MutableLoadedConfig newConfig = localConfig.copy();
            Object object = packet.config;
            if (object instanceof PropertyAwareConfig) {
                PropertyAwareConfig propertyAwareConfig = (PropertyAwareConfig)object;
                predicate = propertyAwareConfig::hasProperty;
            } else {
                predicate = it -> true;
            }
            Predicate<ConfiguredProperty<?>> propertyFilter = predicate;
            newConfig.applyFrom(packet.schema, packet.config, propertyFilter);
            object = Balm.config();
            if (object instanceof AbstractBalmConfig) {
                AbstractBalmConfig config = (AbstractBalmConfig)object;
                config.setActiveConfig(packet.schema, newConfig);
            }
        } else {
            logger.error("Received config packet for unknown schema: {}", (Object)packet.schema.identifier());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

