/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.world.level.levelgen.internal;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.balm.forge.world.level.biome.internal.ForgeBiomeModificationBuilder;
import net.blay09.mods.balm.forge.world.level.levelgen.internal.BalmBiomeModifier;
import net.blay09.mods.balm.world.level.biome.BiomeModifier;
import net.blay09.mods.balm.world.level.biome.BiomePredicate;
import net.blay09.mods.balm.world.level.levelgen.BalmWorldGen;
import net.minecraft.core.Holder;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgeBalmWorldGen
implements BalmWorldGen {
    public static final MapCodec<BalmBiomeModifier> BALM_BIOME_MODIFIER_CODEC = MapCodec.unit((Object)BalmBiomeModifier.INSTANCE);
    private static final List<Pair<BiomePredicate, BiomeModifier>> biomeModifiers = Collections.synchronizedList(new ArrayList());

    public static void initializeBalmBiomeModifiers(BusGroup modEventBus) {
        DeferredRegister registry = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"balm");
        registry.register("balm", () -> BALM_BIOME_MODIFIER_CODEC);
        registry.register(modEventBus);
    }

    @Override
    public void modifyBiome(Identifier id, BiomePredicate predicate, BiomeModifier modifier) {
        biomeModifiers.add((Pair<BiomePredicate, BiomeModifier>)Pair.of((Object)predicate, (Object)modifier));
    }

    public void modifyBiome(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            ForgeBiomeModificationBuilder modificationBuilder = new ForgeBiomeModificationBuilder(builder);
            for (Pair<BiomePredicate, BiomeModifier> biomeModifierPair : biomeModifiers) {
                if (!((BiomePredicate)biomeModifierPair.getFirst()).test(biome)) continue;
                ((BiomeModifier)biomeModifierPair.getSecond()).modifyBiome(biome, modificationBuilder);
            }
        }
    }
}

