/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.world.entity.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.blay09.mods.balm.core.BalmRegistrar;
import net.blay09.mods.balm.forge.platform.event.internal.ModBusEventRegister;
import net.blay09.mods.balm.forge.platform.event.internal.ModBusEventRegisters;
import net.blay09.mods.balm.world.entity.internal.AbstractBalmEntityTypeRegistrarImpl;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;

public class ForgeBalmEntityTypeRegistrar
extends AbstractBalmEntityTypeRegistrarImpl {
    private final String namespace;

    public ForgeBalmEntityTypeRegistrar(BalmRegistrar registrar, String namespace) {
        super(registrar, namespace);
        this.namespace = namespace;
    }

    @Override
    protected <T extends Entity> void registerDefaultAttributes(Holder<EntityType<T>> entityType, Supplier<AttributeSupplier.Builder> attributes) {
        Registrations registrations = this.getActiveRegistrations();
        registrations.attributeSuppliers.put(entityType, () -> ((AttributeSupplier.Builder)attributes.get()).build());
    }

    @Override
    protected <T extends Entity> void registerSpawnPlacement(Holder<EntityType<T>> entityType, SpawnPlacementType spawnPlacementType, Heightmap.Types heightmapType, Supplier<SpawnPlacements.SpawnPredicate<T>> attributesFunction) {
        Registrations registrations = this.getActiveRegistrations();
        registrations.spawnPlacements.add(new SpawnPlacementRegistration<T>(entityType, spawnPlacementType, heightmapType, attributesFunction.get()));
    }

    private Registrations getActiveRegistrations() {
        return ModBusEventRegisters.getRegistrations(this.namespace, Registrations.class);
    }

    public static class Registrations
    implements ModBusEventRegister {
        public final Map<Holder<EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier>> attributeSuppliers = new HashMap<Holder<EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier>>();
        public final List<SpawnPlacementRegistration<? extends Entity>> spawnPlacements = new ArrayList<SpawnPlacementRegistration<? extends Entity>>();

        private void registerAttributes(EntityAttributeCreationEvent event) {
            for (Map.Entry<Holder<EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier>> entry : this.attributeSuppliers.entrySet()) {
                event.put((EntityType)entry.getKey().value(), entry.getValue().get());
            }
        }

        private void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
            for (SpawnPlacementRegistration<? extends Entity> entry : this.spawnPlacements) {
                event.register((EntityType)entry.entityType.value(), entry.spawnPlacementType, entry.heightmapType, entry.predicate, SpawnPlacementRegisterEvent.Operation.REPLACE);
            }
        }

        @Override
        public void register(BusGroup busGroup) {
            EntityAttributeCreationEvent.BUS.addListener(this::registerAttributes);
            SpawnPlacementRegisterEvent.BUS.addListener(this::registerSpawnPlacements);
        }
    }

    public record SpawnPlacementRegistration<T extends Entity>(Holder<EntityType<T>> entityType, SpawnPlacementType spawnPlacementType, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<? extends Entity> predicate) {
    }
}

