/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.platform.event.internal;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.blay09.mods.balm.forge.platform.event.internal.ModBusEventRegister;
import net.minecraftforge.eventbus.api.bus.BusGroup;

public class ModBusEventRegisters {
    private static final Map<String, BusGroup> modEventBuses = new ConcurrentHashMap<String, BusGroup>();
    private static final Table<String, Class<?>, Object> registrations = Tables.synchronizedTable((Table)HashBasedTable.create());
    private static final Set<Object> registeredRegistrations = Sets.newConcurrentHashSet();

    public static BusGroup getBusGroup(String namespace) {
        return modEventBuses.get(namespace);
    }

    public static <T> T getRegistrations(String namespace, Class<T> clazz) {
        Object existing = registrations.get((Object)namespace, clazz);
        if (existing != null) {
            return (T)existing;
        }
        try {
            T instance;
            try {
                instance = clazz.getConstructor(String.class).newInstance(namespace);
            }
            catch (NoSuchMethodException e) {
                instance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            registrations.put((Object)namespace, clazz, instance);
            BusGroup modEventBus = modEventBuses.get(namespace);
            if (modEventBus != null) {
                ModBusEventRegisters.registerToEventBus(instance, modEventBus);
            }
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String modId, BusGroup modEventBus) {
        modEventBuses.put(modId, modEventBus);
        Table<String, Class<?>, Object> table = registrations;
        synchronized (table) {
            for (Object registrations : ModBusEventRegisters.getByModId(modId)) {
                ModBusEventRegisters.registerToEventBus(registrations, modEventBus);
            }
        }
    }

    private static <T> void registerToEventBus(T instance, BusGroup modEventBus) {
        if (!registeredRegistrations.add(instance)) {
            return;
        }
        if (instance instanceof ModBusEventRegister) {
            ModBusEventRegister modBusEventRegister = (ModBusEventRegister)instance;
            modBusEventRegister.register(modEventBus);
        } else {
            modEventBus.register(MethodHandles.lookup(), instance);
        }
    }

    private static Collection<Object> getByModId(String modId) {
        return registrations.row((Object)modId).values();
    }
}

