/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.platform.event.internal;

import com.mojang.brigadier.ParseResults;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.blay09.mods.balm.platform.event.EventMapper;
import net.blay09.mods.balm.platform.event.EventPhases;
import net.blay09.mods.balm.platform.event.callback.BlockCallback;
import net.blay09.mods.balm.platform.event.callback.CommandCallback;
import net.blay09.mods.balm.platform.event.callback.ConfigCallback;
import net.blay09.mods.balm.platform.event.callback.CreativeModeTabCallback;
import net.blay09.mods.balm.platform.event.callback.CropCallback;
import net.blay09.mods.balm.platform.event.callback.EntityCallback;
import net.blay09.mods.balm.platform.event.callback.InteractionEventResult;
import net.blay09.mods.balm.platform.event.callback.ItemCallback;
import net.blay09.mods.balm.platform.event.callback.LevelCallback;
import net.blay09.mods.balm.platform.event.callback.LivingEntityCallback;
import net.blay09.mods.balm.platform.event.callback.PlayerCallback;
import net.blay09.mods.balm.platform.event.callback.ServerLifecycleCallback;
import net.blay09.mods.balm.platform.event.callback.ServerPlayerCallback;
import net.blay09.mods.balm.platform.event.callback.ServerTickCallback;
import net.blay09.mods.balm.platform.event.internal.BalmSupplementalEvents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.Result;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.fml.LogicalSide;

public class ForgeBalmEventMappings {
    private static final Map<Identifier, Byte> PRIORITIES = Map.of(EventPhases.LOWEST, (byte)-127, EventPhases.LOW, (byte)-64, EventPhases.DEFAULT, (byte)0, EventPhases.HIGH, (byte)64, EventPhases.HIGHEST, (byte)127);

    public static void bind() {
        ForgeBalmEventMappings.bindSimple(ServerTickCallback.BEFORE, TickEvent.ServerTickEvent.Pre.BUS, (event, it) -> it.handle(event.server()));
        ForgeBalmEventMappings.bindSimple(ServerTickCallback.AFTER, TickEvent.ServerTickEvent.Post.BUS, (event, it) -> it.handle(event.server()));
        ForgeBalmEventMappings.bindFiltered(ServerTickCallback.ServerLevelTick.BEFORE, TickEvent.LevelTickEvent.Pre.BUS, event -> event.side() == LogicalSide.SERVER, (event, it) -> it.handle((ServerLevel)event.level()));
        ForgeBalmEventMappings.bindFiltered(ServerTickCallback.ServerLevelTick.AFTER, TickEvent.LevelTickEvent.Post.BUS, event -> event.side() == LogicalSide.SERVER, (event, it) -> it.handle((ServerLevel)event.level()));
        ForgeBalmEventMappings.bindFiltered(ServerTickCallback.ServerPlayerTick.BEFORE, TickEvent.PlayerTickEvent.Pre.BUS, event -> event.side() == LogicalSide.SERVER, (event, it) -> it.handle((ServerPlayer)event.player()));
        ForgeBalmEventMappings.bindFiltered(ServerTickCallback.ServerPlayerTick.AFTER, TickEvent.PlayerTickEvent.Post.BUS, event -> event.side() == LogicalSide.SERVER, (event, it) -> it.handle((ServerPlayer)event.player()));
        ForgeBalmEventMappings.bindSimple(ServerTickCallback.ServerEntityTick.BEFORE, LivingEvent.LivingTickEvent.BUS, (event, it) -> it.handle((Entity)event.getEntity()));
        ForgeBalmEventMappings.bindSimple(ServerTickCallback.ServerEntityTick.AFTER, LivingEvent.LivingTickEvent.BUS, (event, it) -> it.handle((Entity)event.getEntity()));
        ForgeBalmEventMappings.bindSimple(ServerLifecycleCallback.Starting.EVENT, ServerAboutToStartEvent.BUS, (event, it) -> it.handle(event.getServer()));
        ForgeBalmEventMappings.bindSimple(ServerLifecycleCallback.Started.EVENT, ServerStartedEvent.BUS, (event, it) -> it.handle(event.getServer()));
        ForgeBalmEventMappings.bindSimple(ServerLifecycleCallback.Stopping.EVENT, ServerStoppingEvent.BUS, (event, it) -> it.handle(event.getServer()));
        ForgeBalmEventMappings.bindSimple(ServerLifecycleCallback.Stopped.EVENT, ServerStoppedEvent.BUS, (event, it) -> it.handle(event.getServer()));
        ServerLifecycleCallback.Reloading.EVENT.configureMapping(BalmSupplementalEvents.SERVER_RELOADING::register);
        ServerLifecycleCallback.Reloaded.EVENT.configureMapping(BalmSupplementalEvents.SERVER_RELOADED::register);
        ForgeBalmEventMappings.bindCancelable(BlockCallback.DigSpeed.EVENT, PlayerEvent.BreakSpeed.BUS, (event, it) -> event.getPosition().map(pos -> {
            Level level = event.getEntity().level();
            float speed = it.computeDigSpeed((BlockGetter)level, (BlockPos)pos, event.getState(), event.getEntity(), event.getNewSpeed());
            if (speed == -1.0f) {
                return true;
            }
            event.setNewSpeed(speed);
            return false;
        }).orElse(false));
        ForgeBalmEventMappings.bindCancelable(BlockCallback.Break.Before.EVENT, BlockEvent.BreakEvent.BUS, (event, it) -> {
            LevelAccessor level = event.getLevel();
            BlockEntity blockEntity = level.getBlockEntity(event.getPos());
            return !it.allowBreak(level, event.getPos(), event.getState(), blockEntity, event.getPlayer());
        });
        ForgeBalmEventMappings.bindCancelable(BlockCallback.Use.EVENT, PlayerInteractEvent.RightClickBlock.BUS, (event, it) -> {
            InteractionEventResult result = it.handle(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
            result.interactionResult().ifPresent(arg_0 -> ((PlayerInteractEvent.RightClickBlock)event).setCancellationResult(arg_0));
            return result.interactionResult().isPresent();
        });
        ForgeBalmEventMappings.bindCancelable(CommandCallback.Before.EVENT, CommandEvent.BUS, (event, it) -> !it.allowCommand((ParseResults<CommandSourceStack>)event.getParseResults()));
        ConfigCallback.Loaded.EVENT.configureMapping(BalmSupplementalEvents.CONFIG_LOADED::register);
        ConfigCallback.Reloaded.EVENT.configureMapping(BalmSupplementalEvents.CONFIG_RELOADED::register);
        ForgeBalmEventMappings.bindSimple(CropCallback.Grow.Before.EVENT, BlockEvent.CropGrowEvent.Pre.BUS, (event, it) -> {
            CropCallback.Grow.Before.Result result = it.beforeGrow(event.getLevel(), event.getPos(), event.getState());
            event.setResult(switch (result) {
                case CropCallback.Grow.Before.Result.DO_NOT_GROW -> Result.DENY;
                case CropCallback.Grow.Before.Result.GROW -> Result.ALLOW;
                default -> Result.DEFAULT;
            });
        });
        ForgeBalmEventMappings.bindSimple(CropCallback.Grow.After.EVENT, BlockEvent.CropGrowEvent.Post.BUS, (event, it) -> it.afterGrow(event.getLevel(), event.getPos(), event.getState()));
        ForgeBalmEventMappings.bindSimple(EntityCallback.AddedToLevel.EVENT, EntityJoinLevelEvent.BUS, (event, it) -> it.handle(event.getLevel(), event.getEntity()));
        ForgeBalmEventMappings.bindCancelable(EntityCallback.DimensionChange.BEFORE, EntityTravelToDimensionEvent.BUS, (event, it) -> !it.allowDimensionChange(event.getEntity(), (ResourceKey<Level>)event.getEntity().level().dimension(), (ResourceKey<Level>)event.getDimension()));
        ForgeBalmEventMappings.bindSimple(CreativeModeTabCallback.BuildContents.EVENT, BuildCreativeModeTabContentsEvent.BUS, (event, it) -> it.handle(event.getTab(), (CreativeModeTab.Output)event));
        ForgeBalmEventMappings.bindCancelable(ItemCallback.Use.EVENT, PlayerInteractEvent.RightClickItem.BUS, (event, it) -> {
            InteractionEventResult result = it.handle(event.getEntity(), event.getLevel(), event.getHand());
            result.interactionResult().ifPresent(arg_0 -> ((PlayerInteractEvent.RightClickItem)event).setCancellationResult(arg_0));
            return result.interactionResult().isPresent();
        });
        ForgeBalmEventMappings.bindSimple(ItemCallback.Tooltip.EVENT, ItemTooltipEvent.BUS, (event, it) -> it.handle(event.getItemStack(), event.getToolTip(), event.getFlags()));
        ForgeBalmEventMappings.bindSimple(ItemCallback.Craft.After.EVENT, PlayerEvent.ItemCraftedEvent.BUS, (event, it) -> it.afterCraft(event.getEntity(), event.getCrafting(), event.getContainer()));
        ForgeBalmEventMappings.bindCancelable(ItemCallback.Toss.Before.EVENT, ItemTossEvent.BUS, (event, it) -> !it.allowToss(event.getPlayer(), event.getEntity().getItem()));
        ForgeBalmEventMappings.bindSimple(LevelCallback.LOAD, LevelEvent.Load.BUS, (event, it) -> it.handle(event.getLevel()));
        ForgeBalmEventMappings.bindSimple(LevelCallback.UNLOAD, LevelEvent.Unload.BUS, (event, it) -> it.handle(event.getLevel()));
        ForgeBalmEventMappings.bindSimple(LevelCallback.Chunk.LOAD, ChunkEvent.Load.BUS, (event, it) -> it.handle(event.getLevel(), event.getChunk(), event.getChunk().getPos()));
        ForgeBalmEventMappings.bindSimple(LevelCallback.Chunk.UNLOAD, ChunkEvent.Unload.BUS, (event, it) -> it.handle(event.getLevel(), event.getChunk(), event.getChunk().getPos()));
        ForgeBalmEventMappings.bindSimple(LivingEntityCallback.Heal.Before.EVENT, LivingHealEvent.BUS, (event, it) -> event.setAmount(it.computeHeal(event.getEntity(), event.getAmount())));
        LivingEntityCallback.Fall.Before.EVENT.configureMapping(BalmSupplementalEvents.LIVING_FALL::register);
        ForgeBalmEventMappings.bindSimple(LivingEntityCallback.Death.Before.EVENT, LivingDeathEvent.BUS, (event, it) -> it.allowDeath(event.getEntity(), event.getSource()));
        ForgeBalmEventMappings.bindSimple(LivingEntityCallback.Damage.Before.EVENT, LivingDamageEvent.BUS, (event, it) -> it.computeDamage(event.getEntity(), event.getSource(), event.getAmount()));
        ForgeBalmEventMappings.bindSimple(LivingEntityCallback.MobEffectCallback.Apply.Before.EVENT, MobEffectEvent.Applicable.BUS, (event, it) -> {
            if (!it.allowApply(event.getEntity(), event.getEffectInstance(), null)) {
                event.setResult(Result.DENY);
            }
        });
        ForgeBalmEventMappings.bindSimple(LivingEntityCallback.MobEffectCallback.Add.Before.EVENT, MobEffectEvent.Added.BUS, (event, it) -> it.effectAdded(event.getEntity(), event.getEffectInstance(), event.getOldEffectInstance(), event.getEffectSource()));
        ForgeBalmEventMappings.bindCancelable(LivingEntityCallback.MobEffectCallback.Remove.Before.EVENT, MobEffectEvent.Remove.BUS, (event, it) -> !it.allowRemove(event.getEntity(), (Holder<MobEffect>)BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)event.getEffect()), event.getEffectInstance()));
        ForgeBalmEventMappings.bindSimple(LivingEntityCallback.MobEffectCallback.Expire.Before.EVENT, MobEffectEvent.Expired.BUS, (event, it) -> it.allowExpire(event.getEntity(), event.getEffectInstance()));
        ForgeBalmEventMappings.bindSimple(PlayerCallback.Attack.Before.EVENT, AttackEntityEvent.BUS, (event, it) -> it.allowAttack(event.getEntity(), event.getTarget()));
        ForgeBalmEventMappings.bindSimple(ServerPlayerCallback.Join.EVENT, PlayerEvent.PlayerLoggedInEvent.BUS, (event, it) -> it.handle((ServerPlayer)event.getEntity()));
        ForgeBalmEventMappings.bindSimple(ServerPlayerCallback.Leave.EVENT, PlayerEvent.PlayerLoggedOutEvent.BUS, (event, it) -> it.handle((ServerPlayer)event.getEntity()));
        ForgeBalmEventMappings.bindSimple(ServerPlayerCallback.OpenMenu.EVENT, PlayerContainerEvent.Open.BUS, (event, it) -> it.handle((ServerPlayer)event.getEntity(), event.getContainer()));
        ForgeBalmEventMappings.bindSimple(ServerPlayerCallback.DimensionChange.EVENT, PlayerEvent.PlayerChangedDimensionEvent.BUS, (event, it) -> it.handle((ServerPlayer)event.getEntity(), (ResourceKey<Level>)event.getFrom(), (ResourceKey<Level>)event.getTo()));
        ForgeBalmEventMappings.bindSimple(ServerPlayerCallback.Respawn.EVENT, PlayerEvent.PlayerRespawnEvent.BUS, (event, it) -> it.handle((ServerPlayer)event.getEntity(), (ServerPlayer)event.getEntity()));
        ForgeBalmEventMappings.bindSimple(ServerPlayerCallback.ChunkTracking.START, ChunkWatchEvent.Watch.BUS, (event, it) -> it.handle(event.getLevel(), event.getPlayer(), event.getPos()));
        ForgeBalmEventMappings.bindSimple(ServerPlayerCallback.ChunkTracking.STOP, ChunkWatchEvent.UnWatch.BUS, (event, it) -> it.handle(event.getLevel(), event.getPlayer(), event.getPos()));
    }

    public static <TCallback, TEvent extends Event> void bindSimple(EventMapper<TCallback> mapper, EventBus<TEvent> bus, BiConsumer<TEvent, TCallback> consumer) {
        mapper.configureMapping((phase, listener) -> bus.addListener(ForgeBalmEventMappings.mapPriority(phase), event -> consumer.accept(event, listener)));
    }

    public static <TCallback, TEvent extends Event & Cancellable> void bindCancelable(EventMapper<TCallback> mapper, EventBus<TEvent> bus, BiFunction<TEvent, TCallback, Boolean> consumer) {
        mapper.configureMapping((phase, listener) -> bus.addListener(ForgeBalmEventMappings.mapPriority(phase), event -> consumer.apply(event, listener)));
    }

    public static <TCallback, TEvent extends Event> void bindFiltered(EventMapper<TCallback> mapper, EventBus<TEvent> bus, Predicate<TEvent> filter, BiConsumer<TEvent, TCallback> consumer) {
        mapper.configureMapping((phase, listener) -> bus.addListener(ForgeBalmEventMappings.mapPriority(phase), event -> {
            if (filter.test(event)) {
                consumer.accept(event, listener);
            }
        }));
    }

    public static byte mapPriority(Identifier phase) {
        return PRIORITIES.getOrDefault(phase, (byte)0);
    }
}

