/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.internal.mixin;

import net.blay09.mods.balm.nbt.BalmDataHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.ValueInput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public class EntityMixin
implements BalmDataHolder {
    private CompoundTag fabricBalmData = new CompoundTag();
    private CompoundTag neoforgeBalmData = new CompoundTag();

    @Inject(method={"load(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="HEAD")})
    private void load(ValueInput input, CallbackInfo callbackInfo) {
        this.fabricBalmData = input.read("BalmData", CompoundTag.CODEC).orElse(this.fabricBalmData);
        this.neoforgeBalmData = input.child("NeoForgeData").flatMap(it -> it.child("PlayerPersisted")).flatMap(it -> it.read("BalmData", CompoundTag.CODEC)).orElse(this.neoforgeBalmData);
    }

    @Override
    public CompoundTag balm$getFabricBalmData() {
        return this.fabricBalmData;
    }

    @Override
    public void balm$setFabricBalmData(CompoundTag tag) {
        this.fabricBalmData = tag;
    }

    @Override
    public CompoundTag balm$getForgeBalmData() {
        throw new UnsupportedOperationException("This method should not have been called. Report this issue to Balm.");
    }

    @Override
    public void balm$setForgeBalmData(CompoundTag tag) {
        throw new UnsupportedOperationException("This method should not have been called. Report this issue to Balm.");
    }

    @Override
    public CompoundTag balm$getNeoForgeBalmData() {
        return this.neoforgeBalmData;
    }

    @Override
    public void balm$setNeoForgeBalmData(CompoundTag tag) {
        this.neoforgeBalmData = tag;
    }
}

