/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.internal;

import java.util.function.BiFunction;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.core.BalmRegistrars;
import net.blay09.mods.balm.forge.client.internal.ForgeBalmClient;
import net.blay09.mods.balm.forge.core.internal.DeferredRegisters;
import net.blay09.mods.balm.forge.platform.capabilities.internal.ForgeBalmCapabilities;
import net.blay09.mods.balm.forge.platform.capabilities.internal.ForgeCommonCapabilities;
import net.blay09.mods.balm.forge.platform.energy.internal.ForgeEnergyStorage;
import net.blay09.mods.balm.forge.platform.event.internal.ModBusEventRegisters;
import net.blay09.mods.balm.forge.platform.fluid.internal.ForgeFluidTank;
import net.blay09.mods.balm.forge.platform.runtime.ForgeLoadContext;
import net.blay09.mods.balm.forge.platform.runtime.internal.ForgeBalmRuntime;
import net.blay09.mods.balm.forge.world.level.levelgen.internal.ForgeBalmWorldGen;
import net.blay09.mods.balm.platform.capabilities.CapabilityType;
import net.blay09.mods.balm.platform.capabilities.CommonCapabilities;
import net.blay09.mods.balm.platform.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.platform.energy.EnergyStorage;
import net.blay09.mods.balm.platform.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.platform.fluid.FluidTank;
import net.blay09.mods.balm.platform.runtime.internal.BalmLoadContexts;
import net.blay09.mods.balm.world.BalmContainerProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

@Mod(value="balm")
public class ForgeBalm {
    public ForgeBalm(FMLJavaModLoadingContext context) {
        BusGroup modBusGroup = context.getModBusGroup();
        BalmLoadContexts.register("balm", new ForgeLoadContext(modBusGroup));
        Balm.getRuntime().registerModule(new BalmRegistrars(Balm.getRuntime(), "balm"), new ForgeCommonCapabilities());
        ((ForgeBalmRuntime)Balm.getRuntime()).initializeRuntime();
        DeferredRegisters.register("balm", modBusGroup);
        ModBusEventRegisters.register("balm", modBusGroup);
        ForgeBalmWorldGen.initializeBalmBiomeModifiers(modBusGroup);
        FMLClientSetupEvent.getBus((BusGroup)modBusGroup).addListener(ForgeBalmClient::onInitializeClient);
        ForgeBalmCapabilities capabilities = (ForgeBalmCapabilities)Balm.capabilities();
        CapabilityType<Block, IItemHandler, Direction> nativeItemHandler = capabilities.addExistingType(Identifier.fromNamespaceAndPath((String)"forge", (String)"item_handler"), IItemHandler.class, ForgeCapabilities.ITEM_HANDLER);
        CapabilityType<Block, IFluidHandler, Direction> nativeFluidHandler = capabilities.addExistingType(Identifier.fromNamespaceAndPath((String)"forge", (String)"fluid_handler"), IFluidHandler.class, ForgeCapabilities.FLUID_HANDLER);
        CapabilityType<Block, IEnergyStorage, Direction> nativeEnergyStorage = capabilities.addExistingType(Identifier.fromNamespaceAndPath((String)"forge", (String)"energy_storage"), IEnergyStorage.class, ForgeCapabilities.ENERGY);
        capabilities.registerFallbackBlockEntityProvider(Identifier.fromNamespaceAndPath((String)"balm", (String)"item_handler"), nativeItemHandler, new BiFunction<BlockEntity, Direction, IItemHandler>(this){
            private boolean running;

            @Override
            public IItemHandler apply(BlockEntity blockEntity, Direction direction) {
                if (this.running) {
                    return null;
                }
                if (blockEntity instanceof BalmContainerProvider) {
                    Container container;
                    BalmContainerProvider containerProvider = (BalmContainerProvider)blockEntity;
                    Container container2 = container = direction != null ? containerProvider.getContainer(direction) : containerProvider.getContainer();
                    if (container != null) {
                        return new InvWrapper(container);
                    }
                } else if (blockEntity != null) {
                    this.running = true;
                    Container container = Balm.capabilities().getCapability(blockEntity, direction, CommonCapabilities.CONTAINER);
                    this.running = false;
                    if (container != null) {
                        return new InvWrapper(container);
                    }
                }
                return null;
            }
        });
        capabilities.registerFallbackBlockEntityProvider(Identifier.fromNamespaceAndPath((String)"balm", (String)"fluid_handler"), nativeFluidHandler, new BiFunction<BlockEntity, Direction, IFluidHandler>(this){
            private boolean running;

            @Override
            public IFluidHandler apply(BlockEntity blockEntity, Direction direction) {
                if (this.running) {
                    return null;
                }
                if (blockEntity instanceof BalmFluidTankProvider) {
                    FluidTank fluidTank;
                    BalmFluidTankProvider fluidTankProvider = (BalmFluidTankProvider)blockEntity;
                    FluidTank fluidTank2 = fluidTank = direction != null ? fluidTankProvider.getFluidTank(direction) : fluidTankProvider.getFluidTank();
                    if (fluidTank != null) {
                        return new ForgeFluidTank(fluidTank);
                    }
                } else if (blockEntity != null) {
                    this.running = true;
                    FluidTank fluidTank = Balm.capabilities().getCapability(blockEntity, direction, CommonCapabilities.FLUID_TANK);
                    this.running = false;
                    if (fluidTank != null) {
                        return new ForgeFluidTank(fluidTank);
                    }
                }
                return null;
            }
        });
        capabilities.registerFallbackBlockEntityProvider(Identifier.fromNamespaceAndPath((String)"balm", (String)"energy_storage"), nativeEnergyStorage, new BiFunction<BlockEntity, Direction, IEnergyStorage>(this){
            private boolean running;

            @Override
            public IEnergyStorage apply(BlockEntity blockEntity, Direction direction) {
                if (this.running) {
                    return null;
                }
                if (blockEntity instanceof BalmEnergyStorageProvider) {
                    EnergyStorage energyStorage;
                    BalmEnergyStorageProvider energyStorageProvider = (BalmEnergyStorageProvider)blockEntity;
                    EnergyStorage energyStorage2 = energyStorage = direction != null ? energyStorageProvider.getEnergyStorage(direction) : energyStorageProvider.getEnergyStorage();
                    if (energyStorage != null) {
                        return new ForgeEnergyStorage(energyStorage);
                    }
                } else if (blockEntity != null) {
                    this.running = true;
                    EnergyStorage energyStorage = Balm.capabilities().getCapability(blockEntity, direction, CommonCapabilities.ENERGY_STORAGE);
                    this.running = false;
                    if (energyStorage != null) {
                        return new ForgeEnergyStorage(energyStorage);
                    }
                }
                return null;
            }
        });
    }
}

