/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.core.internal;

import java.util.function.Function;
import net.blay09.mods.balm.core.BalmRegistrar;
import net.blay09.mods.balm.core.DeferredHolder;
import net.blay09.mods.balm.forge.core.internal.DeferredRegisters;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ForgeBalmRegistrar
implements BalmRegistrar {
    @Override
    public <T> Holder<T> register(ResourceKey<T> resourceKey, Function<Identifier, T> resourceFunction) {
        DeferredRegister deferredRegister = DeferredRegisters.get(resourceKey.registryKey(), resourceKey.identifier().getNamespace());
        deferredRegister.register(resourceKey.identifier().getPath(), () -> resourceFunction.apply(resourceKey.identifier()));
        return new DeferredHolder<T>(resourceKey);
    }

    public <T> Scoped<T> scoped(ResourceKey<? extends Registry<T>> registryKey, String namespace) {
        return new Scoped(registryKey, namespace);
    }

    public static class Scoped<T>
    implements BalmRegistrar.Scoped<T> {
        private final ResourceKey<? extends Registry<T>> registryKey;
        private final String namespace;

        public Scoped(ResourceKey<? extends Registry<T>> registryKey, String namespace) {
            this.registryKey = registryKey;
            this.namespace = namespace;
        }

        @Override
        public Holder<T> register(String name, Function<Identifier, T> resourceFunction) {
            DeferredRegister deferredRegister = DeferredRegisters.get(this.registryKey, this.namespace);
            RegistryObject registryObject = deferredRegister.register(name, () -> resourceFunction.apply(Identifier.fromNamespaceAndPath((String)this.namespace, (String)name)));
            return new DeferredHolder(registryObject.getKey());
        }
    }
}

