/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.client.event.internal;

import net.blay09.mods.balm.client.platform.event.callback.ClientInputCallback;
import net.blay09.mods.balm.client.platform.event.callback.ClientItemCallback;
import net.blay09.mods.balm.client.platform.event.callback.ClientLifecycleCallback;
import net.blay09.mods.balm.client.platform.event.callback.ClientTickCallback;
import net.blay09.mods.balm.client.platform.event.callback.RenderCallback;
import net.blay09.mods.balm.client.platform.event.callback.ScreenCallback;
import net.blay09.mods.balm.client.platform.event.internal.BalmSupplementalClientEvents;
import net.blay09.mods.balm.forge.client.event.internal.ForgeBalmSupplementalClientEvents;
import net.blay09.mods.balm.forge.platform.event.internal.ForgeBalmEventMappings;
import net.blay09.mods.balm.platform.event.callback.InteractionEventResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.LogicalSide;

public class ForgeBalmClientEventMappings
extends ForgeBalmEventMappings {
    public static void bind() {
        ForgeBalmClientEventMappings.bindSimple(ClientTickCallback.BEFORE, TickEvent.ClientTickEvent.Pre.BUS, (event, it) -> it.handle(Minecraft.getInstance()));
        ForgeBalmClientEventMappings.bindSimple(ClientTickCallback.AFTER, TickEvent.ClientTickEvent.Post.BUS, (event, it) -> it.handle(Minecraft.getInstance()));
        ForgeBalmClientEventMappings.bindFiltered(ClientTickCallback.ClientLevelTick.BEFORE, TickEvent.LevelTickEvent.Pre.BUS, event -> event.side() == LogicalSide.CLIENT, (event, it) -> it.handle((ClientLevel)event.level()));
        ForgeBalmClientEventMappings.bindFiltered(ClientTickCallback.ClientLevelTick.AFTER, TickEvent.LevelTickEvent.Post.BUS, event -> event.side() == LogicalSide.CLIENT, (event, it) -> it.handle((ClientLevel)event.level()));
        ForgeBalmClientEventMappings.bindFiltered(ClientTickCallback.ClientPlayerTick.BEFORE, TickEvent.PlayerTickEvent.Pre.BUS, event -> event.side() == LogicalSide.CLIENT, (event, it) -> it.handle((AbstractClientPlayer)event.player()));
        ForgeBalmClientEventMappings.bindFiltered(ClientTickCallback.ClientPlayerTick.AFTER, TickEvent.PlayerTickEvent.Post.BUS, event -> event.side() == LogicalSide.CLIENT, (event, it) -> it.handle((AbstractClientPlayer)event.player()));
        ForgeBalmClientEventMappings.bindSimple(ClientTickCallback.ClientEntityTick.BEFORE, LivingEvent.LivingTickEvent.BUS, (event, it) -> it.handle((Entity)event.getEntity()));
        ForgeBalmClientEventMappings.bindSimple(ClientTickCallback.ClientEntityTick.AFTER, LivingEvent.LivingTickEvent.BUS, (event, it) -> it.handle((Entity)event.getEntity()));
        ClientLifecycleCallback.Started.EVENT.configureMapping(ForgeBalmSupplementalClientEvents.CLIENT_STARTED::register);
        ForgeBalmClientEventMappings.bindSimple(ClientLifecycleCallback.ConnectedToServer.EVENT, ClientPlayerNetworkEvent.LoggingIn.BUS, (event, it) -> it.handle(Minecraft.getInstance()));
        ForgeBalmClientEventMappings.bindSimple(ClientLifecycleCallback.DisconnectedFromServer.EVENT, ClientPlayerNetworkEvent.LoggingOut.BUS, (event, it) -> it.handle(Minecraft.getInstance()));
        ScreenCallback.Init.Before.EVENT.configureMapping(ForgeBalmSupplementalClientEvents.SCREEN_INIT_PRE::register);
        ScreenCallback.Init.After.EVENT.configureMapping(ForgeBalmSupplementalClientEvents.SCREEN_INIT_POST::register);
        ScreenCallback.Opening.EVENT.configureMapping((phase, it) -> ScreenEvent.Opening.BUS.addListener(ForgeBalmClientEventMappings.mapPriority(phase), orig -> {
            Screen newScreen = it.modifyScreen(orig.getScreen());
            if (newScreen != null) {
                orig.setNewScreen(newScreen);
            }
            return false;
        }));
        ForgeBalmClientEventMappings.bindSimple(ScreenCallback.Render.BEFORE, ScreenEvent.Render.Pre.BUS, (event, it) -> it.render(event.getScreen(), event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick()));
        ForgeBalmClientEventMappings.bindSimple(ScreenCallback.Render.AFTER_BACKGROUND, ScreenEvent.BackgroundRendered.BUS, (event, it) -> it.render(event.getScreen(), event.getGuiGraphics(), 0, 0, 0.0f));
        ForgeBalmClientEventMappings.bindSimple(ScreenCallback.Render.AFTER, ScreenEvent.Render.Post.BUS, (event, it) -> it.render(event.getScreen(), event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick()));
        ForgeBalmClientEventMappings.bindCancelable(ScreenCallback.KeyPress.Before.EVENT, ScreenEvent.KeyPressed.Pre.BUS, (event, it) -> it.keyPressed(event.getScreen(), event.getInfo()));
        ForgeBalmClientEventMappings.bindSimple(ScreenCallback.KeyPress.After.EVENT, ScreenEvent.KeyPressed.Post.BUS, (event, it) -> it.afterKeyPressed(event.getScreen(), event.getInfo()));
        ForgeBalmClientEventMappings.bindCancelable(ScreenCallback.KeyRelease.Before.EVENT, ScreenEvent.KeyReleased.Pre.BUS, (event, it) -> it.keyReleased(event.getScreen(), event.getInfo()));
        ForgeBalmClientEventMappings.bindSimple(ScreenCallback.KeyRelease.After.EVENT, ScreenEvent.KeyReleased.Post.BUS, (event, it) -> it.afterKeyReleased(event.getScreen(), event.getInfo()));
        ForgeBalmClientEventMappings.bindCancelable(ScreenCallback.MousePress.Before.EVENT, ScreenEvent.MouseButtonPressed.Pre.BUS, (event, it) -> it.mousePressed(event.getScreen(), event.getInfo()));
        ForgeBalmClientEventMappings.bindSimple(ScreenCallback.MousePress.After.EVENT, ScreenEvent.MouseButtonPressed.Post.BUS, (event, it) -> it.afterMousePressed(event.getScreen(), event.getInfo(), event.wasHandled()));
        ForgeBalmClientEventMappings.bindCancelable(ScreenCallback.MouseRelease.Before.EVENT, ScreenEvent.MouseButtonReleased.Pre.BUS, (event, it) -> it.mouseReleased(event.getScreen(), event.getMouseX(), event.getMouseY(), event.getButton()));
        ForgeBalmClientEventMappings.bindSimple(ScreenCallback.MouseRelease.After.EVENT, ScreenEvent.MouseButtonReleased.Post.BUS, (event, it) -> it.afterMouseReleased(event.getScreen(), event.getMouseX(), event.getMouseY(), event.getButton(), event.wasHandled()));
        ForgeBalmClientEventMappings.bindCancelable(ScreenCallback.MouseDrag.Before.EVENT, ScreenEvent.MouseDragged.Pre.BUS, (event, it) -> it.mouseDragged(event.getScreen(), event.getMouseX(), event.getMouseY(), event.getMouseButton(), event.getDragX(), event.getDragY()));
        ForgeBalmClientEventMappings.bindSimple(ScreenCallback.MouseDrag.After.EVENT, ScreenEvent.MouseDragged.Post.BUS, (event, it) -> it.afterMouseDragged(event.getScreen(), event.getMouseX(), event.getMouseY(), event.getMouseButton(), event.getDragX(), event.getDragY(), false));
        ForgeBalmClientEventMappings.bindSimple(ScreenCallback.MouseScroll.Before.EVENT, ScreenEvent.MouseScrolled.Pre.BUS, (event, it) -> it.mouseScrolled(event.getScreen(), event.getMouseX(), event.getMouseY(), event.getDeltaX(), event.getDeltaY()));
        ForgeBalmClientEventMappings.bindSimple(ScreenCallback.MouseScroll.After.EVENT, ScreenEvent.MouseScrolled.Post.BUS, (event, it) -> it.afterMouseScrolled(event.getScreen(), event.getMouseX(), event.getMouseY(), event.getDeltaX(), event.getDeltaY(), false));
        RenderCallback.Gui.BEFORE.configureMapping(ForgeBalmSupplementalClientEvents.RENDER_GUI_PRE::register);
        RenderCallback.Gui.AFTER.configureMapping(ForgeBalmSupplementalClientEvents.RENDER_GUI_POST::register);
        RenderCallback.Gui.Health.BEFORE.configureMapping(ForgeBalmSupplementalClientEvents.RENDER_GUI_HEALTH_PRE::register);
        RenderCallback.Gui.Health.AFTER.configureMapping(ForgeBalmSupplementalClientEvents.RENDER_GUI_HEALTH_POST::register);
        RenderCallback.Gui.Chat.BEFORE.configureMapping(ForgeBalmSupplementalClientEvents.RENDER_GUI_CHAT_PRE::register);
        RenderCallback.Gui.Chat.AFTER.configureMapping(ForgeBalmSupplementalClientEvents.RENDER_GUI_CHAT_POST::register);
        RenderCallback.Gui.BossInfo.BEFORE.configureMapping(ForgeBalmSupplementalClientEvents.RENDER_GUI_BOSS_INFO_PRE::register);
        RenderCallback.Gui.BossInfo.AFTER.configureMapping(ForgeBalmSupplementalClientEvents.RENDER_GUI_BOSS_INFO_POST::register);
        RenderCallback.Gui.PlayerList.BEFORE.configureMapping(ForgeBalmSupplementalClientEvents.RENDER_GUI_PLAYER_LIST_PRE::register);
        RenderCallback.Gui.PlayerList.AFTER.configureMapping(ForgeBalmSupplementalClientEvents.RENDER_GUI_PLAYER_LIST_POST::register);
        RenderCallback.Gui.Debug.BEFORE.configureMapping(BalmSupplementalClientEvents.RENDER_GUI_DEBUG_PRE::register);
        RenderCallback.Gui.Debug.AFTER.configureMapping(BalmSupplementalClientEvents.RENDER_GUI_DEBUG_POST::register);
        RenderCallback.BlockHighlight.EVENT.configureMapping(BalmSupplementalClientEvents.RENDER_BLOCK_HIGHLIGHT::register);
        ForgeBalmClientEventMappings.bindSimple(RenderCallback.UpdateFov.EVENT, ComputeFovModifierEvent.BUS, (event, it) -> {
            float newFov = it.computeFov((LivingEntity)event.getPlayer(), event.getFovModifier());
            event.setNewFovModifier(Mth.lerp((float)event.getScale(), (float)1.0f, (float)newFov));
        });
        ForgeBalmClientEventMappings.bindCancelable(RenderCallback.Hand.EVENT, RenderHandEvent.BUS, (event, it) -> !it.shouldRender(event.getHand(), event.getItemStack(), event.getSwingProgress()));
        ForgeBalmClientEventMappings.bindSimple(ClientInputCallback.Keyboard.EVENT, InputEvent.Key.BUS, (event, it) -> it.handle(event.getKey(), event.getScanCode(), event.getAction(), event.getModifiers()));
        ForgeBalmClientEventMappings.bindCancelable(ClientItemCallback.Use.EVENT, InputEvent.InteractionKeyMappingTriggered.BUS, (event, it) -> {
            InteractionEventResult result;
            InteractionResult interactionResult;
            if (event.isUseItem() && Minecraft.getInstance().player != null && (interactionResult = (InteractionResult)(result = it.beforeUse((Player)Minecraft.getInstance().player, event.getHand())).interactionResult().orElse(null)) != null) {
                InteractionResult.Success success;
                event.setSwingHand(interactionResult instanceof InteractionResult.Success && (success = (InteractionResult.Success)interactionResult).swingSource() == InteractionResult.SwingSource.CLIENT);
                return true;
            }
            return false;
        });
    }
}

