/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.commands;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.blay09.mods.balm.Balm;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.Identifier;
import net.minecraft.server.permissions.Permission;

public interface BalmCommands {
    public static void registerPermission(Identifier identifier, Permission permission) {
        Balm.permissions().registerPermission(identifier, context -> context.getCommandSource().map(it -> it.permissions().hasPermission(permission)).orElse(false));
    }

    public static Predicate<CommandSourceStack> requirePermission(Identifier identifier) {
        return source -> Balm.permissions().hasPermission((CommandSourceStack)source, identifier);
    }

    public static Predicate<CommandSourceStack> requireAnyPermission(Identifier ... identifiers) {
        return source -> Arrays.stream(identifiers).anyMatch(it -> Balm.permissions().hasPermission((CommandSourceStack)source, (Identifier)it));
    }

    public static Predicate<CommandSourceStack> requireAllPermissions(Identifier ... identifiers) {
        return source -> Arrays.stream(identifiers).allMatch(it -> Balm.permissions().hasPermission((CommandSourceStack)source, (Identifier)it));
    }

    public void register(Consumer<CommandDispatcher<CommandSourceStack>> var1);
}

