/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.client.platform.internal;

import java.util.Optional;
import net.blay09.mods.balm.platform.BalmSafeClientAccess;
import net.blay09.mods.kuma.api.Kuma;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeMap;
import org.jspecify.annotations.Nullable;

public class BalmClientSafeClientAccess
extends BalmSafeClientAccess {
    private @Nullable RecipeMap syncedRecipes;

    @Override
    public @Nullable Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    @Override
    public boolean isLocalServer() {
        Minecraft client = Minecraft.getInstance();
        return client != null && client.isLocalServer();
    }

    @Override
    public boolean isConnected() {
        Minecraft client = Minecraft.getInstance();
        return client != null && client.getConnection() != null;
    }

    @Override
    public boolean isIngame() {
        Minecraft client = Minecraft.getInstance();
        return client != null && client.gameMode != null;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean isShiftDown() {
        return Kuma.hasShiftDown();
    }

    @Override
    public boolean isControlDown() {
        return Kuma.hasControlDown();
    }

    @Override
    public boolean isAltDown() {
        return Kuma.hasAltDown();
    }

    @Override
    public Optional<RecipeMap> getRecipeMap() {
        Optional<RecipeMap> serverRecipeMap = super.getRecipeMap();
        if (serverRecipeMap.isPresent()) {
            return serverRecipeMap;
        }
        return Optional.ofNullable(this.syncedRecipes);
    }

    public void setSyncedRecipes(@Nullable RecipeMap syncedRecipes) {
        this.syncedRecipes = syncedRecipes;
    }
}

