/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.items;

import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.mods.adfinders.finder.Definitions;
import com.endertech.minecraft.mods.adfinders.finder.TargetFilter;
import com.endertech.minecraft.mods.adfinders.init.FinderType;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SyncClientMsg
extends ForgeNetMsg<SyncClientMsg> {
    public FinderType type;
    public int scanRadius;
    public int pingDepth;
    public int veinMinSize;
    public int depositMinSize;
    public int durability;
    public CompoundTag compound;

    public SyncClientMsg() {
    }

    public SyncClientMsg(FinderType type) {
        this.type = type;
        this.scanRadius = (Integer)type.scanRadius.get();
        this.pingDepth = (Integer)type.pingDepth.get();
        this.veinMinSize = (Integer)type.veinMinSize.get();
        this.depositMinSize = (Integer)type.depositMinSize.get();
        this.durability = (Integer)type.durability.get();
        this.compound = new CompoundTag();
        TagHelper.putStringArray((CompoundTag)this.compound, (String)"definitions", (String[])((Definitions)type.definitions.get()).toArray());
        TagHelper.putStringArray((CompoundTag)this.compound, (String)"allowedTargets", (String[])((List)type.allowedTargets.get()).toArray(new String[0]));
        TagHelper.putStringArray((CompoundTag)this.compound, (String)"forbiddenTargets", (String[])((List)type.forbiddenTargets.get()).toArray(new String[0]));
        ((Finder)((Object)type.finder.get())).durability = this.durability;
    }

    public SyncClientMsg create() {
        return new SyncClientMsg();
    }

    public void handle(Level level, Player player) {
        Finder finder = (Finder)((Object)this.type.finder.get());
        finder.scanRadius = this.scanRadius;
        finder.pingDepth = this.pingDepth;
        finder.veinMinSize = this.veinMinSize;
        finder.depositMinSize = this.depositMinSize;
        finder.durability = this.durability;
        String[] definitions = TagHelper.getStringArray((CompoundTag)this.compound, (String)"definitions");
        String[] allowedTargets = TagHelper.getStringArray((CompoundTag)this.compound, (String)"allowedTargets");
        String[] forbiddenTargets = TagHelper.getStringArray((CompoundTag)this.compound, (String)"forbiddenTargets");
        finder.syncTargetsWith(definitions);
        finder.targetFilter = new TargetFilter(allowedTargets, forbiddenTargets);
    }
}

