/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.init;

import com.endertech.minecraft.mods.adfinders.finder.Definitions;
import com.endertech.minecraft.mods.adfinders.finder.Ore;
import com.endertech.minecraft.mods.adfinders.init.FinderType;

public class Targets {
    static void init(String modId, Initializer initializer) {
        initializer.init(((Definitions)FinderType.GEM.definitions.get()).forMod(modId), ((Definitions)FinderType.METAL.definitions.get()).forMod(modId), ((Definitions)FinderType.MINERAL.definitions.get()).forMod(modId));
    }

    public static void initAll() {
        Targets.init("minecraft", new Minecraft());
        Targets.init("extragems", new ExtraGems());
        Targets.init("undergroundbiomes", new UndergroundBiomes());
        Targets.init("mysticalworld", new MysticalWorld());
        Targets.init("techemistry", new Techemistry());
        Targets.init("simpleores", new SimpleOres());
        Targets.init("gemsplusplus", new GemsPlusPlus());
        Targets.init("silentgems", new SilentGems());
        Targets.init("silentgear", new SilentGear());
        Targets.init("silents_mechanisms", new SilentsMechanisms());
        Targets.init("vulcanite", (gem, met, min) -> met.withPrefixes("nether").suffixOre().addOre(Ore.Metals.VULCANITE.colored(-380416)));
        Targets.init("moreoresinone", new MoreOresInONE());
        Targets.init("mmorpg", new MineAndSlash());
        Targets.init("oresabovediamonds", (gem, met, min) -> gem.withPrefixes("", "deepslate", "end", "nether").suffixOre().addOres(Ore.Gems.AMETHYST.colored(-3823877)).addOre("black_opal", Ore.Gems.OPAL.colored(-12301956)));
        Targets.init("mysticalagriculture", (gem, met, min) -> min.prefixNoneAndDeepslate().suffixOre().addOres(new Ore("prosperity", -3278086), new Ore("inferium", -7558144), new Ore("soulium", -7777221)));
        Targets.init("immersiveengineering", new ImmersiveEngineering());
        Targets.init("create", (gem, met, min) -> met.prefixNoneAndDeepslate().suffixOre().addOres(Ore.Metals.ZINC.colored(-7558253)));
        Targets.init("evilcraft", (gem, met, min) -> gem.withMetaAll().addOre("dark_ore", -16777216));
        Targets.init("appliedenergistics2", (gem, met, min) -> gem.suffixOre().addOre(Ore.Gems.QUARTZ.colored(-8543548)).addOre("charged_quartz", Ore.Gems.QUARTZ.colored(-6963731)));
        Targets.init("mapperbase", (gem, met, min) -> min.suffixOre().addOre(Ore.Minerals.BITUMEN.colored(-16777216)));
        Targets.init("quark", (gem, met, min) -> gem.suffixOre().addOre("biotite", -16514040));
        Targets.init("iceandfire", new IceAndFire());
        Targets.init("astralsorcery", new AstralSorcery());
        Targets.init("vanillafoodpantry", (gem, met, min) -> min.withSuffixes("ore", "ore_nether").addOres(Ore.Minerals.ROCK_SALT.colored(-4157042)).suffixOre().addOres(Ore.of("natron", -4995918), Ore.of("trona", -1329310)));
        Targets.init("tconstruct", (gem, met, min) -> met.suffixOre().addOres(Ore.Metals.COBALT.colored(-14976274), Ore.Metals.COPPER.colored(-8795257)));
        Targets.init("allthemodium", (gem, met, min) -> met.suffixOre().addOres(Ore.Metals.VIBRANIUM.colored(-14229880), Ore.of("unobtainium", -5755677)).withMetaAll().addOre(Ore.of("allthemodium", -14580)));
        Targets.init("omegacraft", (gem, met, min) -> met.withNoDelimiters().withPrefixes("ore_").withSuffixes("b").addOres(Ore.Metals.COPPER.colored(-4560384), Ore.Metals.TIN.colored(-4606271), Ore.Metals.LEAD.colored(-10063476), Ore.Metals.SILVER.colored(-6638148), Ore.Metals.ALUMINUM.colored(-5402465), Ore.of("magmite", -5427712)));
        Targets.init("bno", new BasicNetherOres());
        Targets.init("byg", new BiomesYouGo());
        Targets.init("gobber2", new Gobber());
        Targets.init("futurepack", new FuturePack());
        Targets.init("miningmaster", new MiningMaster());
        Targets.init("unearthed", new Unearthed());
        Targets.init("elementalcraft", (gem, met, min) -> gem.prefixNoneAndDeepslate().suffixOre().addOre("inert_crystal", -1841690));
        Targets.init("malum", (gem, met, min) -> gem.suffixOre().addOre("blazing_quartz", -1261257).withPrefixes("deepslate", "natural").addOre(Ore.Gems.QUARTZ.colored(-2435633)).prefixNoneAndDeepslate().addOre("soulstone", -8828541));
        Targets.init("mysticalagradditions", (gem, met, min) -> min.withPrefixes("nether", "end").suffixOre().addOre("prosperity", -3278086).addOre("inferium", -7558144));
        Targets.init("stalwart_dungeons", (gem, met, min) -> {
            gem.suffixOre().addOre("chorundum", -10473025);
            met.suffixOre().addOre(Ore.Metals.TUNGSTEN.colored(-6304660));
        });
        Targets.init("gemsandcrystals", (gem, met, min) -> gem.prefixNoneAndDeepslate().suffixOre().addOres(Ore.Gems.RUBY.colored(-6614754), Ore.Gems.SAPPHIRE.colored(-16770904), Ore.Gems.AMETHYST.colored(-6723892), Ore.Gems.TOPAZ.colored(-14212), Ore.Gems.QUARTZ.colored(-2578)));
        Targets.init("gemsnjewels", new GemsAndJewels());
        Targets.init("mekanism", new Mekanism());
        Targets.init("powah", (gem, met, min) -> met.prefixNoneAndDeepslate().withSuffixes("ore", "ore_poor", "ore_dense").addOres(Ore.Metals.URANINITE.colored(-12396800)));
        Targets.init("geolosys", new Geolosys());
        Targets.init("common_sense_forge", new CommonSense());
        Targets.init("blue_skies", new BlueSkies());
        Targets.init("divinerpg", new DivineRPG());
        Targets.init("beyond_earth", new BeyondEarth());
        Targets.init("thermal", new ThermalFoundation());
        Targets.init("oreandmore", new OreAndMore());
        Targets.init("aether", new TheAether());
        Targets.init("denseores", new DenseOres());
        Targets.init("condensedores", new CondensedOres());
        Targets.init("ad_astra", new AdAstra());
        Targets.init("many_more_ores", new ManyMoreOres());
        Targets.init("tfc", new TerraFirmaCraft());
        Targets.init("alexscaves", new AlexsCaves());
        Targets.init("gtceu", new GregTechCEu());
        Targets.init("spelunkery", new Spelunkery());
        Targets.init("electrodynamics", new Electrodynamics());
        Targets.init("ytech", new YTech());
        Targets.init("enderite", (gem, met, min) -> met.suffixOre().addOre("enderite", -13595009));
        Targets.init("meadow", new Meadow());
        Targets.init("overworld_netherite_ore", (gem, met, min) -> met.prefixNoneAndDeepslate().suffixOre().addOre(Ore.Metals.ANCIENT_DEBRIS.colored(-8626601)));
        Targets.init("deep_dark_regrowth", new DeepDarkRegrowth());
        Targets.init("deeperdarker", new DeeperDarker());
        Targets.init("draconicevolution", (gem, met, min) -> met.withPrefixes("deepslate", "overworld", "nether", "end").suffixOre().addOre("draconium", -12574109));
        Targets.init("irons_spellbooks", (gem, met, min) -> met.addOre("arcane_debris", -4473906));
        Targets.init("crystalcraft_unlimited_java", new CrystalcraftUnlimited());
        Targets.init("railcraft", new Railcraft());
        Targets.init("immersiveores", (gem, met, min) -> gem.suffixOre().addOre("vibranium", -6180157).addOre("vulpus", -3643300).addOre("enderium", -6438018));
    }

    static interface Initializer {
        public void init(Definitions var1, Definitions var2, Definitions var3);
    }

    static class Minecraft
    implements Initializer {
        Minecraft() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] prefixes = new String[]{"", "deepslate"};
            gems.withPrefixes(prefixes).suffixOre().addOre("nether_quartz", Ore.Gems.QUARTZ.colored(-790298)).addOres(Ore.Gems.DIAMOND.colored(-12721947), Ore.Gems.EMERALD.colored(-16209361), Ore.Gems.LAPIS.colored(-12621875));
            metals.addOre("ancient_debris", -8626601).withPrefixes(prefixes).suffixOre().addOre("nether_gold", Ore.Metals.GOLD.colored(-10496)).addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.COPPER.colored(-3840700), Ore.Metals.GOLD.colored(-10496)).withPrefixes("raw").withSuffixes("block").addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.COPPER.colored(-3840700), Ore.Metals.GOLD.colored(-10496));
            minerals.withPrefixes(prefixes).suffixOre().addOres(Ore.COAL).withMetaAll().addOre(Ore.Minerals.REDSTONE.colored(-4717564));
        }
    }

    static class ExtraGems
    implements Initializer {
        ExtraGems() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOres(Ore.Gems.RUBY.colored(-2549987), Ore.Gems.SAPPHIRE.colored(-15252007), Ore.Gems.AMETHYST.colored(-6875175), Ore.Gems.TOPAZ.colored(-2510825), Ore.Gems.CRYSTAL.colored(-7810327));
        }
    }

    static class UndergroundBiomes
    implements Initializer {
        UndergroundBiomes() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String ore = "ore_minecraft";
            String[] prefixes = Definitions.Prefixes.create().add("igneous", ore).add("metamorphic", ore).add("sedimentary", ore).toArray();
            ore = "ore";
            String[] suffixes = Definitions.Suffixes.create().add(ore, "andesite").add(ore, "basalt").add(ore, "black_granite").add(ore, "blueschist").add(ore, "chalk").add(ore, "chert").add(ore, "dacite").add(ore, "dolomite").add(ore, "eclogite").add(ore, "gabbro").add(ore, "gneiss").add(ore, "granite").add(ore, "greenschist").add(ore, "greywacke").add(ore, "komatiite").add(ore, "lignite").add(ore, "limestone").add(ore, "marble").add(ore, "migmatite").add(ore, "quartzite").add(ore, "red_granite").add(ore, "rhyolite").add(ore, "shale").add(ore, "siltstone").add(ore, "soapstone").toArray();
            gems.withPrefixes(prefixes).withSuffixes(suffixes).withMetaAll().addOres(Ore.Gems.DIAMOND.colored(-11866671), Ore.Gems.EMERALD.colored(-16732104), Ore.Gems.LAPIS.colored(-16776961));
            metals.withPrefixes(prefixes).withSuffixes(suffixes).withMetaAll().addOres(Ore.Metals.GOLD.colored(-10496), Ore.Metals.IRON.colored(-2180985));
            minerals.withPrefixes(prefixes).withSuffixes(suffixes).withMetaAll().addOres(Ore.COAL, Ore.Minerals.REDSTONE.colored(-65536));
        }
    }

    static class MysticalWorld
    implements Initializer {
        MysticalWorld() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOres(Ore.Gems.AMETHYST.colored(-2776838));
            metals.suffixOre().addOres(Ore.Metals.COPPER.colored(-953046), Ore.Metals.LEAD.colored(-13355709), Ore.Metals.SILVER.colored(-6375738), Ore.Metals.TIN.colored(-7165290)).addOre("quicksilver", Ore.Metals.SILVER.colored(-7627102));
        }
    }

    static class Techemistry
    implements Initializer {
        Techemistry() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            minerals.suffixOre().addOres(Ore.Minerals.CARBONATE.colored(-1252946), Ore.Minerals.PHOSPHATE.colored(-9836645), Ore.Minerals.SULFUR.colored(-200960), Ore.Minerals.OXIDE.colored(-4079167), Ore.Minerals.SULFATE.colored(-4730698));
        }
    }

    static class SimpleOres
    implements Initializer {
        SimpleOres() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOre(Ore.Gems.ONYX.colored(-15132391));
            metals.prefixNoneAndDeepslate().suffixOre().addOres(Ore.Metals.TIN.colored(-8158320), Ore.Metals.MYTHRIL.colored(-9013523), Ore.Metals.ADAMANTIUM.colored(-13863354));
        }
    }

    static class GemsPlusPlus
    implements Initializer {
        GemsPlusPlus() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.withNoDelimiters().withPrefixes("ore", "netherore").addOres(Ore.Gems.RUBY.colored(-3533788), Ore.Gems.SAPPHIRE.colored(-16768648), Ore.Gems.AMETHYST.colored(-13631368), Ore.Gems.TOPAZ.colored(-10662641), new Ore("phoenixite", -766720), Ore.Gems.JADE.colored(-10434028), Ore.Gems.CITRINE.colored(-3495404), Ore.Gems.GARNET.colored(-6025187), Ore.Gems.SPINEL.colored(-3533722), Ore.Gems.ONYX.colored(-15987700), Ore.Gems.AGATE.colored(-15435318), Ore.Gems.MALACHITE.colored(-15414702), Ore.Gems.TOURMALINE.colored(-3533676), Ore.Gems.CHRYSOCOLLA.colored(-15414599), Ore.Gems.JASPER.colored(-5362120), Ore.Gems.SUGILITE.colored(-11796258));
        }
    }

    static class SilentGems
    implements Initializer {
        SilentGems() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.withSuffixes("classic", "dark", "light").addOre(new Ore("multi_ore", -1));
            gems.suffixOre().addOres(new Ore("chaos", -5004387), new Ore("ender", -11476799), new Ore("cats_eye", -342978)).addOre("green_sapphire", Ore.Gems.SAPPHIRE.colored(-15214305)).addOre("black_diamond", -16777216).addOre("yellow_diamond", -918978).addOre("white_diamond", -1).addOre("rose_quartz", Ore.Gems.QUARTZ.colored(-1481064));
            gems.suffixOre().addOres(Ore.Gems.PHOSPHOPHYLLITE.colored(-15214208), Ore.Gems.CARNELIAN.colored(-4517376), Ore.Gems.MORGANITE.colored(-371764), Ore.Gems.SPINEL.colored(-4501504), Ore.Gems.CITRINE.colored(-4493568), Ore.Gems.JASPER.colored(-4481536), Ore.Gems.ZIRCON.colored(-4605184), Ore.Gems.MOLDAVITE.colored(-6636800), Ore.Gems.MALACHITE.colored(-16729279), Ore.Gems.TURQUOISE.colored(-16729186), Ore.Gems.EUCLASE.colored(-16745541), Ore.Gems.BENITOITE.colored(-16769605), Ore.Gems.ALEXANDRITE.colored(-5439301), Ore.Gems.LEPIDOLITE.colored(-4521846), Ore.Gems.AMETRINE.colored(-4521893), Ore.Gems.MOONSTONE.colored(-10395295), Ore.Gems.MALACHITE.colored(-16729279), Ore.Gems.PYROPE.colored(-377244), Ore.Gems.CORAL.colored(-371138), Ore.Gems.SUNSTONE.colored(-362946), Ore.Gems.JADE.colored(-7079362), Ore.Gems.CHRYSOPRASE.colored(-11208130), Ore.Gems.APATITE.colored(-12649772), Ore.Gems.FLUORITE.colored(-12664070), Ore.Gems.KYANITE.colored(-13014299), Ore.Gems.SODALITE.colored(-14406508), Ore.Gems.AMMOLITE.colored(-3787046), Ore.Gems.KUNZITE.colored(-2541898), Ore.Gems.TEKTITE.colored(-9412268), Ore.Gems.PEARL.colored(-7496010), Ore.Gems.RUBY.colored(-2547945), Ore.Gems.GARNET.colored(-2535401), Ore.Gems.TOPAZ.colored(-2526953), Ore.Gems.AMBER.colored(-2514665), Ore.Gems.HELIODOR.colored(-2506473), Ore.Gems.PERIDOT.colored(-7349993), Ore.Gems.BERYL.colored(-15214305), Ore.Gems.INDICOLITE.colored(-15214208), Ore.Gems.AQUAMARINE.colored(-15232598), Ore.Gems.SAPPHIRE.colored(-14871077), Ore.Gems.IOLITE.colored(-10479655), Ore.Gems.AMETHYST.colored(-6088741), Ore.Gems.AGATE.colored(-2549808), Ore.Gems.ONYX.colored(-16777216), Ore.Gems.OPAL.colored(-4737097));
            metals.withPrefixes("", "deepslate").suffixOre().addOres(Ore.Metals.SILVER.colored(-2829100));
        }
    }

    static class SilentGear
    implements Initializer {
        SilentGear() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.suffixOre().addOre("crimson_iron", -2927504).addOre("azure_silver", -1597204);
            minerals.prefixNoneAndDeepslate().suffixOre().addOre("bort", -5193255);
        }
    }

    static class SilentsMechanisms
    implements Initializer {
        SilentsMechanisms() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.suffixOre().addOres(Ore.Metals.ZINC.colored(-11113380), Ore.Metals.TIN.colored(-7953744), Ore.Metals.NICKEL.colored(-1843297), Ore.Metals.COPPER.colored(-492214), Ore.Metals.BAUXITE.colored(-1726794), Ore.Metals.LEAD.colored(-6385992), Ore.Metals.URANIUM.colored(-7285618), Ore.Metals.PLATINUM.colored(-6832194), Ore.Metals.BISMUTH.colored(-3754036), Ore.Metals.SILVER.colored(-6838593));
        }
    }

    static class MoreOresInONE
    implements Initializer {
        MoreOresInONE() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOres(Ore.Gems.RUBY.colored(-3996641), Ore.Gems.AMETHYST.colored(-7927400), Ore.Gems.SAPPHIRE.colored(-11199024), Ore.Gems.TOPAZ.colored(-354544));
            gems.withPrefixes("overworld", "end", "nether").suffixOre().addOre("exp", -16716752);
        }
    }

    static class MineAndSlash
    implements Initializer {
        MineAndSlash() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.prefixOre().addOre("block0", new Ore("common ore", -10782866)).addOre("block1", new Ore("uncommon ore", -15214240)).addOre("block2", new Ore("rare ore", -3614441)).addOre("block3", new Ore("epic ore", -15226919)).addOre("block4", new Ore("legendary ore", -2512361)).addOre("block5", new Ore("mythical ore", -2287709));
        }
    }

    static class ImmersiveEngineering
    implements Initializer {
        ImmersiveEngineering() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.withPrefixes("ore", "deepslate_ore").addOres(Ore.Metals.COPPER.colored(-11371417), Ore.Metals.ALUMINUM.colored(-8232882), Ore.Metals.LEAD.colored(-12634036), Ore.Metals.SILVER.colored(-4142900), Ore.Metals.NICKEL.colored(-6709351), Ore.Metals.URANIUM.colored(-11243448));
        }
    }

    static class IceAndFire
    implements Initializer {
        IceAndFire() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOre("amythest", Ore.Gems.AMETHYST.colored(-4440321)).addOres(Ore.Gems.SAPPHIRE.colored(-15178256));
            metals.suffixOre().addOres(Ore.Metals.COPPER.colored(-3233161), Ore.Metals.SILVER.colored(-1708809));
        }
    }

    static class AstralSorcery
    implements Initializer {
        AstralSorcery() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOre("aquamarine_sand", Ore.Gems.AQUAMARINE.colored(-12913665)).addOre("rock_crystal", -1);
            metals.suffixOre().addOre("starmetal", -16772262);
        }
    }

    static class BasicNetherOres
    implements Initializer {
        BasicNetherOres() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String nether = "nether";
            metals.withPrefixes("nether").suffixOre().addOres(Ore.Metals.SILVER.colored(-2829100), Ore.Metals.IRON.colored(-2839664), Ore.Metals.LEAD.colored(-7958373), Ore.Metals.NICKEL.colored(-5263210), Ore.Metals.COPPER.colored(-2067635), Ore.Metals.ALUMINUM.colored(-8092509), Ore.Metals.TIN.colored(-4473925), Ore.Metals.OSMIUM.colored(-2960653), Ore.Metals.ZINC.colored(-6899554), Ore.Metals.URANIUM.colored(-7421301));
            gems.withPrefixes("nether").suffixOre().addOres(Ore.Gems.EMERALD.colored(-15214240), Ore.Gems.DIAMOND.colored(-12788512), Ore.Gems.LAPIS.colored(-15711319));
            minerals.withPrefixes("nether").suffixOre().addOres(Ore.Minerals.REDSTONE.colored(-3537145), Ore.COAL.colored(-12698050));
        }
    }

    static class BiomesYouGo
    implements Initializer {
        BiomesYouGo() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOres(Ore.Gems.AMETRINE.colored(-3707734), Ore.Gems.EMERALDITE.colored(-16209361)).addOre("budding_ametrine", Ore.Gems.AMETRINE.colored(-3707734)).addOre("brimstone_nether_quartz", Ore.Gems.QUARTZ.colored(-790298));
            metals.suffixOre().addOre("pendorite", -11264943).addOre("blue_nether_gold", Ore.Metals.GOLD.colored(-10496)).addOre("brimstone_nether_gold", Ore.Metals.GOLD.colored(-10496));
            minerals.addOre("pervaded_netherrack", Ore.of("netherrack", -989321));
            minerals.suffixOre().addOres(Ore.ANTHRACITE.colored(-15854821), Ore.LIGNITE.colored(-11189967)).addOre("cryptic_redstone", Ore.Minerals.REDSTONE.colored(-5766140));
        }
    }

    static class Gobber
    implements Initializer {
        Gobber() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String prefix = "gobber2";
            metals.withPrefixes("gobber2").addOre("ore", -11301691).addOre("ore_nether", -5424279).addOre("ore_end", -14304610);
            gems.withPrefixes("gobber2").addOre("lucky_block", -11301690);
        }
    }

    static class FuturePack
    implements Initializer {
        FuturePack() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            minerals.prefixOre().addOre("coal_m", Ore.COAL.colored(-13421773));
            metals.prefixOre().addOres(Ore.Metals.BAUXITE.colored(-3716864), Ore.Metals.COPPER.colored(-1735856), Ore.Metals.TIN.colored(-3487030), Ore.Metals.ZINC.colored(-7159812), Ore.Metals.MAGNETITE.colored(-8095694)).addOre("copper_m", Ore.Metals.COPPER.colored(-1932979));
            gems.prefixOre().addOre("quartz_m", Ore.Gems.QUARTZ.colored(-2764083));
        }
    }

    static class MiningMaster
    implements Initializer {
        MiningMaster() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOre("fire_ruby", Ore.Gems.RUBY.colored(-4123608)).addOre("ice_sapphire", Ore.Gems.SAPPHIRE.colored(-15582521)).addOre("spirit_garnet", Ore.Gems.GARNET.colored(-10873545)).addOre("haste_peridot", Ore.Gems.PERIDOT.colored(-6703838)).addOre("lucky_citrine", Ore.Gems.CITRINE.colored(-2531575)).addOre("dive_aquamarine", Ore.Gems.AQUAMARINE.colored(-13075541)).addOre("heart_rhodonite", Ore.Gems.RHODONITE.colored(-365942)).addOre("power_pyrite", Ore.Gems.PYRITE.colored(-6060731)).addOre("kinetic_opal", Ore.Gems.OPAL.colored(-810431)).addOre("air_malachite", Ore.Gems.MALACHITE.colored(-16729189));
        }
    }

    static class Unearthed
    implements Initializer {
        Unearthed() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] prefixes = new String[]{"slate", "gabbro", "conglomerate", "granodiorite", "white_granite", "rhyolite", "phyllite", "beige_limestone", "limestone", "grey_limestone", "siltstone", "mudstone", "sandstone"};
            gems.withPrefixes(prefixes).suffixOre().addOres(Ore.Gems.DIAMOND.colored(-12721947), Ore.Gems.EMERALD.colored(-16209361), Ore.Gems.LAPIS.colored(-16776961));
            metals.withPrefixes(prefixes).suffixOre().addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.COPPER.colored(-3840700), Ore.Metals.GOLD.colored(-10496));
            minerals.withPrefixes(prefixes).suffixOre().addOres(Ore.COAL).withMetaAll().addOre(Ore.Minerals.REDSTONE.colored(-65536));
        }
    }

    static class GemsAndJewels
    implements Initializer {
        GemsAndJewels() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] suffixes = new String[]{"ore_block", "deepslate_ore_block", "nether_ore_block"};
            gems.withSuffixes(suffixes).addOres(Ore.of("pale_diamond", -5384466), Ore.Gems.DIAMOND.colored(-12987946), Ore.Gems.EMERALD.colored(-16724354), Ore.Gems.RUBY.colored(-3271373), Ore.Gems.SAPPHIRE.colored(-16765773), Ore.Gems.AMETHYST.colored(-4689942), Ore.Gems.OPAL.colored(-2039584), Ore.Gems.GARNET.colored(-11202784), Ore.Gems.TOPAZ.colored(-2449589), Ore.Gems.PERIDOT.colored(-5905065), Ore.Gems.AQUAMARINE.colored(-12398376), Ore.Gems.ZIRCON.colored(-14392603), Ore.Gems.ALEXANDRITE.colored(-10349106), Ore.Gems.TANZANITE.colored(-8245052), Ore.Gems.TOURMALINE.colored(-4187031), Ore.Gems.SPINEL.colored(-1747080), Ore.of("black_opal", -16699586), Ore.Gems.CITRINE.colored(-1139661), Ore.Gems.MORGANITE.colored(-1148811), Ore.Gems.AMETRINE.colored(-7000096), Ore.Gems.KUNZITE.colored(-1747011), Ore.Gems.IOLITE.colored(-10747700), Ore.of("bright_opal", -1118482));
        }
    }

    static class Mekanism
    implements Initializer {
        Mekanism() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.prefixNoneAndDeepslate().suffixOre().addOres(Ore.Metals.TIN.colored(-2434342), Ore.Metals.OSMIUM.colored(-5654583), Ore.Metals.URANIUM.colored(-11945910), Ore.Metals.LEAD.colored(-11841441));
            gems.prefixNoneAndDeepslate().suffixOre().addOres(Ore.Gems.FLUORITE.colored(-2317607));
        }
    }

    static class Geolosys
    implements Initializer {
        Geolosys() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.prefixNoneAndDeepslate().suffixOre().addOres(Ore.Gems.QUARTZ.colored(-5325604), Ore.Gems.MALACHITE.colored(-12805263), Ore.Gems.AZURITE.colored(-14336402), Ore.Gems.BERYL.colored(-16713053), Ore.Gems.KIMBERLITE.colored(-9447485), Ore.Gems.LAPIS.colored(-16776961));
            metals.suffixOre().addOre(Ore.Metals.ANCIENT_DEBRIS.colored(-11917283)).addOre("nether_gold", Ore.Metals.GOLD.colored(-3102682)).prefixNoneAndDeepslate().addOres(Ore.Metals.AUTUNITE.colored(-4596720), Ore.Metals.SPHALERITE.colored(-11977378), Ore.Metals.TEALLITE.colored(-4611696), Ore.Metals.BAUXITE.colored(-5409458), Ore.Metals.GALENA.colored(-11514018), Ore.Metals.HEMATITE.colored(-9884132), Ore.Metals.CASSITERITE.colored(-2962779), Ore.Metals.GOLD.colored(-10496), Ore.Metals.PLATINUM.colored(-8091235), Ore.Metals.LIMONITE.colored(-4022950));
            minerals.prefixNoneAndDeepslate().suffixOre().addOre(Ore.Minerals.CINNABAR.colored(-7661044)).addOre("anthracite_coal", Ore.COAL).addOre(Ore.COAL).addOre("bituminous_coal", Ore.COAL.colored(-14212833)).addOre("lignite", Ore.COAL.colored(-14212833));
        }
    }

    static class CommonSense
    implements Initializer {
        CommonSense() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] stoneTypes = new String[]{"andesite", "diorite", "granite"};
            gems.suffixOre().withPrefixes("", "deep_slate").addOres(Ore.Gems.AMBER.colored(-1199616)).withPrefixes(stoneTypes).addOres(Ore.Gems.DIAMOND.colored(-12721947), Ore.Gems.EMERALD.colored(-16209361), Ore.Gems.LAPIS.colored(-16776961));
            metals.suffixOre().addOres(Ore.of("ancient", -10588061), Ore.of("prabalit", -10588061), Ore.of("netherack_iron", -2903395)).withPrefixes(stoneTypes).addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.COPPER.colored(-3840700), Ore.Metals.GOLD.colored(-10496));
            minerals.addOre("rock_salt", -1188418).suffixOre().addOre("end_fragment", -2299991).withPrefixes("", "deepslate").addOres(Ore.Minerals.NITER.colored(-7434752)).withPrefixes("", "deep_slate").addOres(Ore.Minerals.SULFUR.colored(-4276736)).withPrefixes(stoneTypes).addOres(Ore.COAL).withMetaAll().addOre(Ore.Minerals.REDSTONE.colored(-65536));
        }
    }

    static class BlueSkies
    implements Initializer {
        BlueSkies() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.withPrefixes("everbright", "everdawn").suffixOre().addOres(Ore.Gems.EMERALD.colored(-12721541), Ore.Gems.MOONSTONE.colored(-7092257), Ore.Gems.PYROPE.colored(-3400145), Ore.of("aquite", -11163693), Ore.of("diopside", -16723945), Ore.of("charoite", -5603126));
            metals.suffixOre().addOre("falsite", -10602330).addOre("ventium", -3328972).addOre("horizonite", -1211082);
        }
    }

    static class DivineRPG
    implements Initializer {
        DivineRPG() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.withSuffixes("ore", "ore_deepslate").addOre("arlemite", -13068766).addOre("realmite", -4762108).addOre("rupee", -14456414).suffixOre().addOre("torridite", -5097172);
            gems.suffixOre().addOre("bloodgem", -3982478).addOre("eden", -1).addOre("wildwood", -13404736).addOre("apalachia", -2003997).addOre("skythern", -4210482).addOre("mortum", -11120046);
        }
    }

    static class BeyondEarth
    implements Initializer {
        BeyondEarth() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().withPrefixes("mars", "venus").addOre(Ore.Gems.DIAMOND.colored(-14892344)).withPrefixes("glacio").addOre(Ore.Gems.LAPIS.colored(-15315024));
            metals.suffixOre().withPrefixes("moon").addOre("desh", -2652599).withPrefixes("mars").addOre("ostrum", -10925494).withPrefixes("moon", "mars", "mercury", "glacio").addOre(Ore.Metals.IRON.colored(-3497079)).withPrefixes("venus").addOre(Ore.Metals.GOLD.colored(-1319354)).addOre("calorite", -8514252).withPrefixes("glacio").addOre(Ore.Metals.COPPER.colored(-3052728));
            minerals.suffixOre().withPrefixes("moon").addOre("cheese", -1128636).withPrefixes("moon", "mars", "glacio").addOre("ice_shard", -8677163).withPrefixes("venus", "glacio").addOre(Ore.COAL.colored(-13487566));
        }
    }

    static class ThermalFoundation
    implements Initializer {
        ThermalFoundation() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.prefixNoneAndDeepslate().suffixOre().addOres(Ore.Metals.TIN.colored(-6899275), Ore.Metals.LEAD.colored(-14605743), Ore.Metals.SILVER.colored(-6968911), Ore.Metals.NICKEL.colored(-2570610));
            minerals.prefixNoneAndDeepslate().suffixOre().addOres(Ore.Minerals.CINNABAR.colored(-7202265), Ore.Minerals.NITER.colored(-6450542), Ore.Minerals.SULFUR.colored(-2833568));
        }
    }

    static class OreAndMore
    implements Initializer {
        OreAndMore() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.addOre("demoniteore", Ore.of("demonite", -3537916)).addOre("auric_ore", Ore.of("auric", -4619447));
            gems.addOre("rubyore", Ore.Gems.RUBY.colored(-7266271)).addOre("deepslatediamondore", Ore.Gems.DIAMOND.colored(-6348252)).addOre("rose_quartz_ore", Ore.Gems.QUARTZ.colored(-1875081)).addOre("fire_embers_ore", Ore.of("fire_embers", -4164045));
        }
    }

    static class TheAether
    implements Initializer {
        TheAether() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            minerals.suffixOre().addOre("ambrosium", -1842855);
            gems.suffixOre().addOre("zanite", -9293103).addOre("gravitite", -7583866);
        }
    }

    static class DenseOres
    implements Initializer {
        DenseOres() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] prefixes = new String[]{"dense", "dense_deepslate"};
            gems.withPrefixes(prefixes).suffixOre().addOres(Ore.Gems.DIAMOND.colored(-12721947), Ore.Gems.EMERALD.colored(-16209361), Ore.Gems.LAPIS.colored(-16776961)).addOre("nether_quartz", Ore.Gems.QUARTZ.colored(-790298));
            metals.addOre("ancient_nether_ore", Ore.Metals.ANCIENT_DEBRIS.colored(-8626601)).withPrefixes(prefixes).suffixOre().addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.COPPER.colored(-3840700), Ore.Metals.GOLD.colored(-10496)).addOre("nether_gold", Ore.Metals.GOLD.colored(-10496));
            minerals.withPrefixes(prefixes).suffixOre().addOres(Ore.COAL).withMetaAll().addOre(Ore.Minerals.REDSTONE.colored(-65536));
        }
    }

    static class CondensedOres
    implements Initializer {
        CondensedOres() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] prefixes = new String[]{"dense"};
            gems.withPrefixes(prefixes).suffixOre().addOres(Ore.Gems.DIAMOND.colored(-12721947), Ore.Gems.EMERALD.colored(-16209361), Ore.Gems.LAPIS.colored(-16776961)).addOre("nether_quartz", Ore.Gems.QUARTZ.colored(-790298));
            metals.addOre("dense_debris", Ore.Metals.ANCIENT_DEBRIS.colored(-8626601)).withPrefixes(prefixes).suffixOre().addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.COPPER.colored(-3840700), Ore.Metals.GOLD.colored(-10496)).addOre("nether_gold", Ore.Metals.GOLD.colored(-10496));
            minerals.withPrefixes(prefixes).suffixOre().addOres(Ore.COAL).withMetaAll().addOre(Ore.Minerals.REDSTONE.colored(-65536));
        }
    }

    static class AdAstra
    implements Initializer {
        AdAstra() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            minerals.suffixOre().addOre("moon_cheese", -1197534).withPrefixes("venus", "glacio").addOre(Ore.COAL.colored(-14540254));
            metals.suffixOre().withPrefixes("moon", "deepslate").addOre("desh", -4234951).withPrefixes("moon", "mars", "glacio", "mercury").addOre(Ore.Metals.IRON.colored(-3562615)).withPrefixes("mars", "deepslate").addOre("ostrum", -8821403).withPrefixes("glacio").addOre(Ore.Metals.COPPER.colored(-3052728)).withPrefixes("venus").addOre(Ore.Metals.GOLD.colored(-1319354)).withPrefixes("venus", "deepslate").addOre("calorite", -8514508);
            gems.suffixOre().withPrefixes("moon", "mars", "glacio", "deepslate").addOre("ice_shard", -8677164).withPrefixes("mars", "venus").addOre(Ore.Gems.DIAMOND.colored(-14892345)).withPrefixes("glacio").addOre(Ore.Gems.LAPIS.colored(-15315024));
        }
    }

    static class ManyMoreOres
    implements Initializer {
        ManyMoreOres() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.prefixNoneAndDeepslate().suffixOre().addOre("modrine", -1572632);
            metals.suffixOre().addOre("hocralt", -5701632).addOre("eskial", -6053028).addOre("loscalt", -16734453).addOre("poflese", -11184788).addOre("scalium", -3092480).addOre("vupline", -8832371).prefixNoneAndDeepslate().addOre("chathil", -13948053).addOre("tobrine", -9422848).addOre("gaspium", -4561054).addOre("askium", -4629831).addOre("blaerium", -16763577);
        }
    }

    static class TerraFirmaCraft
    implements Initializer {
        TerraFirmaCraft() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String ore = "ore/";
            String[] oreTypes = new String[]{"ore/poor_", "ore/normal_", "ore/rich_"};
            String[] stoneTypes = new String[]{"/granite", "/diorite", "/gabbro", "/shale", "/claystone", "/limestone", "/conglomerate", "/dolomite", "/chert", "/chalk", "/rhyolite", "/basalt", "/andesite", "/dacite", "/quartzite", "/slate", "/phyllite", "/schist", "/gneiss", "/marble", "/granite"};
            metals.withNoDelimiters().withPrefixes(oreTypes).withSuffixes(stoneTypes).addOre("native_copper", Ore.Metals.COPPER.colored(-5343416)).addOre("native_gold", Ore.Metals.GOLD.colored(-3298753)).addOre("native_silver", Ore.Metals.SILVER.colored(-4079152)).addOre("bismuthinite", Ore.Metals.BISMUTH.colored(-10132148)).addOre("malachite", Ore.Gems.MALACHITE.colored(-9458508)).addOres(Ore.Metals.HEMATITE.colored(-5740210), Ore.Metals.CASSITERITE.colored(-10529208), Ore.Metals.GARNIERITE.colored(-12690614), Ore.Metals.MAGNETITE.colored(-12433334), Ore.Metals.LIMONITE.colored(-6587318), Ore.Metals.SPHALERITE.colored(-8947849), Ore.Metals.TETRAHEDRITE.colored(-12763843));
            minerals.withNoDelimiters().withPrefixes(ore).withSuffixes(stoneTypes).addOre("bituminous_coal", Ore.COAL.colored(-15461356)).addOres(Ore.LIGNITE.colored(-14081512), Ore.of("gypsum", -5070712), Ore.Minerals.GRAPHITE.colored(-12628129), Ore.Minerals.SULFUR.colored(-3947755), Ore.Minerals.CINNABAR.colored(-5297602), Ore.of("cryolite", -3552823), Ore.Minerals.SALTPETER.colored(-7631989), Ore.of("sylvite", -5814200), Ore.of("borax", -3092272), Ore.of("halite", -1184275));
            gems.withNoDelimiters().withPrefixes(ore).withSuffixes(stoneTypes).addOre("lapis_lazuli", Ore.Gems.LAPIS.colored(-15781712)).addOres(Ore.Gems.AMETHYST.colored(-4306754), Ore.Gems.DIAMOND.colored(-12987947), Ore.Gems.EMERALD.colored(-12721541), Ore.Gems.OPAL.colored(-5539950), Ore.Gems.PYRITE.colored(-2705574), Ore.Gems.RUBY.colored(-4774876), Ore.Gems.SAPPHIRE.colored(-12092753));
        }
    }

    static class AlexsCaves
    implements Initializer {
        AlexsCaves() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.suffixOre().withPrefixes("radrock").addOre(Ore.Metals.URANIUM.colored(-16712704)).withPrefixes("galena").addOre(Ore.Metals.IRON.colored(-3299958));
            minerals.suffixOre().withPrefixes("guanostone").addOre(Ore.Minerals.REDSTONE.colored(-4454649)).withPrefixes("coprolith").addOre(Ore.COAL.colored(-13421773));
        }
    }

    static class GregTechCEu
    implements Initializer {
        GregTechCEu() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] prefixes = new String[]{"", "granite", "diorite", "andesite", "deepslate", "tuff", "sand", "red_sand", "gravel", "basalt", "netherrack", "endstone"};
            gems.withPrefixes(prefixes).suffixOre().addOre("yellow_garnet", Ore.Gems.GARNET.colored(-1708792)).addOre("red_garnet", Ore.Gems.GARNET.colored(-7664876)).addOre("blue_topaz", Ore.Gems.TOPAZ.colored(-12299429)).addOre("certus_quartz", Ore.Gems.QUARTZ.colored(-4802872)).addOre("nether_quartz", Ore.Gems.QUARTZ.colored(-3754571)).addOre("green_sapphire", Ore.Gems.SAPPHIRE.colored(-10568582)).addOres(Ore.Gems.SODALITE.colored(-15658537), Ore.Gems.SPESSARTINE.colored(-1205220), Ore.Gems.WULFENITE.colored(-6282240), Ore.Gems.TANZANITE.colored(-12844868), Ore.Gems.EMERALD.colored(-11800501), Ore.Gems.TOPAZ.colored(-2570186), Ore.Gems.MALACHITE.colored(-16596340), Ore.Gems.SCHEELITE.colored(-13877665), Ore.Gems.OLIVINE.colored(-6499324), Ore.Gems.APATITE.colored(-16334880), Ore.Gems.QUARTZITE.colored(-4798282), Ore.Gems.MAGNESITE.colored(-13620701), Ore.Gems.JASPER.colored(-4437173), Ore.Gems.PYROPE.colored(-2615470), Ore.Gems.VINTEUM.colored(-10568464), Ore.Gems.BASTNASITE.colored(-5349337), Ore.Gems.RUBY.colored(-3661553), Ore.Gems.GROSSULAR.colored(-1201553), Ore.Gems.SAPPHIRE.colored(-13684269), Ore.Gems.AMETHYST.colored(-12899748), Ore.Gems.OPAL.colored(-15377556), Ore.Gems.CALCITE.colored(-3491150), Ore.Gems.SPODUMENE.colored(-7707249), Ore.Gems.PYRITE.colored(-8822496), Ore.Gems.LAZURITE.colored(-14339360), Ore.Gems.LAPIS.colored(-11043124), Ore.Gems.ALMANDINE.colored(-7334892), Ore.Gems.DIAMOND.colored(-4328718), Ore.Gems.REALGAR.colored(-1230545));
            metals.withPrefixes(prefixes).suffixOre().addOre("cassiterite_sand", Ore.Metals.CASSITERITE.colored(-11053225)).addOre("glauconite_sand", Ore.Metals.GLAUCONITE.colored(-15237810)).addOre("yellow_limonite", Ore.Metals.LIMONITE.colored(-6118912)).addOre("brown_limonite", Ore.Metals.LIMONITE.colored(-6139648)).addOre("vanadium_magnetite", Ore.Metals.MAGNETITE.colored(-13949387)).addOre("aluminium", Ore.Metals.ALUMINUM.colored(-9985598)).addOre("uranium235", Ore.Metals.URANIUM.colored(-12192443)).addOre("banded_iron", Ore.Metals.IRON.colored(-9090743)).addOre("naquadah_enriched", Ore.Metals.NAQUADAH.colored(-15724528)).addOre("fullers_earth", -4407927).addOre("electrotine", -9259813).addOres(Ore.Metals.GALENA.colored(-12375997), Ore.Metals.POWELLITE.colored(-8560068), Ore.Metals.OSMIUM.colored(-13224277), Ore.Metals.LITHIUM.colored(-5987164), Ore.Metals.SILVER.colored(-2565894), Ore.Metals.TIN.colored(-5066062), Ore.Metals.COOPERITE.colored(-4469885), Ore.Metals.GOLD.colored(-2039808), Ore.Metals.URANIUM.colored(-14106072), Ore.Metals.IRON.colored(-9145228), Ore.Metals.IRIDIUM.colored(-3223858), Ore.Metals.ILMENITE.colored(-14673648), Ore.Metals.MOLYBDENUM.colored(-7697739), Ore.Metals.TANTALITE.colored(-12034431), Ore.Metals.MOLYBDENITE.colored(-13356241), Ore.Metals.PITCHBLENDE.colored(-2246339), Ore.Metals.TUNGSTATE.colored(-9483483), Ore.Metals.PYROLUSITE.colored(-8816247), Ore.Metals.LEPIDOLITE.colored(-11916219), Ore.Metals.SPHALERITE.colored(-1192577), Ore.Metals.URANINITE.colored(-1194453), Ore.Metals.TETRAHEDRITE.colored(-13616338), Ore.Metals.CHROMITE.colored(-12374454), Ore.Metals.COBALT.colored(-14605928), Ore.Metals.GARNIERITE.colored(-13918619), Ore.Metals.LEAD.colored(-9416592), Ore.Metals.COPPER.colored(-3380150), Ore.Metals.RUTILE.colored(-3601321), Ore.Metals.PLATINUM.colored(-1185589), Ore.Metals.PALLADIUM.colored(-10197653), Ore.Metals.BERYLLIUM.colored(-11365806), Ore.Metals.MONAZITE.colored(-4006259), Ore.Metals.NIOBIUM.colored(-8950647), Ore.Metals.BARITE.colored(-7506875), Ore.Metals.THORIUM.colored(-14275809), Ore.Metals.MAGNETITE.colored(-15198184), Ore.Metals.BISMUTH.colored(-11435647), Ore.Metals.BAUXITE.colored(-8574703), Ore.Metals.PENTLANDITE.colored(-8029948), Ore.Metals.CASSITERITE.colored(-15329772), Ore.Metals.CHALCOPYRITE.colored(-7625369), Ore.Metals.NICKEL.colored(-4271900), Ore.Metals.ZINC.colored(-3489086), Ore.Metals.NEODYMIUM.colored(-13750738), Ore.Metals.CHALCOCITE.colored(-10588039), Ore.Metals.STIBNITE.colored(-13158601), Ore.Metals.COBALTITE.colored(-12500533), Ore.Metals.PLUTONIUM.colored(-6085853), Ore.Metals.HEMATITE.colored(-1218214), Ore.Metals.GOETHITE.colored(-8885455), Ore.Metals.BORNITE.colored(-7045585), Ore.Metals.NAQUADAH.colored(-14145496), Ore.Metals.MICA.colored(-8752044), Ore.Metals.ALUNITE.colored(-7061470), Ore.Metals.KYANITE.colored(-8283722), Ore.Metals.PYROCHLORE.colored(-11452623), Ore.Metals.POLLUCITE.colored(-2898997), Ore.Metals.BENTONITE.colored(-7634873), Ore.Metals.ZEOLITE.colored(-3886161));
            minerals.withPrefixes(prefixes).suffixOre().addOre("rock_salt", Ore.Minerals.SALT.colored(-3101267)).addOre("tricalcium_phosphate", -4079509).addOre("granitic_mineral_sand", -6265003).addOre("garnet_sand", -7195880).addOre("basaltic_mineral_sand", -12368573).addOres(Ore.Minerals.PHOSPHOR.colored(-1579264), Ore.Minerals.SALTPETER.colored(-3684409), Ore.COAL.colored(-15461096), Ore.Minerals.TALC.colored(-12158887), Ore.Minerals.SALT.colored(-2236963), Ore.Minerals.REDSTONE.colored(-6225920), Ore.Minerals.PHOSPHATE.colored(-3224064), Ore.LIGNITE.colored(-11257029), Ore.OILSANDS.colored(-7175588), Ore.Minerals.SOAPSTONE.colored(-12562875), Ore.Minerals.GRAPHITE.colored(-11184811), Ore.Minerals.SULFUR.colored(-5329408), Ore.Minerals.ASBESTOS.colored(-8158856), Ore.Minerals.TRONA.colored(-3289697), Ore.Minerals.GYPSUM.colored(-1909298), Ore.Minerals.DIATOMITE.colored(-1185303), Ore.Minerals.CINNABAR.colored(-1233064));
        }
    }

    static class Spelunkery
    implements Initializer {
        Spelunkery() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] prefixes = new String[]{"andesite", "diorite", "granite", "tuff"};
            gems.suffixOre().addOre("smooth_basalt_diamond", Ore.Gems.DIAMOND.colored(-16330295)).addOre("sandstone_lapis", Ore.Gems.LAPIS.colored(-13608514)).withPrefixes(prefixes).addOres(Ore.Gems.LAPIS.colored(-13608514), Ore.Gems.EMERALD.colored(-14571425), Ore.Gems.DIAMOND.colored(-16330295));
            metals.suffixOre().withPrefixes(prefixes).addOres(Ore.Metals.IRON.colored(-3562615), Ore.Metals.COPPER.colored(-3449539), Ore.Metals.GOLD.colored(-1319354));
            minerals.suffixOre().addOre("calcite_redstone", Ore.Minerals.REDSTONE.colored(-11403007), "*").withPrefixes(prefixes).addOre(Ore.COAL.colored(-14540254)).withMetaAll().addOre(Ore.Minerals.REDSTONE.colored(-11403007));
        }
    }

    static class Electrodynamics
    implements Initializer {
        Electrodynamics() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] prefixes = new String[]{"ore", "deepslateore"};
            gems.withNoDelimiters().withPrefixes(prefixes).addOres(Ore.Gems.FLUORITE.colored(-12721458), Ore.Gems.LEPIDOLITE.colored(-9028249));
            metals.withNoDelimiters().withPrefixes(prefixes).addOres(Ore.Metals.ALUMINUM.colored(-3569270), Ore.Metals.CHROMIUM.colored(-10983053), Ore.Metals.LEAD.colored(-9868920), Ore.Metals.LITHIUM.colored(-6797452), Ore.Metals.MOLYBDENUM.colored(-11116202), Ore.Metals.MONAZITE.colored(-8898767), Ore.Metals.RUTILE.colored(-12307932), Ore.Metals.SILVER.colored(-8151390), Ore.Metals.TIN.colored(-9006435), Ore.Metals.TITANIUM.colored(-12762554), Ore.Metals.THORIUM.colored(-13750738), Ore.Metals.URANIUM.colored(-6507640), Ore.Metals.VANADIUM.colored(-7529190));
            minerals.withNoDelimiters().withPrefixes(prefixes).addOres(Ore.Minerals.HALITE.colored(-1907998), Ore.Minerals.NITER.colored(-4737097), Ore.Minerals.SALT.colored(-1184275), Ore.Minerals.SULFUR.colored(-7828224), Ore.Minerals.SYLVITE.colored(-7584472));
        }
    }

    static class YTech
    implements Initializer {
        YTech() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.suffixOre().withPrefixes("nether").addOres(Ore.Metals.IRON.colored(-3562615), Ore.Metals.COPPER.colored(-3052728)).withPrefixes("", "deepslate", "nether").addOres(Ore.Metals.CASSITERITE.colored(-3309788), Ore.Metals.GALENA.colored(-6444861));
        }
    }

    static class Meadow
    implements Initializer {
        Meadow() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] prefixes = new String[]{"alpine"};
            gems.withPrefixes(prefixes).suffixOre().addOres(Ore.Gems.DIAMOND.colored(-12721947), Ore.Gems.EMERALD.colored(-16209361), Ore.Gems.LAPIS.colored(-16776961), Ore.Gems.QUARTZ.colored(-790298));
            metals.withPrefixes(prefixes).suffixOre().addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.COPPER.colored(-3840700), Ore.Metals.GOLD.colored(-10496));
            minerals.withPrefixes(prefixes).suffixOre().addOres(Ore.COAL, Ore.Minerals.REDSTONE.colored(-4717564), Ore.Minerals.SALT.colored(-1184275));
        }
    }

    static class DeepDarkRegrowth
    implements Initializer {
        DeepDarkRegrowth() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] prefixes = new String[]{"grimstone"};
            gems.withPrefixes(prefixes).suffixOre().addOre("lapislazuli", Ore.Gems.LAPIS.colored(-12621875)).addOres(Ore.Gems.DIAMOND.colored(-12721947), Ore.Gems.EMERALD.colored(-16209361));
            metals.withPrefixes(prefixes).suffixOre().addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.COPPER.colored(-3840700), Ore.Metals.GOLD.colored(-10496));
            minerals.withPrefixes(prefixes).suffixOre().addOres(Ore.COAL).withMetaAll().addOres(Ore.Minerals.REDSTONE.colored(-4717564));
        }
    }

    static class DeeperDarker
    implements Initializer {
        DeeperDarker() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] prefixes = new String[]{"sculk_stone", "gloomslate"};
            gems.withPrefixes(prefixes).suffixOre().addOres(Ore.Gems.DIAMOND.colored(-12721947), Ore.Gems.EMERALD.colored(-16209361), Ore.Gems.LAPIS.colored(-12621875));
            metals.withPrefixes(prefixes).suffixOre().addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.COPPER.colored(-3840700), Ore.Metals.GOLD.colored(-10496));
            minerals.withPrefixes(prefixes).suffixOre().addOres(Ore.COAL.colored(-13948117)).withMetaAll().addOres(Ore.Minerals.REDSTONE.colored(-4717564));
        }
    }

    static class CrystalcraftUnlimited
    implements Initializer {
        CrystalcraftUnlimited() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.addOres(Ore.Gems.METEORITE.colored(-1199360), Ore.of("peacock_ore_block", -16732435), Ore.of("neon", -6749971)).suffixOre().addOre("rose_quartz", Ore.Gems.QUARTZ.colored(-1934099)).addOre("smoky_quartz", Ore.Gems.QUARTZ.colored(-6983088)).addOre("medusa_quartz", Ore.Gems.QUARTZ.colored(-13587529)).addOre("fire_opal", Ore.Gems.OPAL.colored(-1224141)).addOre("rare_tanzanite", Ore.Gems.TANZANITE.colored(-15482368)).addOre("sunset_jasper", Ore.Gems.JASPER.colored(-15482368)).addOre("rare_sapphire", Ore.Gems.SAPPHIRE.colored(-14050067)).addOre("green_catseye", Ore.Gems.CATSEYE.colored(-14508796)).addOre("white_diamond", Ore.Gems.DIAMOND.colored(-3744020)).addOre("pink_diamond", Ore.Gems.DIAMOND.colored(-1202222)).addOre("purple_diamond", Ore.Gems.DIAMOND.colored(-4764947)).addOre("red_diamond", Ore.Gems.DIAMOND.colored(-1245184)).addOre("orange_diamond", Ore.Gems.DIAMOND.colored(-1480680)).addOre("raspberry_diamond", Ore.Gems.DIAMOND.colored(-1227618)).addOre("rare_citrine", Ore.Gems.CITRINE.colored(-1209856)).addOre("rare_amethyst", Ore.Gems.AMETHYST.colored(-5672478)).addOre("cyan_emerald", Ore.Gems.EMERALD.colored(-12721494)).addOre("pink_ruby", Ore.Gems.RUBY.colored(-1245105)).addOre("saphire", Ore.Gems.SAPPHIRE.colored(-13187899)).addOre("sapphire", Ore.Gems.SAPPHIRE.colored(-16765715)).addOre("deepslate_saphire", Ore.Gems.SAPPHIRE.colored(-16765715)).addOre("deepslate_sapphire", Ore.Gems.SAPPHIRE.colored(-13187899)).addOre("rare_deepslate_sapphire", Ore.Gems.SAPPHIRE.colored(-12475157)).addOre("australian_sapphire", Ore.Gems.SAPPHIRE.colored(-10708015)).addOre("iris_agate", Ore.Gems.AGATE.colored(-3956736)).addOre("yellow_onyx", Ore.Gems.ONYX.colored(-1193728)).addOre("deepslate_ametyst", Ore.Gems.AMETHYST.colored(-5766931)).addOre("deepslate_grand", Ore.Gems.GRANDIDIERITE.colored(-10949173)).addOres(Ore.of("indigolite", -13644892), Ore.of("obsidian", -9238593), Ore.of("watermelon_tourmaline", -10903211), Ore.of("chloronium", -6239488), Ore.of("peacock_topaz", -16732435), Ore.of("hackmantite", -3453715), Ore.of("cyber_crystal", -8596263), Ore.of("bluestone", -16747028), Ore.of("sonoranite", -12088563), Ore.of("matrix", -16747283), Ore.of("hercynite", -16777216), Ore.of("brickerite", -1207296), Ore.of("zircon", -1212341), Ore.of("pitambari_neelam", -5057725)).prefixNoneAndDeepslate().addOre("black_opal", Ore.Gems.OPAL.colored(-12815763)).addOres(Ore.of("sugillite", -11587717), Ore.of("flourite", -4706385), Ore.Gems.GARNET.colored(-6025187), Ore.Gems.SAPPHIRE.colored(-12721947), Ore.Gems.RUBY.colored(-1245184), Ore.Gems.TOPAZ.colored(-1868544), Ore.Gems.PERIDOT.colored(-16720366), Ore.Gems.SPINEL.colored(-1230878), Ore.Gems.TOURMALINE.colored(-7828224), Ore.Gems.AMAZONITE.colored(-16728430), Ore.Gems.ALEXANDRITE.colored(-13262989), Ore.Gems.OPAL.colored(-13119801), Ore.Gems.JASPER.colored(-1219072), Ore.Gems.JADE.colored(-14714107), Ore.Gems.SARDONYX.colored(-1219072), Ore.Gems.AZURITE.colored(-16733765), Ore.Gems.MALACHITE.colored(-13001613), Ore.Gems.FLUORITE.colored(-4706385), Ore.Gems.AQUAMARINE.colored(-13259796), Ore.Gems.KUNZITE.colored(-1245009), Ore.Gems.CITRINE.colored(-1584640), Ore.Gems.TANZANITE.colored(-13222163), Ore.Gems.CHRYSOLITE.colored(-5837568), Ore.Gems.IOLITE.colored(-11050565), Ore.Gems.AMETRINE.colored(-1214435), Ore.Gems.MOONSTONE.colored(-16729417), Ore.Gems.AMBER.colored(-1213440), Ore.Gems.PRISM.colored(-11869173), Ore.Gems.AMETHYST.colored(-5766931), Ore.Gems.ONYX.colored(-15329770), Ore.Gems.TURQUOISE.colored(-16460870), Ore.Gems.AMMOLITE.colored(-7934850), Ore.Gems.RUTILE.colored(-3127738), Ore.Gems.FLUORITE.colored(-7541282), Ore.Gems.CATSEYE.colored(-2291763), Ore.Gems.VESUVIANITE.colored(-13512415), Ore.Gems.GOSHENITE.colored(-3289651), Ore.Gems.BIXBITE.colored(-1245091), Ore.Gems.SUNSTONE.colored(-6004146), Ore.Gems.BLOODSTONE.colored(-4177856), Ore.Gems.SERPENTINE.colored(-5837568), Ore.Gems.LARIMAR.colored(-10505292), Ore.Gems.PYRITE.colored(-4088558), Ore.Gems.CHALCANTHITE.colored(-12289830), Ore.Gems.LABRADORITE.colored(-16757900), Ore.Gems.RHODONITE.colored(-5626784), Ore.Gems.OLIVINE.colored(-9257472), Ore.Gems.GRANDIDIERITE.colored(-10949173));
            metals.addOre("deepslate_rhodium_block", Ore.Metals.RHODIUM.colored(-5098140)).suffixOre().addOres(Ore.of("enderium", -13075368), Ore.of("humoranium", -1264640), Ore.of("anti_humoranium", -9043770), Ore.of("yurium", -10375274), Ore.of("xernium", -3014547), Ore.of("pelenium", -3401107), Ore.of("maradonyx", -9061657), Ore.of("palintinium", -2000617), Ore.of("silicium", -8423535), Ore.of("americium", -10075838), Ore.of("scandium", -8029090), Ore.of("yttrium", -8032194), Ore.of("seaborgium", -1184512), Ore.of("pottasium", -3943206), Ore.of("holmium", -11897499)).prefixNoneAndDeepslate().addOres(Ore.of("matizium", -8952137), Ore.Metals.TITANIUM.colored(-11906674), Ore.Metals.URANIUM.colored(-16731379), Ore.Metals.BRONZE.colored(-5343993), Ore.Metals.SILVER.colored(-2567727), Ore.Metals.PLATINUM.colored(-6772541), Ore.Metals.COBALT.colored(-12289400), Ore.Metals.TIN.colored(-8490139), Ore.Metals.ALUMINIUM.colored(-2369063), Ore.Metals.IRIDIUM.colored(-5011271), Ore.Metals.NICKEL.colored(-3960945), Ore.Metals.ZINC.colored(-8345177), Ore.Metals.LEAD.colored(-13092808), Ore.Metals.TUNGSTEN.colored(-6763644), Ore.Metals.CHROME.colored(-10134636), Ore.Metals.MAGNESIUM.colored(-3897979), Ore.Metals.BISMUTH.colored(-11447992), Ore.Metals.PALLADIUM.colored(-5484494), Ore.Metals.STIBNITE.colored(-13882324), Ore.Metals.LITHIUM.colored(-8941167), Ore.Metals.THORIUM.colored(-7779779), Ore.Metals.INDIUM.colored(-3819314), Ore.Metals.VANADIUM.colored(-5943712), Ore.Metals.MANGANESE.colored(-3443870), Ore.Metals.ZIRCONIUM.colored(-2244465), Ore.Metals.NIOBIUM.colored(-2272289), Ore.Metals.MOLYBDENUM.colored(-11573623), Ore.Metals.TECHNETIUM.colored(-6439485), Ore.Metals.RUTHENIUM.colored(-8019167), Ore.Metals.RHODIUM.colored(-5098140), Ore.Metals.CADMIUM.colored(-7689057), Ore.Metals.TANTALUM.colored(-9611176), Ore.Metals.OSMIUM.colored(-11048331), Ore.Metals.ORICHALCUM.colored(-1228137), Ore.Metals.EUROPIUM.colored(-1200829));
            minerals.suffixOre().addOres(Ore.of("quicksilver", -2960686), Ore.Minerals.CINNABAR.colored(-8050134), Ore.Minerals.SULFUR.colored(-4151552));
        }
    }

    static class Railcraft
    implements Initializer {
        Railcraft() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOre("firestone", -3323637);
            metals.prefixNoneAndDeepslate().suffixOre().addOres(Ore.Metals.LEAD.colored(-12568224), Ore.Metals.NICKEL.colored(-4280989), Ore.Metals.SILVER.colored(-2765135), Ore.Metals.TIN.colored(-2171172), Ore.Metals.ZINC.colored(-6838805));
            minerals.prefixNoneAndDeepslate().suffixOre().addOres(Ore.Minerals.SULFUR.colored(-991406), Ore.Minerals.SALTPETER.colored(-3092273));
        }
    }
}

