/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.init;

import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.mods.adfinders.finder.Definitions;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.Lazy;

public enum FinderType implements IForgeEnum
{
    GEM((Finder.Properties)((Finder.Properties)((Object)((Finder.Properties)((Object)((Finder.Properties)((Object)Finder.Properties.of("gem_finder").scanRadius(6))).pingDepth(32))).veinMinSize(1))).depositMinSize(16).nameColor(ChatFormatting.DARK_AQUA)),
    METAL((Finder.Properties)((Finder.Properties)((Object)((Finder.Properties)((Object)((Finder.Properties)((Object)Finder.Properties.of("metal_finder").scanRadius(8))).pingDepth(48))).veinMinSize(1))).depositMinSize(24).nameColor(ChatFormatting.GOLD)),
    MINERAL((Finder.Properties)((Finder.Properties)((Object)((Finder.Properties)((Object)((Finder.Properties)((Object)Finder.Properties.of("mineral_finder").scanRadius(7))).pingDepth(40))).veinMinSize(1))).depositMinSize(32).nameColor(ChatFormatting.DARK_PURPLE));

    public final Lazy<Finder> finder;
    public final Lazy<Definitions> definitions;
    public final Finder.Properties<?> props;
    public ForgeConfigSpec.ConfigValue<Integer> scanRadius;
    public ForgeConfigSpec.ConfigValue<Integer> pingDepth;
    public ForgeConfigSpec.ConfigValue<Integer> veinMinSize;
    public ForgeConfigSpec.ConfigValue<Integer> depositMinSize;
    public ForgeConfigSpec.ConfigValue<Integer> durability;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> allowedTargets;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> forbiddenTargets;
    public ForgeConfigSpec.ConfigValue<ChatFormatting> nameColor;
    public ForgeConfigSpec.ConfigValue<Double> needleWidth;
    public ForgeConfigSpec.ConfigValue<Double> needleLength;
    public ForgeConfigSpec.ConfigValue<Double> arrowSize;
    public ForgeConfigSpec.ConfigValue<Boolean> drawOutline;

    private FinderType(Finder.Properties<?> props) {
        this.props = (Finder.Properties)((Finder.Properties)props.durability(4)).equippable(EquipmentSlot.HEAD, SoundEvents.ARMOR_EQUIP_IRON, false);
        this.finder = Lazy.of(() -> new Finder(this, props));
        this.definitions = Lazy.of(() -> new Definitions(this.getRegistryName()));
    }

    public final String getCategoryName() {
        return CommonString.capitalizeFirstChar((String)this.getName());
    }

    public final String getRegistryName() {
        return this.props.name;
    }
}

