/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adfinders.finder.Indicator;
import com.endertech.minecraft.mods.adfinders.finder.TargetLocation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class Needle
extends Indicator {
    public static final float OFFSET = 0.001f;
    public static final Comparator<Needle> SORTING_COMPARATOR = (t1, t2) -> t1.equals(t2) ? 0 : -Double.compare(t1.getTargetLocation().distance, t2.getTargetLocation().distance);

    public Needle(ColorARGB color, TargetLocation location) {
        super(color, location);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(VertexConsumer consumer, PoseStack.Pose pose, CommonMath.Angle angle, float length, float width, boolean outline) {
        pose.rotate((Quaternionfc)new Quaternionf().rotateZ((float)angle.getRadians()));
        FloatBounds x = FloatBounds.between((Float)Float.valueOf(-width / 2.0f), (Float)Float.valueOf(width / 2.0f));
        FloatBounds y = FloatBounds.between((Float)Float.valueOf(-length / 5.0f), (Float)Float.valueOf(length));
        this.fill(consumer, pose, x.getMin().floatValue(), y.getMin().floatValue(), x.getMax().floatValue(), y.getMax().floatValue(), this.getColor());
        if (outline) {
            this.outline(consumer, pose, x.getMin().floatValue(), y.getMin().floatValue(), x.getMax().floatValue(), y.getMax().floatValue(), this.getOutlineColor(), Math.min(length, width) / 15.0f);
        }
    }

    public CommonMath.Angle getAngle(Vect3d startPos, float rotationYaw) {
        Vect3d targetPos = GameWorld.getBlockCenter((BlockPos)this.getTargetLocation().position);
        Vect3d delta = startPos.subtract(targetPos);
        return CommonMath.Angle.fromDegrees((double)(rotationYaw - 90.0f - GameMath.arcTan((double)delta.z, (double)delta.x)));
    }
}

