/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.mods.adfinders.finder.FinderState;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ItemModelState
implements SelectItemModelProperty<State> {
    public static final Codec<State> VALUE_CODEC = StringRepresentable.fromValues(State::values);
    public static final SelectItemModelProperty.Type<ItemModelState, State> TYPE = SelectItemModelProperty.Type.create((MapCodec)MapCodec.unit((Object)new ItemModelState()), VALUE_CODEC);

    @Nullable
    public State get(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed, ItemDisplayContext displayContext) {
        if (ForgeItem.isBroken((ItemStack)stack)) {
            return State.BROKEN;
        }
        boolean depositFound = Finder.findStateFor(stack).map(FinderState::isDepositFound).orElse(false);
        if (depositFound) {
            return State.ALARMED;
        }
        return null;
    }

    public Codec<State> valueCodec() {
        return VALUE_CODEC;
    }

    public SelectItemModelProperty.Type<? extends SelectItemModelProperty<State>, State> type() {
        return TYPE;
    }

    public static enum State implements IForgeEnum
    {
        ALARMED,
        BROKEN;

    }
}

