/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonTime;
import com.endertech.common.IBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldBounds;
import com.endertech.minecraft.mods.adfinders.AdFinders;
import com.endertech.minecraft.mods.adfinders.finder.Arrows;
import com.endertech.minecraft.mods.adfinders.finder.Needle;
import com.endertech.minecraft.mods.adfinders.finder.Target;
import com.endertech.minecraft.mods.adfinders.finder.TargetLocation;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class FinderState {
    private final Finder finder;
    private Entity carrier;
    private CommonTime.Stamp lastUpdate;
    private BlockPos lastPosition;
    private boolean depositFound;
    private Future<?> searcher;
    private Map<Arrows, Arrows.Arrow> arrows = Collections.emptyMap();
    private List<Needle> needles = Collections.emptyList();

    public FinderState(Finder finder, Entity carrier) {
        this.finder = finder;
        this.carrier = carrier;
    }

    protected Optional<CommonTime.Stamp> getLastUpdate() {
        return Optional.ofNullable(this.lastUpdate);
    }

    protected Optional<BlockPos> getLastPos() {
        return Optional.ofNullable(this.lastPosition);
    }

    public Entity getCarrier() {
        return this.carrier;
    }

    public int getNeedlesCount() {
        return this.needles.size();
    }

    public int getTargetsCount() {
        return this.getNeedlesCount() + this.arrows.size();
    }

    public List<Needle> getNeedles() {
        return Collections.unmodifiableList(this.needles);
    }

    public Map<Arrows, Arrows.Arrow> getArrows() {
        return Collections.unmodifiableMap(this.arrows);
    }

    public boolean isDepositFound() {
        return this.depositFound;
    }

    public boolean isActual() {
        return this.getLastUpdate().map(update -> CommonTime.Interval.passedFrom((CommonTime.Stamp)update).lessThan(Finder.STATE_TTL)).orElse(true);
    }

    public boolean needsUpdate() {
        boolean isUpdateTime = this.getLastUpdate().map(update -> CommonTime.Interval.passedFrom((CommonTime.Stamp)update).moreThan(Finder.UPDATE_INTERVAL)).orElse(true);
        boolean entityMoved = this.getLastPos().map(pos -> !this.getCarrier().blockPosition().equals(pos)).orElse(true);
        return isUpdateTime || entityMoved;
    }

    public void update(Entity carrier) {
        this.setCarrier(carrier);
        if (this.searcher == null || this.searcher.isDone()) {
            this.searcher = AdFinders.getInstance().executors.submit(new Searcher());
        }
        this.lastPosition = this.getCarrier().blockPosition();
        this.lastUpdate = CommonTime.Stamp.now();
    }

    public Finder getFinder() {
        return this.finder;
    }

    protected void setCarrier(Entity carrier) {
        this.carrier = carrier;
    }

    protected class Searcher
    implements Runnable {
        private final Map<TargetLocation, Target> foundTargets = new ConcurrentHashMap<TargetLocation, Target>();

        protected Searcher() {
        }

        public IntBounds getStartY() {
            int height = (int)FinderState.this.getCarrier().getBbHeight();
            if ((float)height == FinderState.this.getCarrier().getBbHeight()) {
                --height;
            }
            int minY = FinderState.this.getCarrier().blockPosition().getY();
            int maxY = minY + height;
            return new IntBounds(Integer.valueOf(minY), Integer.valueOf(maxY));
        }

        public int getStartX() {
            return Mth.floor((double)FinderState.this.getCarrier().getX());
        }

        public int getStartZ() {
            return Mth.floor((double)FinderState.this.getCarrier().getZ());
        }

        public Level getLevel() {
            return FinderState.this.getCarrier().level();
        }

        @Override
        public void run() {
            this.searchVeins();
            this.searchTargetsAround();
            this.searchDeposit();
        }

        private void searchVeins() {
            EnumMap<Arrows, Arrows.Arrow> updatedArrows = new EnumMap<Arrows, Arrows.Arrow>(Arrows.class);
            Finder finder = FinderState.this.getFinder();
            IntBounds pingBounds = this.getStartY().extend(Integer.valueOf(finder.getPingDepth()));
            IntBounds boundsY = pingBounds.fit((IBounds)WorldBounds.getHeightBounds((LevelHeightAccessor)this.getLevel()));
            block0: for (Arrows arrow : Arrows.values()) {
                int startY;
                BlockState lastState = Blocks.AIR.defaultBlockState();
                int y = startY = (arrow == Arrows.OVERHEAD ? this.getStartY().getMax() : this.getStartY().getMin()).intValue();
                while (boundsY.encloses(Integer.valueOf(y))) {
                    int veinSize = 0;
                    Target foundTarget = null;
                    BlockPos pos = new BlockPos(this.getStartX(), y, this.getStartZ());
                    BlockState state = this.getLevel().getBlockState(pos);
                    if (state != lastState && !state.isAir() && finder.isAllowedTarget(state)) {
                        lastState = state;
                        for (Target target : FinderState.this.getFinder().getAllTargets()) {
                            if (!target.matches(state)) continue;
                            ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
                            veinSize = this.countNeighbours(target, pos, finder.getVeinMinSize(), posList);
                            if (veinSize < finder.getVeinMinSize()) continue;
                            foundTarget = target;
                            break;
                        }
                    }
                    if (foundTarget != null) {
                        int distance = Math.abs(y - startY);
                        TargetLocation location = TargetLocation.of(pos, distance);
                        updatedArrows.put(arrow, arrow.create(foundTarget.getColor(), location));
                        this.foundTargets.put(location, foundTarget);
                        continue block0;
                    }
                    y += arrow.step;
                }
            }
            FinderState.this.arrows = updatedArrows;
        }

        private void searchTargetsAround() {
            ArrayList<Needle> updatedNeedles = new ArrayList<Needle>();
            Finder finder = FinderState.this.getFinder();
            Vect3d finderPos = ForgeEntity.getCenterPosition((Entity)FinderState.this.getCarrier());
            IntBounds scanVertBounds = this.getStartY().extend(Integer.valueOf(2));
            IntBounds rangeY = scanVertBounds.fit((IBounds)WorldBounds.getHeightBounds((LevelHeightAccessor)this.getLevel()));
            IntBounds rangeX = new IntBounds(Integer.valueOf(this.getStartX())).extend(Integer.valueOf(finder.getScanRadius()));
            IntBounds rangeZ = new IntBounds(Integer.valueOf(this.getStartZ())).extend(Integer.valueOf(finder.getScanRadius()));
            for (List<Target> group : FinderState.this.getFinder().getTargetGroups().values()) {
                Target nearestTarget = null;
                BlockPos nearestPos = null;
                double minDistance = Double.MAX_VALUE;
                for (int y = rangeY.getMin().intValue(); y <= rangeY.getMax(); ++y) {
                    for (int z = rangeZ.getMin().intValue(); z <= rangeZ.getMax(); ++z) {
                        for (int x = rangeX.getMin().intValue(); x <= rangeX.getMax(); ++x) {
                            BlockPos pos = new BlockPos(x, y, z);
                            BlockState state = this.getLevel().getBlockState(pos);
                            if (!finder.isAllowedTarget(state)) continue;
                            for (Target target : group) {
                                int veinSize;
                                double lastDistance;
                                if (!target.matches(state) || !((lastDistance = finderPos.distance(GameWorld.getBlockCenter((BlockPos)pos))) < minDistance) || (veinSize = this.countNeighbours(target, pos, finder.getVeinMinSize(), new ArrayList<BlockPos>())) < finder.getVeinMinSize()) continue;
                                nearestPos = pos;
                                nearestTarget = target;
                                minDistance = lastDistance;
                            }
                        }
                    }
                }
                if (nearestTarget == null || nearestPos == null) continue;
                TargetLocation location = TargetLocation.of(nearestPos, minDistance);
                updatedNeedles.add(new Needle(nearestTarget.getColor(), location));
                this.foundTargets.put(location, nearestTarget);
            }
            updatedNeedles.sort(Needle.SORTING_COMPARATOR);
            FinderState.this.needles = updatedNeedles;
        }

        private void searchDeposit() {
            int minSize = FinderState.this.getFinder().getDepositMinSize();
            for (Map.Entry<TargetLocation, Target> entry : this.foundTargets.entrySet()) {
                ArrayList<BlockPos> posList;
                BlockPos pos;
                Target target = entry.getValue();
                int size = this.countNeighbours(target, pos = entry.getKey().position, minSize, posList = new ArrayList<BlockPos>());
                if (size < minSize) continue;
                FinderState.this.depositFound = true;
                return;
            }
            FinderState.this.depositFound = false;
        }

        private int countNeighbours(Target target, BlockPos startPos, int maxNeighbours, List<BlockPos> foundList) {
            int count = 1;
            foundList.add(startPos);
            for (Direction facing : Direction.values()) {
                if (count >= maxNeighbours) break;
                BlockPos pos = startPos.relative(facing);
                if (!target.matches(this.getLevel().getBlockState(pos)) || foundList.contains(pos)) continue;
                count += this.countNeighbours(target, pos, maxNeighbours - count, foundList);
            }
            return count;
        }
    }

    public static class UpdateMsg
    extends ForgeNetMsg<UpdateMsg> {
        public int livingId;
        public EquipmentSlot slot;

        public UpdateMsg() {
        }

        public UpdateMsg(LivingEntity living, EquipmentSlot slot) {
            this.livingId = living.getId();
            this.slot = slot;
        }

        public UpdateMsg create() {
            return new UpdateMsg();
        }

        public void sendToServer() {
            AdFinders.getInstance().getConnection().sendToServer((Object)this);
        }

        protected void sendToAllAround(Entity entity) {
            Level level = entity.level();
            if (level instanceof ServerLevelAccessor) {
                AdFinders.getInstance().getConnection().sendToAllAround((Object)this, (ServerLevelAccessor)level, entity.blockPosition(), Finder.SEARCH_BOUNDS.getMax().intValue());
            }
        }

        public void handle(Level level, Player player) {
            Entity entity = level.getEntity(this.livingId);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                ItemStack stack = living.getItemBySlot(this.slot);
                Finder.getFinderItem(stack).ifPresent(finder -> {
                    if (GameWorld.isServerSide((LevelReader)level)) {
                        this.sendToAllAround((Entity)living);
                    } else {
                        finder.updateState(stack, (Entity)living);
                    }
                });
            }
        }
    }
}

