/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.mods.adfinders.finder.Indicator;
import com.endertech.minecraft.mods.adfinders.finder.TargetLocation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public enum Arrows {
    OVERHEAD(0.0, 1),
    UNDERFOOT(180.0, -1);

    private final CommonMath.Angle angle;
    public final int step;

    private Arrows(double degrees, int step) {
        this.angle = CommonMath.Angle.fromDegrees((double)degrees);
        this.step = step;
    }

    public Arrow create(ColorARGB color, TargetLocation location) {
        return new Arrow(color, location, this.angle);
    }

    static class Arrow
    extends Indicator {
        private final CommonMath.Angle angle;

        public Arrow(ColorARGB color, TargetLocation location, CommonMath.Angle angle) {
            super(color, location);
            this.angle = angle;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void draw(VertexConsumer consumer, PoseStack.Pose pose, float size, boolean outline) {
            pose.rotate((Quaternionfc)new Quaternionf().rotateZ((float)this.angle.getRadians()));
            FloatBounds x = FloatBounds.between((Float)Float.valueOf(-size), (Float)Float.valueOf(size));
            FloatBounds y = FloatBounds.between((Float)Float.valueOf(size / 2.0f), (Float)Float.valueOf(size));
            this.fill(consumer, pose, x.getMin().floatValue(), y.getMin().floatValue(), x.getMax().floatValue(), y.getMax().floatValue(), this.getColor());
            if (outline) {
                this.outline(consumer, pose, x.getMin().floatValue(), y.getMin().floatValue(), x.getMax().floatValue(), y.getMax().floatValue(), this.getOutlineColor(), size / 30.0f);
            }
        }

        @Override
        protected void fill(VertexConsumer consumer, PoseStack.Pose pose, float minX, float minY, float maxX, float maxY, ColorARGB color) {
            this.addVertex(consumer, pose, 0.0f, maxY, 0.5f, 0.0f, color);
            this.addVertex(consumer, pose, minX, minY, 0.0f, 1.0f, color);
            this.addVertex(consumer, pose, maxX, minY, 1.0f, 1.0f, color);
            this.addVertex(consumer, pose, maxX, minY, 1.0f, 1.0f, color);
        }

        @Override
        protected void outline(VertexConsumer consumer, PoseStack.Pose pose, float minX, float minY, float maxX, float maxY, ColorARGB color, float thickness) {
            super.fill(consumer, pose, minX - thickness, minY - thickness, maxX + thickness, minY, color);
            this.fill(consumer, pose, minX - thickness, minY, minX, maxY, color);
            this.fill(consumer, pose, maxX, minY, maxX + thickness, maxY, color);
        }
    }
}

