/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class DimensionId {
    protected final ResourceKey<Level> key;

    protected DimensionId(ResourceKey<Level> registryKey) {
        this.key = registryKey;
    }

    public static DimensionId from(ResourceKey<Level> registryKey) {
        return new DimensionId(registryKey);
    }

    public static DimensionId from(Level level) {
        return new DimensionId((ResourceKey<Level>)level.dimension());
    }

    public static DimensionId from(Identifier identifier) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (Identifier)identifier);
        return new DimensionId((ResourceKey<Level>)key);
    }

    public boolean belongsTo(Level level) {
        return this.getKey().equals((Object)level.dimension());
    }

    public ResourceKey<Level> getKey() {
        return this.key;
    }

    public Identifier toIdentifier() {
        return this.getKey().identifier();
    }

    public String toString() {
        return this.toIdentifier().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DimensionId) {
            return Objects.equals(this.getKey(), ((DimensionId)obj).getKey());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getKey());
    }
}

