/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepaintableBlockModel
implements BlockStateModel {
    public static final ModelProperty<BlockState> BLOCK_STATE = new ModelProperty();
    protected final BlockStateModel originalModel;
    protected final Map<BlockState, List<BlockModelPart>> retexturedModels = new ConcurrentHashMap<BlockState, List<BlockModelPart>>();

    public RepaintableBlockModel(BlockStateModel originalModel) {
        this.originalModel = originalModel;
    }

    public void collectParts(RandomSource randomSource, List<BlockModelPart> blockModelParts) {
        this.originalModel.collectParts(randomSource, blockModelParts);
    }

    public void collectParts(RandomSource randomSource, List<BlockModelPart> blockModelParts, ModelData modelData, @Nullable ChunkSectionLayer renderType) {
        BlockState targetBlock = this.getTargetBlock(modelData).orElse(null);
        BlockStateModel targetModel = this.getTargetModel(targetBlock);
        if (targetBlock == null || targetModel == this || targetBlock.isAir()) {
            this.originalModel.collectParts(randomSource, blockModelParts, modelData, renderType);
            return;
        }
        List retexturedParts = this.retexturedModels.computeIfAbsent(targetBlock, key -> {
            TextureAtlasSprite oldTexture = this.originalModel.particleIcon(ModelData.EMPTY);
            TextureAtlasSprite newTexture = this.getMainTextureSprite(targetModel, targetBlock, randomSource, renderType);
            TextureAtlasSprite particleIcon = targetModel.particleIcon(ModelData.EMPTY);
            float scale = (float)this.getMinSize(particleIcon) / (float)this.getMinSize(newTexture);
            ObjectArrayList originalParts = new ObjectArrayList();
            this.originalModel.collectParts(randomSource, (List)originalParts, modelData, renderType);
            return originalParts.stream().map(part -> this.retextureModelPart((BlockModelPart)part, scale, oldTexture, newTexture)).toList();
        });
        blockModelParts.addAll(retexturedParts);
    }

    public TextureAtlasSprite particleIcon() {
        return this.originalModel.particleIcon();
    }

    public TextureAtlasSprite particleIcon(@NotNull ModelData data) {
        if (data == null) {
            data = ModelData.EMPTY;
        }
        return this.getTargetBlock(data).map(this.retexturedModels::get).filter(list -> !list.isEmpty()).map(List::getFirst).map(BlockModelPart::particleIcon).orElseGet(this::particleIcon);
    }

    protected BlockStateModel getTargetModel(BlockState state) {
        return Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(state);
    }

    protected Optional<BlockState> getTargetBlock(ModelData data) {
        return data.has(BLOCK_STATE) ? Optional.ofNullable((BlockState)data.get(BLOCK_STATE)) : Optional.empty();
    }

    protected int getMinSize(TextureAtlasSprite sprite) {
        int min = Math.min(sprite.contents().width(), sprite.contents().height());
        return Math.max(min, 1);
    }

    protected TextureAtlasSprite getMainTextureSprite(BlockStateModel model, BlockState state, RandomSource rand, @Nullable ChunkSectionLayer renderType) {
        TextureAtlasSprite mainSprite = model.particleIcon(ModelData.EMPTY);
        if (model instanceof RepaintableBlockModel) {
            return mainSprite;
        }
        HashSet allSprites = new HashSet();
        HashMap culledSprites = new HashMap();
        Direction[] directions = Direction.values();
        List modelParts = model.collectParts(rand, ModelData.EMPTY, renderType);
        for (Direction side : directions) {
            Set sprites = modelParts.stream().flatMap(p -> p.getQuads(side).stream()).map(BakedQuad::sprite).collect(Collectors.toSet());
            culledSprites.put(side, sprites);
            allSprites.addAll(sprites);
        }
        if (state.is(Blocks.GRASS_BLOCK)) {
            return Optional.ofNullable((Set)culledSprites.get(Direction.DOWN)).flatMap(set -> set.stream().findFirst()).orElse(mainSprite);
        }
        int maxCount = 0;
        for (TextureAtlasSprite sprite : allSprites) {
            int count = 0;
            for (Direction side : directions) {
                if (!((Set)culledSprites.get(side)).contains(sprite)) continue;
                ++count;
            }
            if (count <= maxCount) continue;
            mainSprite = sprite;
            maxCount = count;
        }
        return mainSprite;
    }

    protected BlockModelPart retextureModelPart(BlockModelPart originalPart, float scale, TextureAtlasSprite oldTexture, TextureAtlasSprite newTexture) {
        QuadCollection.Builder builder = new QuadCollection.Builder();
        originalPart.getQuads(null).stream().map(quad -> this.retextureQuad((BakedQuad)quad, oldTexture, newTexture, scale)).forEach(arg_0 -> ((QuadCollection.Builder)builder).addUnculledFace(arg_0));
        for (Direction direction : Direction.values()) {
            originalPart.getQuads(direction).stream().map(quad -> this.retextureQuad((BakedQuad)quad, oldTexture, newTexture, scale)).forEach(quad -> builder.addCulledFace(direction, quad));
        }
        return new SimpleModelWrapper(builder.build(), originalPart.useAmbientOcclusion(), originalPart.particleIcon());
    }

    protected BakedQuad retextureQuad(BakedQuad quad, TextureAtlasSprite oldSprite, TextureAtlasSprite newSprite, float scale) {
        if (!oldSprite.equals(newSprite) && quad.sprite().equals(oldSprite)) {
            long[] uvs = this.updateVertices(this.getUVs(quad), quad.sprite(), newSprite, scale);
            return new BakedQuad(quad.position0(), quad.position1(), quad.position2(), quad.position3(), uvs[0], uvs[1], uvs[2], uvs[3], quad.tintIndex(), quad.direction(), newSprite, quad.shade(), quad.lightEmission(), quad.ambientOcclusion());
        }
        return quad;
    }

    protected long[] getUVs(BakedQuad quad) {
        return new long[]{quad.packedUV0(), quad.packedUV1(), quad.packedUV2(), quad.packedUV3()};
    }

    protected long[] updateVertices(long[] packedUVs, TextureAtlasSprite oldSprite, TextureAtlasSprite newSprite, float scale) {
        long[] updatedUVs = (long[])packedUVs.clone();
        for (int i = 0; i < 4; ++i) {
            float u = this.getUV(UVPair.unpackU((long)packedUVs[i]), oldSprite.getU0(), oldSprite.getU1());
            float v = this.getUV(UVPair.unpackV((long)packedUVs[i]), oldSprite.getV0(), oldSprite.getV1());
            updatedUVs[i] = UVPair.pack((float)newSprite.getU(u * scale), (float)newSprite.getV(v * scale));
        }
        return updatedUVs;
    }

    protected float getUV(float uv, float uv0, float uv1) {
        return (float)((double)(uv - uv0) * 1.0 / (double)(uv1 - uv0));
    }
}

