/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.fluid;

import net.blay09.mods.balm.api.fluid.FluidTank;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public final class NeoForgeFluidTank
implements ResourceHandler<FluidResource> {
    private final FluidTank fluidTank;
    private final FluidJournal fluidJournal = new FluidJournal();

    public NeoForgeFluidTank(FluidTank fluidTank) {
        this.fluidTank = fluidTank;
    }

    public int size() {
        return 1;
    }

    public FluidResource getResource(int i) {
        return i == 0 ? FluidResource.of((Fluid)this.fluidTank.getFluid()) : FluidResource.EMPTY;
    }

    public long getAmountAsLong(int i) {
        return i == 0 ? (long)this.fluidTank.getAmount() : 0L;
    }

    public long getCapacityAsLong(int i, FluidResource fluidResource) {
        return i == 0 ? (long)this.fluidTank.getCapacity() : 0L;
    }

    public boolean isValid(int i, FluidResource fluidResource) {
        return i == 0 && (this.fluidTank.isEmpty() || fluidResource.is((Object)this.fluidTank.getFluid()));
    }

    public int insert(int i, FluidResource fluidResource, int amount, TransactionContext transaction) {
        this.fluidJournal.updateSnapshots(transaction);
        return i == 0 ? this.fluidTank.fill(fluidResource.getFluid(), amount, false) : amount;
    }

    public int extract(int i, FluidResource fluidResource, int amount, TransactionContext transaction) {
        this.fluidJournal.updateSnapshots(transaction);
        return i == 0 ? this.fluidTank.drain(fluidResource.getFluid(), amount, false) : amount;
    }

    private class FluidJournal
    extends SnapshotJournal<FluidStack> {
        private FluidJournal() {
        }

        protected FluidStack createSnapshot() {
            return new FluidStack(NeoForgeFluidTank.this.fluidTank.getFluid(), NeoForgeFluidTank.this.fluidTank.getAmount());
        }

        protected void revertToSnapshot(FluidStack snapshot) {
            NeoForgeFluidTank.this.fluidTank.setFluid(snapshot.getFluid(), snapshot.getAmount());
        }
    }
}

