/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.core.particles.internal;

import java.util.function.Function;
import net.blay09.mods.balm.core.BalmRegistrar;
import net.blay09.mods.balm.core.particles.BalmParticleTypeRegistrar;
import net.blay09.mods.balm.core.particles.BalmParticleTypeRegistration;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractBalmParticleTypeRegistrarImpl
implements BalmParticleTypeRegistrar {
    private final BalmRegistrar registrar;
    private final String namespace;

    public AbstractBalmParticleTypeRegistrarImpl(BalmRegistrar registrar, String namespace) {
        this.registrar = registrar;
        this.namespace = namespace;
    }

    @Override
    public <T extends ParticleOptions> BalmParticleTypeRegistration<T> register(String name, Function<ResourceLocation, ParticleType<T>> constructor) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)name);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.PARTICLE_TYPE, (ResourceLocation)id);
        Holder<ParticleType> holder = this.registrar.register(key, constructor::apply);
        return new BalmParticleTypeRegistrationImpl(holder);
    }

    private static class BalmParticleTypeRegistrationImpl<T extends ParticleOptions>
    implements BalmParticleTypeRegistration<T> {
        private final Holder<ParticleType<T>> holder;

        private BalmParticleTypeRegistrationImpl(Holder<?> holder) {
            this.holder = holder;
        }

        @Override
        public Holder<ParticleType<T>> asHolder() {
            return this.holder;
        }
    }
}

