/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.client.renderer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.blockentity.state.ChestRenderState;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class CustomChestMaterials {
    private static final Map<BlockEntityType<?>, MaterialProvider> materialProviders = new ConcurrentHashMap();

    public static <T extends BlockEntity> void register(BlockEntityType<T> type, Material material) {
        CustomChestMaterials.register(type, (ChestRenderState chestRenderState) -> material);
    }

    public static <T extends BlockEntity> void register(BlockEntityType<T> type, MaterialProvider materialFunction) {
        materialProviders.put(type, materialFunction);
    }

    @Nullable
    public static Material getMaterial(ChestRenderState chestRenderState) {
        MaterialProvider provider = materialProviders.get(chestRenderState.blockEntityType);
        if (provider != null) {
            return provider.getMaterial(chestRenderState);
        }
        return null;
    }

    @FunctionalInterface
    public static interface MaterialProvider {
        public Material getMaterial(ChestRenderState var1);
    }
}

