/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup.screen.customization;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.ItemBaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.PackedUp;
import com.supermartijn642.packedup.packets.PacketSetIcon;
import com.supermartijn642.packedup.screen.customization.BackpackCustomizationScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class IconSelectionScreen
extends ItemBaseWidget {
    public static final Identifier SLOT_HIGHLIGHT_TEXTURE = Identifier.fromNamespaceAndPath((String)"packedup", (String)"gui/slot_highlight");
    public static final Identifier BACKGROUND_TEXTURE = Identifier.fromNamespaceAndPath((String)"packedup", (String)"gui/preview_frame");
    private static final Component TITLE = TextComponents.translation((String)"packedup.icon_selection_screen.icon.title").get();
    private final InteractionHand hand;

    public IconSelectionScreen(InteractionHand hand) {
        super(0, 0, 176, 151, () -> ClientUtils.getPlayer().getItemInHand(hand), s -> !s.isEmpty() && s.getItem() instanceof BackpackItem);
        this.hand = hand;
    }

    public Component getNarrationMessage(ItemStack stack) {
        return TITLE;
    }

    public void renderBackground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, ItemStack stack) {
        graphics.submitSprite(BACKGROUND_TEXTURE, 0.0f, 0.0f, (float)this.width(), (float)this.height());
        IconSelectionScreen.forEachSlot((x, y, index) -> {
            if (mouseX >= x && mouseX < x + 18 && mouseY >= y && mouseY < y + 18) {
                graphics.submitSprite(SLOT_HIGHLIGHT_TEXTURE, (float)(x - 1), (float)(y - 1), 20.0f, 20.0f, p -> p.uv(0.0f, 0.0f, 0.5f, 1.0f));
            }
        });
        super.renderBackground(context, graphics, mouseX, mouseY, (Object)stack);
    }

    public void render(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, ItemStack stack) {
        ItemStack icon = BackpackItem.getIcon(stack);
        Holder hoveredStack = new Holder();
        Inventory inventory = ClientUtils.getPlayer().getInventory();
        IconSelectionScreen.forEachSlot((x, y, index) -> {
            ItemStack item = inventory.getItem(index);
            graphics.submitItem(item, (float)(x + 1), (float)(y + 1), p -> p.level(ClientUtils.getWorld()));
            if (!icon.isEmpty() && ItemStack.isSameItem((ItemStack)icon, (ItemStack)item)) {
                graphics.submitSprite(SLOT_HIGHLIGHT_TEXTURE, (float)(x - 1), (float)(y - 1), 20.0f, 20.0f, p -> p.uv(0.5f, 0.0f, 0.5f, 1.0f));
            }
            if (mouseX >= x && mouseX < x + 18 && mouseY >= y && mouseY < y + 18) {
                hoveredStack.set((Object)item);
            }
        });
        graphics.poseStack().pushMatrix();
        graphics.poseStack().translate(67.0f, 7.0f);
        graphics.poseStack().scale(2.625f, 2.625f);
        ItemStack preview = stack;
        if (hoveredStack.get() != null) {
            preview = preview.copy();
            BackpackItem.setIcon(preview, (ItemStack)hoveredStack.get());
        }
        graphics.submitItem(preview, 0.0f, 0.0f, p -> p.level(ClientUtils.getWorld()));
        graphics.poseStack().popMatrix();
        super.render(context, graphics, mouseX, mouseY, (Object)stack);
    }

    protected boolean mouseReleased(int mouseX, int mouseY, MouseButtonInfo info, boolean hasBeenHandled, ItemStack stack) {
        if (!hasBeenHandled && info.button() == 0) {
            Holder hoveredStack = new Holder();
            Inventory inventory = ClientUtils.getPlayer().getInventory();
            IconSelectionScreen.forEachSlot((x, y, index) -> {
                if (mouseX >= x && mouseX < x + 18 && mouseY >= y && mouseY < y + 18) {
                    hoveredStack.set((Object)inventory.getItem(index));
                }
            });
            if (hoveredStack.get() != null) {
                PackedUp.CHANNEL.sendToServer((BasePacket)new PacketSetIcon(this.hand, (ItemStack)hoveredStack.get()));
                ClientUtils.getMinecraft().setScreen((Screen)WidgetScreen.of((Widget)new BackpackCustomizationScreen(this.hand)));
                hasBeenHandled = true;
            }
        }
        return super.mouseReleased(mouseX, mouseY, info, hasBeenHandled, (Object)stack);
    }

    protected boolean keyPressed(KeyEvent event, boolean hasBeenHandled, ItemStack object) {
        if (!hasBeenHandled && (ClientUtils.getMinecraft().options.keyInventory.matches(event) || event.isEscape())) {
            ClientUtils.getMinecraft().setScreen((Screen)WidgetScreen.of((Widget)new BackpackCustomizationScreen(this.hand)));
            hasBeenHandled = true;
        }
        return super.keyPressed(event, hasBeenHandled, (Object)object);
    }

    private static void forEachSlot(SlotFunction function) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int x = 7 + column * 18;
                int y = 68 + row * 18;
                function.apply(x, y, row * 9 + column + 9);
            }
        }
        for (int column = 0; column < 9; ++column) {
            int x = 7 + column * 18;
            int y = 126;
            function.apply(x, y, column);
        }
    }

    private static interface SlotFunction {
        public void apply(int var1, int var2, int var3);
    }
}

