/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup.packets;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.packedup.BackpackItem;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PacketRename
implements BasePacket {
    private InteractionHand hand;
    private String name;

    public PacketRename(InteractionHand hand, String name) {
        this.hand = hand;
        this.name = name == null ? null : name.trim();
    }

    public PacketRename() {
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.hand == InteractionHand.MAIN_HAND);
        buffer.writeBoolean(this.name != null);
        if (this.name != null) {
            buffer.writeUtf(this.name);
        }
    }

    public void read(FriendlyByteBuf buffer) {
        this.hand = buffer.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.name = buffer.readBoolean() ? buffer.readUtf(Short.MAX_VALUE) : "";
    }

    public void handle(PacketContext context) {
        Player player = context.getSendingPlayer();
        if (player != null) {
            ItemStack stack = player.getItemInHand(this.hand);
            if (stack.isEmpty() || !(stack.getItem() instanceof BackpackItem)) {
                return;
            }
            stack = stack.copy();
            if (this.name == null || this.name.isEmpty() || this.name.equals(TextComponents.item((Item)stack.getItem()).format())) {
                stack.remove(DataComponents.CUSTOM_NAME);
            } else {
                stack.set(DataComponents.CUSTOM_NAME, (Object)TextComponents.string((String)this.name).get());
            }
            player.setItemInHand(this.hand, stack);
        }
    }
}

