/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.packedup.BackpackItem;
import java.util.function.Consumer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.TrackingItemStackRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public class BackpackIconRenderer
implements ItemModel.Unbaked {
    public static final MapCodec<BackpackIconRenderer> CODEC = MapCodec.unit((Object)new BackpackIconRenderer());
    private static final SpecialModelRenderer<ItemStack> ICON_RENDERER = new SpecialModelRenderer<ItemStack>(){
        private static final ThreadLocal<Boolean> RECURSION_GUARD = ThreadLocal.withInitial(() -> false);

        public void submit(ItemStack icon, ItemDisplayContext displayContext, PoseStack poseStack, SubmitNodeCollector output, int combinedLight, int combinedOverlay, boolean hasFoil, int k) {
            if (RECURSION_GUARD.get() == Boolean.TRUE) {
                return;
            }
            RECURSION_GUARD.set(true);
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.4f, 1.0f);
            poseStack.scale(0.7f, 0.7f, 0.7f);
            TrackingItemStackRenderState trackingItemStackRenderState = new TrackingItemStackRenderState();
            ClientUtils.getMinecraft().getItemModelResolver().updateForTopItem((ItemStackRenderState)trackingItemStackRenderState, icon, ItemDisplayContext.GUI, null, null, k);
            trackingItemStackRenderState.submit(poseStack, output, combinedLight, combinedOverlay, k);
            poseStack.popPose();
            RECURSION_GUARD.remove();
        }

        public void getExtents(Consumer<Vector3fc> set) {
        }

        @Nullable
        public ItemStack extractArgument(ItemStack stack) {
            return null;
        }
    };

    public MapCodec<? extends ItemModel.Unbaked> type() {
        return CODEC;
    }

    public ItemModel bake(ItemModel.BakingContext context) {
        return (renderState, stack, modelResolver, transformType, level, entity, someRandomId) -> {
            renderState.appendModelIdentityElement((Object)this);
            if (transformType != ItemDisplayContext.GUI) {
                return;
            }
            ItemStack icon = BackpackItem.getIcon(stack);
            if (!icon.isEmpty()) {
                renderState.newLayer().setupSpecialModel(ICON_RENDERER, (Object)icon);
                renderState.appendModelIdentityElement((Object)icon.getItem());
            }
        };
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
    }
}

