/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.network;

import net.blay09.mods.inventoryessentials.ServerInventoryTransfers;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public record SingleTransferMessage(int slotNumber) implements CustomPacketPayload
{
    public static CustomPacketPayload.Type<SingleTransferMessage> TYPE = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"inventoryessentials", (String)"single_transfer"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SingleTransferMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SingleTransferMessage::slotNumber, SingleTransferMessage::new);

    public static void handle(ServerPlayer player, SingleTransferMessage message) {
        AbstractContainerMenu menu = player.containerMenu;
        if (menu != null && message.slotNumber >= 0 && message.slotNumber < menu.slots.size()) {
            Slot slot = (Slot)menu.slots.get(message.slotNumber);
            ServerInventoryTransfers.singleTransfer(player, menu, slot);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

