/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.render.MutableCustomItemRendererContext;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public interface CustomItemRenderer<S> {
    public static <T> SpecialModelRenderer<?> toSpecialModelRenderer(final CustomItemRenderer<T> customRenderer) {
        final MutableCustomItemRendererContext context = new MutableCustomItemRendererContext();
        return new SpecialModelRenderer<T>(){

            public void submit(T state, ItemDisplayContext displayContext, PoseStack poseStack, SubmitNodeCollector output, int combinedLight, int combinedOverlay, boolean hasFoil, int k) {
                context.set(displayContext, poseStack, combinedLight, combinedOverlay);
                customRenderer.submit(output, state, hasFoil, context);
            }

            public void getExtents(Consumer<Vector3fc> consumer) {
                customRenderer.getExtents(consumer);
            }

            @Nullable
            public T extractArgument(ItemStack stack) {
                return customRenderer.extractState(stack);
            }
        };
    }

    @Nullable
    public S extractState(ItemStack var1);

    public void submit(SubmitNodeCollector var1, S var2, boolean var3, RenderContext var4);

    public void render(ItemStack var1, ItemDisplayContext var2, PoseStack var3, MultiBufferSource var4, int var5, int var6);

    public void getExtents(Consumer<Vector3fc> var1);

    public static interface RenderContext {
        public ItemDisplayContext displayContext();

        public PoseStack poseStack();

        public int packedLight();

        public int packedBreakingOverlay();
    }
}

