/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.render.MutableCustomBlockEntityRendererContext;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface CustomBlockEntityRenderer<T extends BlockEntity, S> {
    public static <T extends BlockEntity, S> BlockEntityRenderer<T, ?> of(final CustomBlockEntityRenderer<T, S> customRenderer) {
        return new BlockEntityRenderer<T, MutableCustomBlockEntityRendererContext<S>>(){

            public MutableCustomBlockEntityRendererContext<S> createRenderState() {
                MutableCustomBlockEntityRendererContext context = new MutableCustomBlockEntityRendererContext();
                context.setState(customRenderer.createStateHolder());
                return context;
            }

            public void extractRenderState(T entity, MutableCustomBlockEntityRendererContext<S> state, float partialTicks, Vec3 camera, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
                state.setForUpdate((BlockEntity)entity, partialTicks, camera, crumblingOverlay);
                customRenderer.updateState(state.getState(), entity, state);
            }

            public void submit(MutableCustomBlockEntityRendererContext<S> state, PoseStack poseStack, SubmitNodeCollector output, CameraRenderState cameraRenderState) {
                state.setForSubmit(poseStack, cameraRenderState);
                customRenderer.submit(output, state.getState(), state);
            }
        };
    }

    public S createStateHolder();

    public void updateState(S var1, T var2, UpdateContext var3);

    public void submit(SubmitNodeCollector var1, S var2, RenderContext var3);

    public static interface RenderContext {
        public float partialTicks();

        public PoseStack poseStack();

        public Vec3 cameraPos();

        public CameraRenderState cameraRenderState();

        public BlockPos pos();

        public BlockState blockState();

        public BlockEntityType<?> blockEntityType();

        public int packedLight();

        @Nullable
        public ModelFeatureRenderer.CrumblingOverlay breakingOverlay();

        public BlockEntityRenderState blockEntityRenderState();
    }

    public static interface UpdateContext {
        public float partialTicks();

        public Vec3 cameraPos();

        @Nullable
        public ModelFeatureRenderer.CrumblingOverlay breakingOverlay();
    }
}

