/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.mojang.serialization.MapCodec;
import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.core.render.CustomItemRenderer;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.core.util.TriFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModels;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.CreateSpecialBlockRendererEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterPictureInPictureRendererEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.ApiStatus;

public class ClientRegistrationHandler {
    private static final Map<String, ClientRegistrationHandler> REGISTRATION_HELPER_MAP = new TreeMap<String, ClientRegistrationHandler>();
    private static boolean haveModelsBeenRegistered = false;
    private final String modid;
    private final List<Pair<Identifier, Consumer<BlockStateModel>>> blockModelConsumers = new ArrayList<Pair<Identifier, Consumer<BlockStateModel>>>();
    private final List<Pair<Supplier<Block>, Function<BlockStateModel, BlockStateModel>>> blockModelOverwrites = new ArrayList<Pair<Supplier<Block>, Function<BlockStateModel, BlockStateModel>>>();
    private final List<Pair<Supplier<Item>, Function<ItemModel, ItemModel>>> itemModelOverwrites = new ArrayList<Pair<Supplier<Item>, Function<ItemModel, ItemModel>>>();
    private final List<Pair<Supplier<EntityType<?>>, Function<EntityRendererProvider.Context, EntityRenderer<?, ?>>>> entityRenderers = new ArrayList();
    private final List<Pair<Supplier<BlockEntityType<?>>, Function<BlockEntityRendererProvider.Context, BlockEntityRenderer<?, ?>>>> blockEntityRenderers = new ArrayList();
    private final Map<Identifier, Set<Identifier>> textureAtlasSprites = new HashMap<Identifier, Set<Identifier>>();
    private final List<Pair<Supplier<Block>, Supplier<SpecialModelRenderer.Unbaked>>> blockSpecialRenderers = new ArrayList<Pair<Supplier<Block>, Supplier<SpecialModelRenderer.Unbaked>>>();
    private final List<Pair<Supplier<MenuType<?>>, TriFunction<AbstractContainerMenu, Inventory, Component, Screen>>> containerScreens = new ArrayList();
    private final List<Pair<Supplier<Block>, Supplier<ChunkSectionLayer>>> blockRenderTypes = new ArrayList<Pair<Supplier<Block>, Supplier<ChunkSectionLayer>>>();
    private final List<Function<MultiBufferSource.BufferSource, PictureInPictureRenderer<?>>> pictureRenderers = new ArrayList();
    private boolean passedRegisterRenderers;
    private boolean passedTextureStitch;

    @ApiStatus.Internal
    public static void registerBlockModelConsumerDependenciesInternal(Predicate<Identifier> markModelDependency) {
        haveModelsBeenRegistered = true;
        REGISTRATION_HELPER_MAP.values().forEach(handler -> handler.registerBlockModelConsumerDependencies(markModelDependency));
    }

    @ApiStatus.Internal
    public static void applyBlockModelConsumersInternal(Function<Identifier, BlockStateModel> modelGetter) {
        REGISTRATION_HELPER_MAP.values().forEach(handler -> handler.handleBlockModelConsumers(modelGetter));
    }

    @ApiStatus.Internal
    public static void applyBlockModelOverwritesInternal(Map<BlockState, BlockStateModel> models) {
        REGISTRATION_HELPER_MAP.values().forEach(handler -> handler.applyBlockModelOverwrites(models));
    }

    @ApiStatus.Internal
    public static void applyItemModelOverwritesInternal(Map<Identifier, ItemModel> models) {
        REGISTRATION_HELPER_MAP.values().forEach(handler -> handler.applyItemModelOverwrites(models));
    }

    public static synchronized ClientRegistrationHandler get(String modid) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String activeMod = ModLoadingContext.get().getActiveNamespace();
        if (activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge")) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '" + ModLoadingContext.get().getActiveContainer().getModInfo().getDisplayName() + "' is requesting registration helper for different modid '" + modid + "'!");
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is requesting registration helper for modid '" + modid + "'!");
        }
        return REGISTRATION_HELPER_MAP.computeIfAbsent(modid, ClientRegistrationHandler::new);
    }

    @ApiStatus.Internal
    public static void collectSprites(Identifier atlas, Consumer<Identifier> spriteConsumer) {
        for (ClientRegistrationHandler value : REGISTRATION_HELPER_MAP.values()) {
            value.addSprites(atlas, spriteConsumer);
        }
    }

    private ClientRegistrationHandler(String modid) {
        this.modid = modid;
        EntityRenderersEvent.RegisterRenderers.getBus((BusGroup)FMLJavaModLoadingContext.get().getModBusGroup()).addListener(this::handleRegisterRenderersEvent);
        CreateSpecialBlockRendererEvent.BUS.addListener(this::handleRegisterSpecialBlockModelRenderersEvent);
        RegisterPictureInPictureRendererEvent.BUS.addListener(this::handleRegisterPictureInPictureRenderersEvent);
    }

    public void registerBlockModelConsumer(Identifier location, Consumer<BlockStateModel> consumer) {
        if (haveModelsBeenRegistered) {
            throw new IllegalStateException("Cannot register new model consumer after model registry has been completed!");
        }
        this.blockModelConsumers.add(Pair.of(location, consumer));
    }

    public void registerBlockModelConsumer(String namespace, String identifier, Consumer<BlockStateModel> consumer) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        this.registerBlockModelConsumer(Identifier.fromNamespaceAndPath((String)namespace, (String)identifier), consumer);
    }

    public void registerBlockModelConsumer(String identifier, Consumer<BlockStateModel> consumer) {
        this.registerBlockModelConsumer(this.modid, identifier, consumer);
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, Function<BlockStateModel, BlockStateModel> modelOverwrite) {
        if (haveModelsBeenRegistered) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        this.blockModelOverwrites.add(Pair.of(block, modelOverwrite));
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, Supplier<BlockStateModel> modelOverwrite) {
        this.registerBlockModelOverwrite(block, (BlockStateModel model) -> (BlockStateModel)modelOverwrite.get());
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, BlockStateModel modelOverwrite) {
        this.registerBlockModelOverwrite(block, (BlockStateModel model) -> modelOverwrite);
    }

    public void registerItemModelOverwrite(Supplier<Item> item, Function<ItemModel, ItemModel> modelOverwrite) {
        if (haveModelsBeenRegistered) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        this.itemModelOverwrites.add(Pair.of(item, modelOverwrite));
    }

    public void registerItemModelOverwrite(Supplier<Item> item, Supplier<ItemModel> modelOverwrite) {
        this.registerItemModelOverwrite(item, (ItemModel model) -> (ItemModel)modelOverwrite.get());
    }

    public void registerItemModelOverwrite(Supplier<Item> item, ItemModel modelOverwrite) {
        this.registerItemModelOverwrite(item, (ItemModel model) -> modelOverwrite);
    }

    public <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> entityType, Function<EntityRendererProvider.Context, EntityRenderer<? super T, ?>> entityRenderer) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new renderers after RegisterRenderers has been fired!");
        }
        this.entityRenderers.add(Pair.of(entityType, entityRenderer));
    }

    public <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> entityType, Supplier<EntityRenderer<? super T, ?>> entityRenderer) {
        this.registerEntityRenderer(entityType, (EntityRendererProvider.Context context) -> (EntityRenderer)entityRenderer.get());
    }

    public <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> entityType, EntityRenderer<? super T, ?> entityRenderer) {
        this.registerEntityRenderer(entityType, (EntityRendererProvider.Context context) -> entityRenderer);
    }

    public <T extends BlockEntity> void registerBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, Function<BlockEntityRendererProvider.Context, BlockEntityRenderer<? super T, ?>> blockEntityRenderer) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new renderers after RegisterRenderers has been fired!");
        }
        this.blockEntityRenderers.add(Pair.of(entityType, blockEntityRenderer));
    }

    public <T extends BlockEntity> void registerBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, Supplier<BlockEntityRenderer<? super T, ?>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (BlockEntityRendererProvider.Context context) -> (BlockEntityRenderer)blockEntityRenderer.get());
    }

    public <T extends BlockEntity> void registerBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, BlockEntityRenderer<? super T, ?> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (BlockEntityRendererProvider.Context context) -> blockEntityRenderer);
    }

    public <T extends BlockEntity> void registerCustomBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, Supplier<CustomBlockEntityRenderer<? super T, ?>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (BlockEntityRendererProvider.Context context) -> CustomBlockEntityRenderer.of((CustomBlockEntityRenderer)blockEntityRenderer.get()));
    }

    public <T extends BlockEntity> void registerCustomBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, CustomBlockEntityRenderer<? super T, ?> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (BlockEntityRendererProvider.Context context) -> CustomBlockEntityRenderer.of(blockEntityRenderer));
    }

    public void registerAtlasSprite(Identifier textureAtlas, Identifier spriteLocation) {
        if (this.passedTextureStitch) {
            throw new IllegalStateException("Cannot register new models after TextureStitchEvent has been fired!");
        }
        if (textureAtlas == null) {
            throw new IllegalArgumentException("Texture atlas must not be null!");
        }
        if (textureAtlas.getPath().startsWith("textures/atlas/") && textureAtlas.getPath().endsWith(".png")) {
            textureAtlas = Identifier.fromNamespaceAndPath((String)textureAtlas.getNamespace(), (String)textureAtlas.getPath().substring("textures/atlas/".length(), textureAtlas.getPath().length() - ".png".length()));
        }
        this.textureAtlasSprites.putIfAbsent(textureAtlas, new HashSet());
        if (this.textureAtlasSprites.get(textureAtlas).contains(spriteLocation)) {
            throw new RuntimeException("Duplicate sprite registration '" + String.valueOf(spriteLocation) + "' for atlas '" + String.valueOf(textureAtlas) + "'!");
        }
        this.textureAtlasSprites.get(textureAtlas).add(spriteLocation);
    }

    public void registerAtlasSprite(Identifier textureAtlas, String spriteLocation) {
        if (!RegistryUtil.isValidPath(spriteLocation)) {
            throw new IllegalArgumentException("Sprite location '" + spriteLocation + "' must only contain characters [a-z0-9_./-]!");
        }
        this.registerAtlasSprite(textureAtlas, Identifier.fromNamespaceAndPath((String)this.modid, (String)spriteLocation));
    }

    public void registerSpecialModelRenderer(String identifier, MapCodec<? extends SpecialModelRenderer.Unbaked> codec) {
        SpecialModelRenderers.ID_MAPPER.put((Object)Identifier.fromNamespaceAndPath((String)this.modid, (String)identifier), codec);
    }

    public void registerBlockSpecialModelRenderer(Supplier<Block> block, Supplier<SpecialModelRenderer.Unbaked> renderer) {
        this.blockSpecialRenderers.add(Pair.of(block, renderer));
    }

    public void registerBlockSpecialModelRenderer(Block block, SpecialModelRenderer.Unbaked renderer) {
        this.registerBlockSpecialModelRenderer(() -> block, () -> renderer);
    }

    public void registerCustomItemRenderer(String identifier, final Supplier<CustomItemRenderer> itemRenderer) {
        final Holder<MapCodec> holder = new Holder<MapCodec>();
        MapCodec codec = MapCodec.unit((Object)new SpecialModelRenderer.Unbaked(){
            SpecialModelRenderer<?> renderer = null;

            public SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext context) {
                if (this.renderer == null) {
                    this.renderer = CustomItemRenderer.toSpecialModelRenderer((CustomItemRenderer)itemRenderer.get());
                }
                return this.renderer;
            }

            public MapCodec<? extends SpecialModelRenderer.Unbaked> type() {
                return (MapCodec)holder.get();
            }
        });
        holder.set(codec);
        this.registerSpecialModelRenderer(identifier, (MapCodec<? extends SpecialModelRenderer.Unbaked>)codec);
    }

    public void registerCustomItemRenderer(String identifier, CustomItemRenderer itemRenderer) {
        this.registerCustomItemRenderer(identifier, () -> itemRenderer);
    }

    public <T extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(Supplier<MenuType<T>> menuType, TriFunction<T, Inventory, Component, U> screenSupplier) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new menu screens after the ClientInitialization event has been fired!");
        }
        this.containerScreens.add(Pair.of(menuType, screenSupplier));
    }

    public <T extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(Supplier<MenuType<T>> menuType, Function<T, U> screenSupplier) {
        this.registerContainerScreen(menuType, (T container, Inventory inventory, Component title) -> (Screen)screenSupplier.apply(container));
    }

    public <T extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(MenuType<T> menuType, TriFunction<T, Inventory, Component, U> screenSupplier) {
        this.registerContainerScreen(() -> menuType, screenSupplier);
    }

    public <T extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(MenuType<T> menuType, Function<T, U> screenSupplier) {
        this.registerContainerScreen(() -> menuType, (T container, Inventory inventory, Component title) -> (Screen)screenSupplier.apply(container));
    }

    public void registerBlockModelRenderType(Supplier<Block> block, Supplier<ChunkSectionLayer> renderTypeSupplier) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new menu screens after the ClientInitialization event has been fired!");
        }
        this.blockRenderTypes.add(Pair.of(block, renderTypeSupplier));
    }

    public void registerBlockModelRenderType(Supplier<Block> block, ChunkSectionLayer renderType) {
        this.registerBlockModelRenderType(block, () -> renderType);
    }

    public void registerBlockModelRenderType(Block block, Supplier<ChunkSectionLayer> renderTypeSupplier) {
        this.registerBlockModelRenderType(() -> block, renderTypeSupplier);
    }

    public void registerBlockModelRenderType(Block block, ChunkSectionLayer renderType) {
        this.registerBlockModelRenderType(() -> block, renderType);
    }

    public void registerBlockModelSolidRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, ChunkSectionLayer.SOLID);
    }

    public void registerBlockModelSolidRenderType(Block block) {
        this.registerBlockModelRenderType(block, ChunkSectionLayer.SOLID);
    }

    public void registerBlockModelCutoutRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, ChunkSectionLayer.CUTOUT);
    }

    public void registerBlockModelCutoutRenderType(Block block) {
        this.registerBlockModelRenderType(block, ChunkSectionLayer.CUTOUT);
    }

    public void registerBlockModelTranslucentRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, ChunkSectionLayer.TRANSLUCENT);
    }

    public void registerBlockModelTranslucentRenderType(Block block) {
        this.registerBlockModelRenderType(block, ChunkSectionLayer.TRANSLUCENT);
    }

    public void registerItemModelType(String identifier, MapCodec<? extends ItemModel.Unbaked> codec) {
        ItemModels.ID_MAPPER.put((Object)Identifier.fromNamespaceAndPath((String)this.modid, (String)identifier), codec);
    }

    public void registerPictureInPictureRenderer(Function<MultiBufferSource.BufferSource, PictureInPictureRenderer<?>> renderer) {
        this.pictureRenderers.add(renderer);
    }

    public void registerPictureInPictureRenderer(Supplier<PictureInPictureRenderer<?>> renderer) {
        this.registerPictureInPictureRenderer((MultiBufferSource.BufferSource buffers) -> (PictureInPictureRenderer)renderer.get());
    }

    private void handleRegisterRenderersEvent(EntityRenderersEvent.RegisterRenderers e) {
        this.passedRegisterRenderers = true;
        HashSet entityTypes = new HashSet();
        for (Pair<Supplier<EntityType<?>>, Function<EntityRendererProvider.Context, EntityRenderer<?, ?>>> entry : this.entityRenderers) {
            EntityType<?> entityType = entry.left().get();
            if (entityType == null) {
                throw new RuntimeException("Entity renderer registered with null entity type!");
            }
            if (entityTypes.contains(entityType)) {
                throw new RuntimeException("Duplicate entity renderer for entity type '" + String.valueOf(Registries.ENTITY_TYPES.getIdentifier(entityType)) + "'!");
            }
            entityTypes.add(entityType);
            e.registerEntityRenderer(entityType, ((Function)entry.right())::apply);
        }
        HashSet<BlockEntityType> blockEntityTypes = new HashSet<BlockEntityType>();
        for (Pair pair : this.blockEntityRenderers) {
            BlockEntityType blockEntityType = (BlockEntityType)((Supplier)pair.left()).get();
            if (blockEntityType == null) {
                throw new RuntimeException("Block entity renderer registered with null block entity type!");
            }
            if (blockEntityTypes.contains(blockEntityType)) {
                throw new RuntimeException("Duplicate block entity renderer for block entity type '" + String.valueOf(Registries.BLOCK_ENTITY_TYPES.getIdentifier(blockEntityType)) + "'!");
            }
            blockEntityTypes.add(blockEntityType);
            e.registerBlockEntityRenderer(blockEntityType, ((Function)pair.right())::apply);
        }
        HashSet menuTypes = new HashSet();
        for (Pair<Supplier<MenuType<?>>, TriFunction<AbstractContainerMenu, Inventory, Component, Screen>> pair : this.containerScreens) {
            MenuType<?> menuType = pair.left().get();
            if (menuType == null) {
                throw new RuntimeException("Container screen registered with null menu type!");
            }
            if (menuTypes.contains(menuType)) {
                throw new RuntimeException("Duplicate container screen for menu type '" + String.valueOf(Registries.MENU_TYPES.getIdentifier(menuType)) + "'!");
            }
            menuTypes.add(menuType);
            MenuScreens.register(menuType, pair.right()::apply);
        }
        HashSet<Block> hashSet = new HashSet<Block>();
        for (Pair<Supplier<Block>, Supplier<ChunkSectionLayer>> entry : this.blockRenderTypes) {
            Block block = entry.left().get();
            if (block == null) {
                throw new RuntimeException("Block render layer registered for null block!");
            }
            if (hashSet.contains(block)) {
                throw new RuntimeException("Duplicate render layer for block '" + String.valueOf(Registries.BLOCKS.getIdentifier(block)) + "'!");
            }
            ChunkSectionLayer layer = entry.right().get();
            if (layer == null) {
                throw new RuntimeException("Got null render layer for block '" + String.valueOf(Registries.BLOCKS.getIdentifier(block)) + "'!");
            }
            hashSet.add(block);
            ItemBlockRenderTypes.setRenderLayer((Block)block, (ChunkSectionLayer)layer);
        }
    }

    private void handleRegisterSpecialBlockModelRenderersEvent(CreateSpecialBlockRendererEvent e) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (Pair<Supplier<Block>, Supplier<SpecialModelRenderer.Unbaked>> entry : this.blockSpecialRenderers) {
            Block block = entry.left().get();
            if (block == null) {
                throw new RuntimeException("Special model renderer registered for null block!");
            }
            if (blocks.contains(block)) {
                throw new RuntimeException("Duplicate special model renderer for block '" + String.valueOf(Registries.BLOCKS.getIdentifier(block)) + "'!");
            }
            SpecialModelRenderer.Unbaked renderer = entry.right().get();
            if (renderer == null) {
                throw new RuntimeException("Got null special model renderer for block '" + String.valueOf(Registries.BLOCKS.getIdentifier(block)) + "'!");
            }
            blocks.add(block);
            e.register(block, renderer);
        }
    }

    private void registerBlockModelConsumerDependencies(Predicate<Identifier> markModelDependency) {
        HashSet<Identifier> missingModels = null;
        for (Pair<Identifier, Consumer<BlockStateModel>> consumer : this.blockModelConsumers) {
            Identifier location = consumer.left();
            if (markModelDependency.test(location)) continue;
            if (missingModels == null) {
                missingModels = new HashSet<Identifier>();
            }
            missingModels.add(location);
        }
        if (missingModels != null) {
            CoreLib.LOGGER.error("Missing models for block model consumers from mod '{}': {}", (Object)this.modid, (Object)missingModels.stream().map(l -> "'" + String.valueOf(l) + "'").collect(Collectors.joining(", ")));
        }
    }

    private void handleBlockModelConsumers(Function<Identifier, BlockStateModel> modelGetter) {
        for (Pair<Identifier, Consumer<BlockStateModel>> entry : this.blockModelConsumers) {
            try {
                entry.right().accept(modelGetter.apply(entry.left()));
            }
            catch (Exception e) {
                CoreLib.LOGGER.error("Encountered an exception whilst applying a model consumer for mod '{}'!", (Object)this.modid, (Object)e);
            }
        }
    }

    private void applyBlockModelOverwrites(Map<BlockState, BlockStateModel> models) {
        for (Pair<Supplier<Block>, Function<BlockStateModel, BlockStateModel>> overwrite : this.blockModelOverwrites) {
            Block block = overwrite.left().get();
            if (block == null) {
                CoreLib.LOGGER.error("Got 'null' block for block model overwrite from mod '{}'!", (Object)this.modid);
                continue;
            }
            for (BlockState state : block.getStateDefinition().getPossibleStates()) {
                BlockStateModel model = models.get(state);
                if (model == null) continue;
                try {
                    model = overwrite.right().apply(model);
                }
                catch (Exception e) {
                    CoreLib.LOGGER.error("Encountered an error while applying block model overwrite from mod '{}' for block state '{}'!", new Object[]{this.modid, state, e});
                    continue;
                }
                if (model == null) {
                    CoreLib.LOGGER.error("Block model overwrite from mod '{}' for block state '{}' returned null!", (Object)this.modid, (Object)state);
                    continue;
                }
                models.put(state, model);
            }
        }
    }

    private void applyItemModelOverwrites(Map<Identifier, ItemModel> models) {
        for (Pair<Supplier<Item>, Function<ItemModel, ItemModel>> overwrite : this.itemModelOverwrites) {
            Item item = overwrite.left().get();
            if (item == null) {
                CoreLib.LOGGER.error("Got 'null' item for item model overwrite from mod '{}'!", (Object)this.modid);
                continue;
            }
            Identifier modelLocation = (Identifier)item.components().get(DataComponents.ITEM_MODEL);
            ItemModel model = models.get(modelLocation);
            if (model == null) continue;
            try {
                model = overwrite.right().apply(model);
            }
            catch (Exception e) {
                CoreLib.LOGGER.error("Encountered an error while applying item model overwrite from mod '{}' for item '{}'!", new Object[]{this.modid, item, e});
                continue;
            }
            if (model == null) {
                CoreLib.LOGGER.error("Item model overwrite from mod '{}' for item '{}' returned null!", (Object)this.modid, (Object)item);
                continue;
            }
            models.put(modelLocation, model);
        }
    }

    private void addSprites(Identifier atlas, Consumer<Identifier> spriteConsumer) {
        this.passedTextureStitch = true;
        Set<Identifier> sprites = this.textureAtlasSprites.get(atlas);
        if (sprites == null) {
            return;
        }
        sprites.forEach(spriteConsumer);
    }

    private void handleRegisterPictureInPictureRenderersEvent(RegisterPictureInPictureRendererEvent e) {
        HashSet<Class> stateClasses = new HashSet<Class>();
        for (Function<MultiBufferSource.BufferSource, PictureInPictureRenderer<?>> function : this.pictureRenderers) {
            PictureInPictureRenderer<?> renderer = function.apply(e.getBufferSource());
            if (!stateClasses.add(renderer.getRenderStateClass())) {
                CoreLib.LOGGER.warn("Found multiple picture in picture renderers from mod '{}' registered for the same state class '{}'!", (Object)this.modid, (Object)renderer.getRenderStateClass());
            }
            e.register(renderer);
        }
    }
}

